/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tropicraft.core.common.block.tileentity.TileEntityBambooChest;
import net.tropicraft.core.common.enums.TropicraftPlanks;
import net.tropicraft.core.common.worldgen.TCDirectionalGen;
import net.tropicraft.core.common.worldgen.TCGenUtils;
import net.tropicraft.core.registry.BlockRegistry;
import net.tropicraft.core.registry.ItemRegistry;

public class WorldGenSunkenShip
extends TCDirectionalGen {
    private static final IBlockState PLANK_STATE = BlockRegistry.planks.defaultForVariant(TropicraftPlanks.MAHOGANY);

    public WorldGenSunkenShip(World world, Random random) {
        super(world, random, random.nextInt(4));
    }

    @Override
    public boolean generate(BlockPos pos) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        this.setOrigin(i, k);
        if (TCGenUtils.getBlock((IBlockAccess)this.worldObj, i, j + 4, k) != BlockRegistry.tropicsWater) {
            return false;
        }
        int length = this.rand.nextInt(25) + 25;
        int y = ++j;
        while (true) {
            boolean hasGenned = false;
            int fib = 2;
            int lastFib = 1;
            int width = y - j;
            for (int x = 0; x < length; ++x) {
                if (x == fib && (double)x <= (double)length / 3.0) {
                    ++width;
                    lastFib = (fib += lastFib) - lastFib;
                }
                if (x > length - 3) {
                    --width;
                }
                if (width < 0) continue;
                for (int z = -width; z <= width; ++z) {
                    if (this.rand.nextInt(5) >= 3) continue;
                    if (y == j || x == length - 1) {
                        this.placeBlockWithDir(x, y, z, PLANK_STATE);
                        if (z == -width || z == width || x == length - 1) {
                            this.placeBlockWithDir(x, y + 1, z, PLANK_STATE);
                        }
                        if (x != length / 2 || z != 0) continue;
                        this.placeBlockWithDir(x, y + 1, z, PLANK_STATE);
                        this.placeBlockWithDir(x, y + 2, z, PLANK_STATE);
                        this.placeBlockWithDir(x, y + 3, z, PLANK_STATE);
                        continue;
                    }
                    if (x == length / 2 && z == 0 && y == j - 2) {
                        this.placeBlockWithDir(x, y, z, BlockRegistry.bambooChest.func_176223_P());
                        BlockPos pos2 = new BlockPos(x, y, z);
                        TileEntityBambooChest chest = (TileEntityBambooChest)this.getTEWithDir(pos2);
                        if (chest == null) continue;
                        for (int b = 0; b < this.rand.nextInt(5) + 10; ++b) {
                            chest.func_70299_a(b, this.randLoot());
                        }
                        continue;
                    }
                    if (z == -width || z == width) {
                        this.placeBlockWithDir(x, y, z, PLANK_STATE);
                        continue;
                    }
                    this.placeBlockWithDir(x, y, z, Blocks.field_150350_a.func_176223_P());
                }
                hasGenned = true;
            }
            if (!hasGenned) break;
            --y;
        }
        return false;
    }

    public ItemStack randLoot() {
        int picker = this.rand.nextInt(20) + 1;
        if (picker < 6) {
            return new ItemStack((Block)BlockRegistry.bambooShoot, this.rand.nextInt(20) + 1);
        }
        switch (picker) {
            case 6: {
                if (this.rand.nextInt(250) == 0) {
                    return new ItemStack(ItemRegistry.nigelStache);
                }
                return new ItemStack(ItemRegistry.whitePearl, 2);
            }
            case 7: {
                return new ItemStack(ItemRegistry.scaleHelmet, 1);
            }
            case 8: {
                return new ItemStack(ItemRegistry.scaleChestplate, 1);
            }
            case 9: {
                return new ItemStack(ItemRegistry.scaleBoots, 1);
            }
            case 10: {
                return new ItemStack(ItemRegistry.scale, this.rand.nextInt(3) + 1);
            }
            case 11: {
                return new ItemStack(ItemRegistry.eudialyte, this.rand.nextInt(3) + 1);
            }
            case 12: {
                return new ItemStack(ItemRegistry.azurite, this.rand.nextInt(4) + 2);
            }
            case 13: {
                return new ItemStack(ItemRegistry.scaleLeggings, 1);
            }
            case 14: {
                return new ItemStack(ItemRegistry.recordBuriedTreasure, 1);
            }
            case 15: {
                return new ItemStack(ItemRegistry.recordEasternIsles, 1);
            }
            case 16: {
                return new ItemStack(ItemRegistry.recordLowTide, 1);
            }
            case 17: {
                return new ItemStack(ItemRegistry.recordSummering, 1);
            }
            case 18: {
                return new ItemStack(ItemRegistry.recordTheTribe, 1);
            }
            case 19: {
                return new ItemStack(ItemRegistry.recordTradeWinds, 1);
            }
        }
        return new ItemStack(ItemRegistry.zircon, 1);
    }
}

