/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tropicraft.core.common.block.BlockTropicraftLeaves;
import net.tropicraft.core.common.block.BlockTropicraftLog;
import net.tropicraft.core.common.enums.TropicraftLeaves;
import net.tropicraft.core.common.enums.TropicraftLogs;
import net.tropicraft.core.common.worldgen.TCGenBase;
import net.tropicraft.core.common.worldgen.TCGenUtils;
import net.tropicraft.core.registry.BlockRegistry;

public class WorldGenTallTree
extends TCGenBase {
    private static final int VINE_CHANCE = 5;
    private static final int SMALL_LEAF_CHANCE = 3;
    private static final int SECOND_CANOPY_CHANCE = 3;
    private static final IBlockState WOOD_BLOCK = BlockRegistry.logs.func_176223_P().func_177226_a(BlockTropicraftLog.VARIANT, (Comparable)((Object)TropicraftLogs.MAHOGANY));
    private static final IBlockState LEAF_BLOCK = BlockRegistry.leaves.func_176223_P().func_177226_a(BlockTropicraftLeaves.VARIANT, (Comparable)((Object)TropicraftLeaves.MAHOGANY));

    public WorldGenTallTree(World world, Random random) {
        super(world, random);
    }

    @Override
    public boolean generate(BlockPos pos) {
        int z;
        int x;
        int y;
        int k;
        int j;
        int i = pos.func_177958_n();
        Block blockUnder = TCGenUtils.getBlock((IBlockAccess)this.worldObj, i, (j = pos.func_177956_o()) - 1, k = pos.func_177952_p());
        if (blockUnder != Blocks.field_150346_d && blockUnder != Blocks.field_150349_c) {
            return false;
        }
        blockUnder = TCGenUtils.getBlock((IBlockAccess)this.worldObj, i + 1, j - 1, k);
        if (blockUnder != Blocks.field_150346_d && blockUnder != Blocks.field_150349_c) {
            return false;
        }
        blockUnder = TCGenUtils.getBlock((IBlockAccess)this.worldObj, i - 1, j - 1, k);
        if (blockUnder != Blocks.field_150346_d && blockUnder != Blocks.field_150349_c) {
            return false;
        }
        blockUnder = TCGenUtils.getBlock((IBlockAccess)this.worldObj, i, j - 1, k + 1);
        if (blockUnder != Blocks.field_150346_d && blockUnder != Blocks.field_150349_c) {
            return false;
        }
        blockUnder = TCGenUtils.getBlock((IBlockAccess)this.worldObj, i, j - 1, k - 1);
        if (blockUnder != Blocks.field_150346_d && blockUnder != Blocks.field_150349_c) {
            return false;
        }
        int height = this.rand.nextInt(15) + 15;
        for (y = j; y < j + height + 6; ++y) {
            for (x = i - 1; x <= i + 1; ++x) {
                for (z = k - 1; z <= k + 1; ++z) {
                    Block block = TCGenUtils.getBlock((IBlockAccess)this.worldObj, x, y, z);
                    if (block == Blocks.field_150350_a || block == Blocks.field_150329_H || block == LEAF_BLOCK) continue;
                    return false;
                }
            }
        }
        TCGenUtils.setBlockState(this.worldObj, i, j, k, Blocks.field_150346_d.func_176223_P(), blockGenNotifyFlag);
        TCGenUtils.setBlockState(this.worldObj, i - 1, j, k, Blocks.field_150346_d.func_176223_P(), blockGenNotifyFlag);
        TCGenUtils.setBlockState(this.worldObj, i + 1, j, k, Blocks.field_150346_d.func_176223_P(), blockGenNotifyFlag);
        TCGenUtils.setBlockState(this.worldObj, i, j, k - 1, Blocks.field_150346_d.func_176223_P(), blockGenNotifyFlag);
        TCGenUtils.setBlockState(this.worldObj, i, j, k + 1, Blocks.field_150346_d.func_176223_P(), blockGenNotifyFlag);
        for (y = j; y < j + height; ++y) {
            int nz;
            int nx;
            TCGenUtils.setBlockState(this.worldObj, i, y, k, WOOD_BLOCK, blockGenNotifyFlag);
            TCGenUtils.setBlockState(this.worldObj, i - 1, y, k, WOOD_BLOCK, blockGenNotifyFlag);
            TCGenUtils.setBlockState(this.worldObj, i + 1, y, k, WOOD_BLOCK, blockGenNotifyFlag);
            TCGenUtils.setBlockState(this.worldObj, i, y, k - 1, WOOD_BLOCK, blockGenNotifyFlag);
            TCGenUtils.setBlockState(this.worldObj, i, y, k + 1, WOOD_BLOCK, blockGenNotifyFlag);
            if (y - j > height / 2 && this.rand.nextInt(3) == 0) {
                nx = this.rand.nextInt(3) - 1 + i;
                nz = this.rand.nextInt(3) - 1 + k;
                this.genCircle(nx, y + 1, nz, 1.0, 0.0, LEAF_BLOCK, false);
                this.genCircle(nx, y, nz, 2.0, 1.0, LEAF_BLOCK, false);
                for (int x2 = nx - 3; x2 <= nx + 3; ++x2) {
                    for (int z2 = nz - 3; z2 <= nz + 3; ++z2) {
                        for (int y1 = y - 1; y1 <= y; ++y1) {
                            if (this.rand.nextInt(5) != 0) continue;
                            this.genVines(x2, y1, z2);
                        }
                    }
                }
            }
            if (y - j <= height - height / 4 || y - j >= height - 3 || this.rand.nextInt(3) != 0) continue;
            nx = i + this.rand.nextInt(9) - 4;
            nz = k + this.rand.nextInt(9) - 4;
            int leafSize = this.rand.nextInt(3) + 5;
            this.genCircle(nx, y + 3, nz, leafSize - 2, 0.0, LEAF_BLOCK, false);
            this.genCircle(nx, y + 2, nz, leafSize - 1, leafSize - 3, LEAF_BLOCK, false);
            this.genCircle(nx, y + 1, nz, leafSize, leafSize - 1, LEAF_BLOCK, false);
            this.placeBlockLine(new int[]{i, y - 2, k}, new int[]{nx, y + 2, nz}, WOOD_BLOCK);
            for (int x3 = nx - leafSize; x3 <= nx + leafSize; ++x3) {
                for (int z3 = nz - leafSize; z3 <= nz + leafSize; ++z3) {
                    for (int y1 = y; y1 <= y + 2; ++y1) {
                        if (this.rand.nextInt(5) != 0) continue;
                        this.genVines(x3, y1, z3);
                    }
                }
            }
        }
        int leafSize = this.rand.nextInt(5) + 9;
        this.genCircle(i, j + height, k, leafSize - 2, 0.0, LEAF_BLOCK, false);
        this.genCircle(i, j + height - 1, k, leafSize - 1, leafSize - 4, LEAF_BLOCK, false);
        this.genCircle(i, j + height - 2, k, leafSize, leafSize - 1, LEAF_BLOCK, false);
        for (x = i - leafSize; x <= i + leafSize; ++x) {
            for (z = k - leafSize; z <= k + leafSize; ++z) {
                for (int y1 = j + height + 3; y1 <= j + height + 6; ++y1) {
                    if (this.rand.nextInt(5) != 0) continue;
                    this.genVines(x, y1, z);
                }
            }
        }
        return true;
    }

    private boolean genVines(int i, int j, int k) {
        int m = 2;
        while (true) {
            if (m > 5) {
                return false;
            }
            if (Blocks.field_150395_bd.func_176198_a(this.worldObj, new BlockPos(i, j, k), EnumFacing.func_176731_b((int)m)) && TCGenUtils.getBlock((IBlockAccess)this.worldObj, i, j, k) == Blocks.field_150350_a) break;
            ++m;
        }
        TCGenUtils.setBlockState(this.worldObj, i, j, k, Blocks.field_150395_bd.func_176223_P(), blockGenNotifyFlag);
        int length = this.rand.nextInt(4) + 4;
        for (int y = j - 1; y > j - length; --y) {
            if (TCGenUtils.getBlock((IBlockAccess)this.worldObj, i, y, k) != Blocks.field_150350_a) {
                return true;
            }
            TCGenUtils.setBlockState(this.worldObj, i, y, k, Blocks.field_150395_bd.func_176223_P(), blockGenNotifyFlag);
        }
        return true;
    }
}

