/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tropicraft.core.common.block.BlockTropicsFlowers;
import net.tropicraft.core.common.enums.TropicraftFlowers;
import net.tropicraft.core.common.worldgen.TCGenBase;
import net.tropicraft.core.common.worldgen.TCGenUtils;
import net.tropicraft.core.registry.BlockRegistry;

public class WorldGenTropicalFlowers
extends TCGenBase {
    private static final int FLOWER_TRIES = 35;
    private Block plantBlock;
    private TropicraftFlowers[] flowers;

    public WorldGenTropicalFlowers(World world, Random rand, Block plantBlock) {
        super(world, rand);
        this.plantBlock = plantBlock;
        this.flowers = TropicraftFlowers.VALUES;
    }

    public WorldGenTropicalFlowers(World world, Random rand, Block plantBlock, TropicraftFlowers[] flowers) {
        super(world, rand);
        this.plantBlock = plantBlock;
        this.flowers = flowers;
    }

    @Override
    public boolean generate(BlockPos pos) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        for (int l = 0; l < 35; ++l) {
            int x = i + this.rand.nextInt(8) - this.rand.nextInt(8);
            int y = j + this.rand.nextInt(4) - this.rand.nextInt(4);
            int z = k + this.rand.nextInt(8) - this.rand.nextInt(8);
            BlockPos pos2 = new BlockPos(x, y, z);
            if (!TCGenUtils.isAirBlock((IBlockAccess)this.worldObj, x, y, z) || !BlockRegistry.flowers.func_180671_f(this.worldObj, pos2, BlockRegistry.flowers.func_176223_P()) || this.rand.nextInt(3) != 0) continue;
            int meta = this.rand.nextInt(this.flowers.length);
            TropicraftFlowers flowerEnum = this.flowers[meta];
            while (flowerEnum == TropicraftFlowers.MAGIC_MUSHROOM) {
                meta = this.rand.nextInt(this.flowers.length);
                flowerEnum = this.flowers[meta];
            }
            TCGenUtils.setBlockState(this.worldObj, x, y, z, this.plantBlock.func_176223_P().func_177226_a(BlockTropicsFlowers.VARIANT, (Comparable)((Object)flowerEnum)), blockGenNotifyFlag);
        }
        return true;
    }
}

