/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldSavedData;
import net.tropicraft.core.common.block.BlockTropicraftSands;
import net.tropicraft.core.common.enums.TropicraftSands;
import net.tropicraft.core.common.worldgen.TCGenBase;
import net.tropicraft.core.registry.BlockRegistry;
import net.tropicraft.core.registry.LootRegistry;

public class WorldGenTropicsTreasure
extends TCGenBase {
    private static final List<Block> sandBlocks = new ArrayList<Block>();

    public WorldGenTropicsTreasure(World worldObj, Random rand) {
        super(worldObj, rand);
        sandBlocks.add((Block)Blocks.field_150354_m);
        sandBlocks.add(Blocks.field_150322_A);
        sandBlocks.add(BlockRegistry.sands);
    }

    @Override
    public boolean generate(BlockPos pos) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        int depth = this.rand.nextInt(1) + 2;
        IBlockState coloredSand = BlockRegistry.sands.func_176194_O().func_177621_b().func_177226_a(BlockTropicraftSands.VARIANT, (Comparable)((Object)TropicraftSands.getRandomSand(this.worldObj.field_73012_v)));
        block0: for (int tries = 0; tries < 10; ++tries) {
            int x = i + this.rand.nextInt(4) - this.rand.nextInt(4);
            int z = k + this.rand.nextInt(4) - this.rand.nextInt(4);
            int y = j = this.getTerrainHeightAt(x, z) - 1;
            int sandArea = 2;
            for (int surroundZ = z - sandArea; surroundZ <= z + sandArea; ++surroundZ) {
                for (int surroundX = x - sandArea; surroundX <= x + sandArea; ++surroundX) {
                    BlockPos pos3 = new BlockPos(surroundX, j, surroundZ);
                    if (!sandBlocks.contains(this.worldObj.func_180495_p(pos3).func_177230_c())) continue block0;
                }
            }
            BlockPos chestPos = new BlockPos(x, y - depth, z);
            if (!sandBlocks.contains(this.worldObj.func_180495_p(chestPos).func_177230_c())) continue;
            BlockPos xPos = new BlockPos(x - sandArea, j, z - sandArea);
            this.worldObj.func_175656_a(xPos, coloredSand);
            for (int count = 0; count <= sandArea; ++count) {
                this.worldObj.func_175656_a(xPos.func_177982_a(-count, 0, -count), coloredSand);
                this.worldObj.func_175656_a(xPos.func_177982_a(count, 0, count), coloredSand);
                this.worldObj.func_175656_a(xPos.func_177982_a(count, 0, -count), coloredSand);
                this.worldObj.func_175656_a(xPos.func_177982_a(-count, 0, count), coloredSand);
            }
            if (!this.worldObj.field_72995_K) {
                chestPos = new BlockPos(x - sandArea, y - depth, z - sandArea);
                this.worldObj.func_180501_a(chestPos, BlockRegistry.bambooChest.func_176223_P(), 2);
                TileEntityChest chest = (TileEntityChest)this.worldObj.func_175625_s(chestPos);
                if (chest == null) {
                    return false;
                }
                chest.func_189404_a(LootRegistry.buriedTreasure, this.rand.nextLong());
                ItemStack map = new ItemStack((Item)Items.field_151098_aY);
                this.initializeMap(this.worldObj, map, chestPos);
                chest.func_70299_a(this.rand.nextInt(chest.func_70302_i_()), map);
            }
            return true;
        }
        return true;
    }

    private void initializeMap(World worldObj, ItemStack mapItem, BlockPos pos) {
        mapItem.func_77964_b(worldObj.func_72841_b("map"));
        String mapName = "map_" + mapItem.func_77952_i();
        MapData data = new MapData(mapName);
        worldObj.func_72823_a(mapName, (WorldSavedData)data);
        data.field_76201_a = pos.func_177958_n();
        data.field_76199_b = pos.func_177952_p();
        data.field_76197_d = (byte)3;
        data.field_76200_c = (byte)worldObj.field_73011_w.getDimension();
        data.func_76185_a();
    }
}

