/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tropicraft.core.common.block.BlockTropicraftLeaves;
import net.tropicraft.core.common.block.BlockTropicraftLog;
import net.tropicraft.core.common.enums.TropicraftLeaves;
import net.tropicraft.core.common.enums.TropicraftLogs;
import net.tropicraft.core.common.worldgen.TCGenBase;
import net.tropicraft.core.common.worldgen.TCGenUtils;
import net.tropicraft.core.registry.BlockRegistry;

public class WorldGenTualang
extends TCGenBase {
    private static final IBlockState WOOD_BLOCK = BlockRegistry.logs.func_176223_P().func_177226_a(BlockTropicraftLog.VARIANT, (Comparable)((Object)TropicraftLogs.MAHOGANY));
    private static final IBlockState LEAF_BLOCK = BlockRegistry.leaves.func_176223_P().func_177226_a(BlockTropicraftLeaves.VARIANT, (Comparable)((Object)TropicraftLeaves.MAHOGANY));
    private int baseHeight;
    private int maxHeight;

    public WorldGenTualang(World world, Random random, int maxHeight, int baseHeight) {
        super(world, random);
        this.baseHeight = baseHeight;
        this.maxHeight = maxHeight;
    }

    @Override
    public boolean generate(BlockPos pos) {
        Block block;
        int y;
        int z;
        int x;
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        int height = this.rand.nextInt(this.maxHeight - this.baseHeight) + this.baseHeight + j;
        int branches = this.rand.nextInt(3) + 3;
        if (height + 6 > 256) {
            return false;
        }
        Block blockUnder = TCGenUtils.getBlock((IBlockAccess)this.worldObj, i, j - 1, k);
        if (blockUnder != Blocks.field_150346_d && blockUnder != Blocks.field_150349_c) {
            return false;
        }
        for (x = i - 1; x <= i + 1; ++x) {
            for (z = k - 1; z <= k + 1; ++z) {
                for (y = j; y < j + height; ++y) {
                    block = TCGenUtils.getBlock((IBlockAccess)this.worldObj, x, y, z);
                    if (!block.func_176223_P().func_185914_p()) continue;
                    return false;
                }
            }
        }
        for (x = i - 9; x >= i + 9; ++x) {
            for (z = k - 9; z >= k + 9; ++z) {
                for (y = height; y < height + 6; ++y) {
                    block = TCGenUtils.getBlock((IBlockAccess)this.worldObj, x, y, z);
                    if (!block.func_176223_P().func_185914_p()) continue;
                    return false;
                }
            }
        }
        TCGenUtils.setBlockState(this.worldObj, i, j, k, Blocks.field_150346_d.func_176223_P(), blockGenNotifyFlag);
        TCGenUtils.setBlockState(this.worldObj, i - 1, j, k, Blocks.field_150346_d.func_176223_P(), blockGenNotifyFlag);
        TCGenUtils.setBlockState(this.worldObj, i + 1, j, k, Blocks.field_150346_d.func_176223_P(), blockGenNotifyFlag);
        TCGenUtils.setBlockState(this.worldObj, i, j, k - 1, Blocks.field_150346_d.func_176223_P(), blockGenNotifyFlag);
        TCGenUtils.setBlockState(this.worldObj, i, j, k + 1, Blocks.field_150346_d.func_176223_P(), blockGenNotifyFlag);
        for (int y2 = j; y2 < height; ++y2) {
            TCGenUtils.setBlockState(this.worldObj, i, y2, k, WOOD_BLOCK, blockGenNotifyFlag);
            TCGenUtils.setBlockState(this.worldObj, i - 1, y2, k, WOOD_BLOCK, blockGenNotifyFlag);
            TCGenUtils.setBlockState(this.worldObj, i + 1, y2, k, WOOD_BLOCK, blockGenNotifyFlag);
            TCGenUtils.setBlockState(this.worldObj, i, y2, k - 1, WOOD_BLOCK, blockGenNotifyFlag);
            TCGenUtils.setBlockState(this.worldObj, i, y2, k + 1, WOOD_BLOCK, blockGenNotifyFlag);
        }
        for (x = 0; x < branches; ++x) {
            int branchHeight = this.rand.nextInt(4) + 2 + height;
            int bx = this.rand.nextInt(15) - 8 + i;
            int bz = this.rand.nextInt(15) - 8 + k;
            this.placeBlockLine(new int[]{i + this.sign((bx - i) / 2), height, k + this.sign((bz - k) / 2)}, new int[]{bx, branchHeight, bz}, WOOD_BLOCK);
            this.genCircle(bx, branchHeight, bz, 2.0, 1.0, LEAF_BLOCK, false);
            this.genCircle(bx, branchHeight + 1, bz, 3.0, 2.0, LEAF_BLOCK, false);
        }
        return true;
    }

    private int sign(int i) {
        return i == 0 ? 0 : (i <= 0 ? -1 : 1);
    }
}

