/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tropicraft.core.common.block.BlockTropicraftLeaves;
import net.tropicraft.core.common.block.BlockTropicraftLog;
import net.tropicraft.core.common.enums.TropicraftLeaves;
import net.tropicraft.core.common.enums.TropicraftLogs;
import net.tropicraft.core.common.worldgen.TCGenBase;
import net.tropicraft.core.common.worldgen.TCGenUtils;
import net.tropicraft.core.registry.BlockRegistry;

public class WorldGenUndergrowth
extends TCGenBase {
    private static final int LARGE_BUSH_CHANCE = 5;
    private static final IBlockState WOOD_BLOCK = BlockRegistry.logs.func_176223_P().func_177226_a(BlockTropicraftLog.VARIANT, (Comparable)((Object)TropicraftLogs.MAHOGANY));
    private static final IBlockState LEAF_BLOCK = BlockRegistry.leaves.func_176223_P().func_177226_a(BlockTropicraftLeaves.VARIANT, (Comparable)((Object)TropicraftLeaves.MAHOGANY));

    public WorldGenUndergrowth(World world, Random rand) {
        super(world, rand);
    }

    @Override
    public boolean generate(BlockPos pos) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        Block blockUnder = this.worldObj.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (blockUnder != Blocks.field_150346_d && blockUnder != Blocks.field_150349_c) {
            return false;
        }
        TCGenUtils.setBlockState(this.worldObj, pos, WOOD_BLOCK, blockGenNotifyFlag);
        int size = 2;
        if (this.rand.nextInt(5) == 0) {
            size = 3;
        }
        for (int y = j; y < j + size; ++y) {
            int bushWidth = size - (y - j);
            for (int x = i - bushWidth; x < i + bushWidth; ++x) {
                int xVariance = x - i;
                for (int z = k - bushWidth; z < k + bushWidth; ++z) {
                    int zVariance = z - k;
                    if (Math.abs(xVariance) == bushWidth && Math.abs(zVariance) == bushWidth && this.rand.nextInt(2) == 0 || TCGenUtils.getBlockState((IBlockAccess)this.worldObj, x, y, z).func_185914_p()) continue;
                    TCGenUtils.setBlockState(this.worldObj, x, y, z, LEAF_BLOCK, blockGenNotifyFlag);
                }
            }
        }
        return true;
    }
}

