/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen.mapgen;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.tropicraft.core.common.biome.BiomeTropicraft;
import net.tropicraft.core.common.block.BlockTropicraftSands;
import net.tropicraft.core.common.enums.TropicraftSands;
import net.tropicraft.core.common.worldgen.perlin.NoiseModule;
import net.tropicraft.core.common.worldgen.perlin.generator.Billowed;
import net.tropicraft.core.registry.BlockRegistry;

public class MapGenVolcano {
    protected HashMap coordMap = new HashMap();
    public static List<Biome> volcanoSpawnBiomesLand = Arrays.asList(BiomeTropicraft.tropics, BiomeTropicraft.rainforestPlains);
    public static List<Biome> volcanoSpawnBiomesOcean = Arrays.asList(new Biome[]{BiomeTropicraft.tropicsOcean});
    private World worldObj;
    private boolean useArrays;
    private static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Z = 16;
    private static final int CHUNK_SIZE_Y = 256;
    private static final int MAX_RADIUS = 65;
    private static final int MIN_RADIUS = 45;
    private static final int LAND_STEEPNESS_MOD = 2;
    private static final int OCEAN_STEEPNESS_MOD = 8;
    private static final int CALDERA_CUTOFF = 124;
    public static final int VOLCANO_TOP = 117;
    public static final int VOLCANO_CRUST = 114;
    public static final int LAVA_LEVEL = 79;
    private static final int CRUST_HOLE_CHANCE = 15;
    private static final IBlockState VOLCANO_BLOCK = BlockRegistry.chunk.func_176223_P();
    private static final IBlockState LAVA_BLOCK = Blocks.field_150353_l.func_176223_P();
    private static final IBlockState SAND_BLOCK = BlockRegistry.sands.func_176223_P().func_177226_a(BlockTropicraftSands.VARIANT, (Comparable)((Object)TropicraftSands.VOLCANIC));

    public MapGenVolcano(World worldObj, boolean useArrays) {
        this.worldObj = worldObj;
        this.useArrays = useArrays;
    }

    public ChunkPrimer generate(int i, int k, ChunkPrimer primer) {
        BlockPos volcanoCoords = this.getVolcanoNear(this.worldObj, i, k);
        if (volcanoCoords == null) {
            return primer;
        }
        int[] heightmap = new int[256];
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 127; ++y) {
                    Block blockID = primer.func_177856_a(x, y, z).func_177230_c();
                    if (blockID == Blocks.field_150350_a || blockID == BlockRegistry.tropicsWater) {
                        heightmap[x * 16 + z] = y;
                        continue block1;
                    }
                    if (y <= 75) continue;
                    heightmap[x * 16 + z] = y;
                    continue block1;
                }
            }
        }
        i *= 16;
        k *= 16;
        int volcCenterX = volcanoCoords.func_177958_n();
        int volcCenterZ = volcanoCoords.func_177952_p();
        int steepnessMod = volcanoCoords.func_177956_o() == 1 ? 2 : 8;
        long seed = (long)volcCenterX * 341873128712L + (long)volcCenterZ * 132897987541L + this.worldObj.func_72912_H().func_76063_b() + 4291726L;
        Random rand = new Random(seed);
        int radiusX = rand.nextInt(20) + 45;
        int radiusZ = rand.nextInt(20) + 45;
        Billowed volcNoise = new Billowed(seed, 1, 1.0);
        volcNoise.amplitude = 0.45;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                float relativeX = x + i - volcCenterX;
                float relativeZ = z + k - volcCenterZ;
                float distanceSquared = relativeX / (float)radiusX * (relativeX / (float)radiusX) + relativeZ / (float)radiusZ * (relativeZ / (float)radiusZ);
                float perlin = (float)((NoiseModule)volcNoise).getNoise((double)relativeX * 0.21 + 0.01, (double)relativeZ * 0.21 + 0.01) + 1.0f;
                double steepness = 10.2;
                double volcanoHeight = steepness / (double)distanceSquared * (double)perlin - steepness - 2.0;
                int groundHeight = heightmap[x * 16 + z];
                if (!(distanceSquared < 1.0f)) continue;
                for (int y = 256; y > 0; --y) {
                    if (volcanoHeight + (double)groundHeight < 124.0) {
                        if (volcanoHeight + (double)groundHeight <= 117.0) {
                            if (!((double)y <= volcanoHeight + (double)groundHeight)) continue;
                            if (y >= groundHeight) {
                                this.placeBlock(x, y, z, VOLCANO_BLOCK, primer);
                                continue;
                            }
                            if (primer.func_177856_a(x, y, z).func_177230_c() != BlockRegistry.sands) continue;
                            this.placeBlock(x, y, z, SAND_BLOCK, primer);
                            if (primer.func_177856_a(x, y + 1, z).func_177230_c() != BlockRegistry.sands) continue;
                            this.placeBlock(x, y + 1, z, SAND_BLOCK, primer);
                            continue;
                        }
                        if (y == 113) {
                            if (this.worldObj.field_73012_v.nextInt(3) == 0) continue;
                            this.placeBlock(x, y, z, VOLCANO_BLOCK, primer);
                            continue;
                        }
                        if (y > 117) continue;
                        this.placeBlock(x, y, z, VOLCANO_BLOCK, primer);
                        continue;
                    }
                    if (y == 114 && rand.nextInt(15) != 0) {
                        this.placeBlock(x, y, z, VOLCANO_BLOCK, primer);
                    }
                    if (y > 79) continue;
                    this.placeBlock(x, y, z, LAVA_BLOCK, primer);
                }
            }
        }
        return primer;
    }

    public void placeBlock(int x, int y, int z, IBlockState blockState, ChunkPrimer primer) {
        primer.func_177855_a(x, y, z, blockState);
    }

    public IBlockState getBlockState(int x, int y, int z, ChunkPrimer primer) {
        return primer.func_177856_a(x, y, z);
    }

    protected int canGenVolcanoAtCoords(World worldObj, int i, int j) {
        int numChunks = 64;
        int offsetChunks = 16;
        int oldi = i;
        int oldj = j;
        if (i < 0) {
            i -= numChunks - 1;
        }
        if (j < 0) {
            j -= numChunks - 1;
        }
        int randX = i / numChunks;
        int randZ = j / numChunks;
        long seed = (long)randX * 341873128712L + (long)randZ * 132897987541L + worldObj.func_72912_H().func_76063_b() + 4291726L;
        Random rand = new Random(seed);
        randX *= numChunks;
        randZ *= numChunks;
        if (oldi == (randX += rand.nextInt(numChunks - offsetChunks)) && oldj == (randZ += rand.nextInt(numChunks - offsetChunks))) {
            if (worldObj.func_72959_q().func_76940_a(oldi * 16 + 8, oldj * 16 + 8, 0, volcanoSpawnBiomesLand)) {
                return 1;
            }
            if (worldObj.func_72959_q().func_76940_a(oldi * 16 + 8, oldj * 16 + 8, 0, volcanoSpawnBiomesOcean)) {
                return 2;
            }
        }
        return 0;
    }

    public BlockPos getVolcanoNear(World worldObj, int i, int j) {
        int range = 4;
        for (int x = i - range; x <= i + range; ++x) {
            for (int z = j - range; z <= j + range; ++z) {
                int biome = this.canGenVolcanoAtCoords(worldObj, x, z);
                if (biome == 0) continue;
                return new BlockPos(x * 16 + 8, biome, z * 16 + 8);
            }
        }
        return null;
    }
}

