/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen.overworld;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.config.TropicsConfigs;
import net.tropicraft.core.common.enums.TropicraftFlowers;
import net.tropicraft.core.common.worldgen.WorldGenBamboo;
import net.tropicraft.core.common.worldgen.WorldGenCurvedPalms;
import net.tropicraft.core.common.worldgen.WorldGenEIH;
import net.tropicraft.core.common.worldgen.WorldGenLargePalmTrees;
import net.tropicraft.core.common.worldgen.WorldGenNormalPalms;
import net.tropicraft.core.common.worldgen.WorldGenTallFlower;
import net.tropicraft.core.common.worldgen.WorldGenTropicalFlowers;
import net.tropicraft.core.registry.BlockRegistry;

public class TCWorldGenerator
implements IWorldGenerator {
    public void generateSurface(World world, Random random, int chunkX, int chunkZ) {
        Biome biome = world.func_180494_b(new BlockPos(chunkX, 0, chunkZ));
        if (TropicsConfigs.genOverworld) {
            chunkX *= 16;
            chunkZ *= 16;
            if (world.field_73011_w.getDimension() == 0 && world.func_175624_G() != WorldType.field_77138_c) {
                int j3;
                int k = chunkX + random.nextInt(16) + 8;
                int l = random.nextInt(62) + 64;
                int i1 = chunkZ + random.nextInt(16) + 8;
                Biome biomeFlowers = world.func_180494_b(new BlockPos(k, l, i1));
                if (TropicsConfigs.genOverworldFlowers && Util.isBiomeTropical(biomeFlowers)) {
                    for (j3 = 0; j3 < 10; ++j3) {
                        l = random.nextInt(62) + 64;
                        BlockPos flowerPos = new BlockPos(k, l, i1);
                        new WorldGenTropicalFlowers(world, random, (Block)BlockRegistry.flowers, TropicraftFlowers.OVERWORLD_FLOWERS).func_180709_b(world, random, flowerPos);
                    }
                }
                if (TropicsConfigs.genOverworldEIH && random.nextInt(300) == 0) {
                    l = random.nextInt(62) + 64;
                    BlockPos eihPos = new BlockPos(k, l, i1);
                    new WorldGenEIH(world, random).func_180709_b(world, random, eihPos);
                }
                if (biome.func_185353_n() > 0.5f && !biome.func_76746_c() && TropicsConfigs.genOverworldPalms && random.nextInt(10) == 0 && (TropicsConfigs.genOverworldPalmsBeachOnly && biome == Biomes.field_76787_r || !TropicsConfigs.genOverworldPalmsBeachOnly) && (TropicsConfigs.chancePalmOverworld < 0 || random.nextFloat() < (float)TropicsConfigs.chancePalmOverworld / 100.0f)) {
                    for (j3 = 0; j3 < TropicsConfigs.factorPalmOverworld; ++j3) {
                        int z;
                        int x;
                        BlockPos pos;
                        l = random.nextInt(62) + 64;
                        if (random.nextInt(5) == 0) {
                            pos = new BlockPos(chunkX + 16, l, chunkZ + 16);
                            new WorldGenLargePalmTrees(world, random).func_180709_b(world, random, pos);
                            continue;
                        }
                        if (random.nextInt(5) < 3) {
                            x = chunkX + 13 + random.nextInt(5);
                            z = chunkZ + 13 + random.nextInt(5);
                            pos = new BlockPos(x, l, z);
                            new WorldGenCurvedPalms(world, random).func_180709_b(world, random, pos);
                            continue;
                        }
                        x = chunkX + 13 + random.nextInt(5);
                        z = chunkZ + 13 + random.nextInt(5);
                        pos = new BlockPos(x, l, z);
                        new WorldGenNormalPalms(world, random).func_180709_b(world, random, pos);
                    }
                }
                if (biome.func_76727_i() > 0.3f && biome.func_185353_n() > 0.0f && TropicsConfigs.genOverworldPineapples && random.nextInt(TropicsConfigs.tallFlowerGenChanceOverworld) == 0) {
                    l = world.func_189649_b(chunkX, chunkZ);
                    BlockPos pineapplePos = new BlockPos(chunkX, l, chunkZ);
                    for (int t = 0; t < 3; ++t) {
                        new WorldGenTallFlower(world, random, BlockRegistry.pineapple.func_176223_P()).generate(pineapplePos);
                    }
                }
                if (biome.func_185353_n() > 0.2f && TropicsConfigs.genOverworldBamboo && random.nextInt(TropicsConfigs.bambooGenChanceOverworld) == 0) {
                    l = random.nextInt(62) + 64;
                    BlockPos bambooPos = new BlockPos(chunkX, l, chunkZ);
                    new WorldGenBamboo(world, random).func_180709_b(world, random, bambooPos);
                }
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateSurface(world, random, chunkX, chunkZ);
    }
}

