/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen.village;

import java.util.Map;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.tropicraft.core.common.build.BuildServerTicks;
import net.tropicraft.core.common.build.ICustomGen;
import net.tropicraft.core.common.build.UtilBuild;
import net.tropicraft.core.common.build.world.Build;
import net.tropicraft.core.common.build.world.BuildJob;
import net.tropicraft.core.common.build.world.BuildManager;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.common.entity.passive.EntityKoaHunter;
import net.tropicraft.core.common.town.SpawnLocationData;
import net.tropicraft.core.common.town.TownObject;
import net.tropicraft.core.common.worldgen.village.TownKoaVillageGenHelper;
import net.tropicraft.core.registry.BlockRegistry;

public class TownKoaVillage
extends TownObject
implements ICustomGen {
    public int areaLength = TownKoaVillageGenHelper.areaLength;
    public int areaWidth = TownKoaVillageGenHelper.areaWidth;
    public int areaHeight = TownKoaVillageGenHelper.areaHeight;
    public int direction = 1;
    public boolean isCustomVillage = false;
    private int maxPopulationSize = 20;

    public TownKoaVillage() {
        this.generateSpawnCoords();
    }

    @Override
    public void tickUpdate() {
        super.tickUpdate();
        if (this.getWorld().func_82737_E() % 20L == 0L) {
            // empty if block
        }
    }

    @Override
    public void initFirstTime() {
        super.initFirstTime();
    }

    public void genStructure() {
        this.genSchematic();
    }

    public void genSchematic() {
        int yOffset = 0;
        Build mainStructureData = new Build(this.spawn.func_177958_n(), this.spawn.func_177956_o() + yOffset, this.spawn.func_177952_p(), "koavillage", new ResourceLocation("tropicraft", "schematics/koavillage.schematic"));
        BuildJob bj = new BuildJob(-99, this.spawn.func_177958_n(), this.spawn.func_177956_o() + yOffset, this.spawn.func_177952_p(), mainStructureData);
        bj.build.dim = this.getWorld().field_73011_w.getDimension();
        bj.useFirstPass = false;
        bj.useRotationBuild = true;
        bj.build_rate = 10000;
        bj.notifyFlag = 0;
        bj.neverPlaceAir = true;
        bj.setDirection(this.direction);
        bj.customGenCallback = this;
        this.areaHeight = mainStructureData.map_sizeY;
        BuildServerTicks.buildMan.addBuild(bj);
    }

    public void spawnEntitiesForce() {
        this.tickMonitorPersistantMembers(true);
    }

    public void generateSpawnCoords() {
        int y = 2;
        boolean oldSpawns = false;
        if (oldSpawns) {
            this.registerSpawnLocation(new SpawnLocationData(this.getRotatedCoordsWithRelFromCorner(77, 2 + y, 37), "shaman"));
            this.registerSpawnLocation(new SpawnLocationData(this.getRotatedCoordsWithRelFromCorner(25, y, 37), "trader"));
            this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(23, 1 + y, 20), "fisher", "hunter");
            this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(38, 1 + y, 14), "fisher", "hunter");
            this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(57, 1 + y, 3), "fisher", "hunter");
            this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(63, 1 + y, 17), "fisher", "hunter");
            this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(69, 1 + y, 3), "fisher", "hunter");
            this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(23, 1 + y, 54), "fisher", "hunter");
            this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(38, 1 + y, 60), "fisher", "hunter");
            this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(57, 1 + y, 71), "fisher", "hunter");
            this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(63, 1 + y, 57), "fisher", "hunter");
            this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(69, 1 + y, 71), "fisher", "hunter");
        } else if (this.isCustomVillage) {
            this.listSpawnLocations.clear();
            for (int i = 0; i < this.minEntitiesToKeepAlive; ++i) {
                this.registerSpawnLocation(new BlockPos(0, 0, 0), "fisher");
            }
        } else {
            for (int i = 0; i < this.minEntitiesToKeepAlive; ++i) {
                this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(42, 0 + y, 42), "fisher");
            }
        }
    }

    public BlockPos getRotatedCoordsWithRelFromCorner(int x, int y, int z) {
        BlockPos coords = new BlockPos(x, y, z);
        return BuildManager.rotateNew(coords, this.direction, new Vec3d(0.0, 0.0, 0.0), new Vec3d((double)this.areaWidth, (double)this.areaHeight, (double)this.areaLength));
    }

    @Override
    public EntityLivingBase spawnMemberAtSpawnLocation(SpawnLocationData parData) {
        super.spawnMemberAtSpawnLocation(parData);
        EntityKoaHunter ent = null;
        ent = new EntityKoaHunter(this.getWorld());
        if (ent != null) {
            ent.setVillageAndDimID(this.locationID, this.dimID);
            ent.func_70107_b((float)(this.spawn.func_177958_n() + parData.coords.func_177958_n()) + 0.5f, this.spawn.func_177956_o() + parData.coords.func_177956_o(), (float)(this.spawn.func_177952_p() + parData.coords.func_177952_p()) + 0.5f);
            this.getWorld().func_72838_d((Entity)ent);
            parData.entityUUID = ent.getPersistentID();
            ent.func_180482_a(this.getWorld().func_175649_E(ent.func_180425_c()), null);
            ent.postSpawnGenderFix();
            this.addEntity((EntityLivingBase)ent);
        }
        return ent;
    }

    @Override
    public void genPassPre(World world, BuildJob parBuildJob, int parPass) {
        if (parPass == -1) {
            this.spawnEntitiesForce();
            IBlockState id = BlockRegistry.bambooFence.func_176223_P();
            int offsetFix = 0;
            if (parBuildJob.direction == 1 || parBuildJob.direction == 2) {
                offsetFix = -1;
            }
            this.placeDownTilGround(world, parBuildJob, 29, -1, 1 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 45, -1, 1 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 45, -1, 11 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 29, -1, 11 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 1, 0, 10 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 1, 0, 18 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 1, 0, 22 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 1, 0, 30 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 12, 0, 41 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 12, 0, 49 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 18, 0, 56 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 18, 0, 64 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 19, 0, 16 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 19, 0, 24 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 21, 0, 37 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 29, 0, 32 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 21, 0, 49 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 27, 0, 64 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 10, 0, 20 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 73, 0, 10 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 73, 0, 18 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 73, 0, 22 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 73, 0, 30 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 62, 0, 41 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 62, 0, 49 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 56, 0, 56 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 56, 0, 64 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 55, 0, 16 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 55, 0, 24 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 53, 0, 37 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 53, 0, 49 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 47, 0, 64 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 64, 0, 14 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 45, 0, 32 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 35, -1, 43 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 39, -1, 43 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 41, -1, 54 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 33, -1, 54 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 33, -1, 62 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 41, -1, 62 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 39, -1, 66 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 35, -1, 66 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 36, 0, 80 + offsetFix, id);
            this.placeDownTilGround(world, parBuildJob, 38, 0, 80 + offsetFix, id);
        }
    }

    protected void placeDownTilGround(World world, BuildJob bj, int x, int y, int z, IBlockState blockState) {
        if (world == null) {
            return;
        }
        int absY = bj.build_startY + y;
        BlockPos pos = this.getRel(bj, x, y, z);
        IBlockState stateCheck = world.func_180495_p(pos);
        while (absY > 0 && (world.func_175623_d(pos) || stateCheck.func_185904_a() == Material.field_151586_h)) {
            this.setRel(bj, x, y, z, blockState);
            absY = bj.build_startY + --y;
            pos = this.getRel(bj, x, y, z);
            stateCheck = world.func_180495_p(pos);
        }
    }

    public BlockPos getRel(BuildJob bj, int width, int height, int depth) {
        return BuildManager.rotatePos(bj, new BlockPos(bj.build_startX + depth, bj.build_startY + height, bj.build_startZ + width));
    }

    public void setRel(BuildJob bj, int width, int height, int depth, IBlockState blockState) {
        BuildManager.rotateSet(bj, new BlockPos(bj.build_startX + depth, bj.build_startY + height, bj.build_startZ + width), blockState);
    }

    @Override
    public NBTTagCompound getInitNBTTileEntity() {
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound var1) {
        super.readFromNBT(var1);
        this.direction = var1.func_74762_e("direction");
        NBTTagCompound nbtPersistantEntities = var1.func_74775_l("lookupGenders");
        for (String entryName : nbtPersistantEntities.func_150296_c()) {
            NBTTagCompound entry = nbtPersistantEntities.func_74775_l(entryName);
            UUID uuid = UUID.fromString(entry.func_74779_i("UUID"));
            int gender = entry.func_74762_e("gender");
            this.lookupEntityToGender.put(uuid, gender);
        }
        this.isCustomVillage = var1.func_74767_n("isCustomVillage");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound var1) {
        super.writeToNBT(var1);
        var1.func_74768_a("direction", this.direction);
        NBTTagCompound nbtListPersistantEntities = new NBTTagCompound();
        int count = 0;
        for (Map.Entry entry : this.lookupEntityToGender.entrySet()) {
            NBTTagCompound nbtEntry = new NBTTagCompound();
            nbtEntry.func_74778_a("UUID", ((UUID)entry.getKey()).toString());
            nbtEntry.func_74768_a("gender", ((Integer)entry.getValue()).intValue());
            nbtListPersistantEntities.func_74782_a("entry_" + count++, (NBTBase)nbtEntry);
        }
        var1.func_74782_a("lookupGenders", (NBTBase)nbtListPersistantEntities);
        var1.func_74757_a("isCustomVillage", this.isCustomVillage);
        return var1;
    }

    @Override
    public void addEntity(EntityLivingBase ent) {
        super.addEntity(ent);
        if (ent instanceof EntityKoaBase) {
            EntityKoaBase koa = (EntityKoaBase)ent;
            if (this.lookupEntityToGender.containsKey(ent.getPersistentID())) {
                UtilBuild.dbg("WARNING: adding already existing entitys _persistant ID_ to lookupEntityToGender");
            } else {
                this.lookupEntityToGender.put(ent.getPersistentID(), koa.getGender().ordinal());
            }
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.lookupEntityToGender.clear();
    }

    @Override
    public void hookEntityDied(EntityLivingBase ent) {
        super.hookEntityDied(ent);
        this.lookupEntityToGender.remove(ent.getPersistentID());
    }

    public int getMaxPopulationSize() {
        return this.maxPopulationSize;
    }

    public void setMaxPopulationSize(int maxPopulationSize) {
        this.maxPopulationSize = maxPopulationSize;
    }
}

