/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.encyclopedia;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.tropicraft.core.encyclopedia.ItemPage;

@ParametersAreNonnullByDefault
public class EntityPage
extends ItemPage {
    private static final ResourceLocation PANEL_BG = new ResourceLocation("tropicraft", "textures/blocks/thatch_side.png");
    private final ResourceLocation entityId;
    @Nullable
    private EntityLivingBase entity;

    public EntityPage(String id, ItemStack icon) {
        this(id, new ResourceLocation("tropicraft", id), icon);
    }

    public EntityPage(String id, ResourceLocation entityId, ItemStack icon) {
        super(id, icon);
        this.entityId = entityId;
    }

    @Override
    public String getLocalizedTitle() {
        if (this.entity == null) {
            this.entity = this.makeEntity();
        }
        if (I18n.func_188566_a((String)this.getTitle())) {
            return super.getLocalizedTitle();
        }
        return this.entity.func_145748_c_().func_150254_d();
    }

    protected ResourceLocation getEntityId() {
        return this.entityId;
    }

    protected EntityLivingBase makeEntity() {
        EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(this.entityId);
        EntityLivingBase ret = (EntityLivingBase)entry.newInstance((World)Minecraft.func_71410_x().field_71441_e);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        if (rendermanager.func_78713_a((Entity)ret) instanceof RenderBiped) {
            ret.field_70130_N = (float)((double)ret.field_70130_N + 0.35);
        }
        return ret;
    }

    @Nullable
    protected EntityLivingBase getEntity() {
        return this.entity;
    }

    protected void drawEntity(int x, int y, float mouseX, float mouseY) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GuiInventory.func_147046_a((int)(x += 67), (int)((y -= 2) + this.getHeaderHeight()), (int)30, (float)((float)x - mouseX), (float)((float)y - mouseY + 10.0f), (EntityLivingBase)this.getEntity());
    }

    @Override
    public void drawHeader(int x, int y, float mouseX, float mouseY, float cycle) {
        super.drawHeader(x, y, mouseX, mouseY, cycle);
        if (this.entity == null) {
            this.entity = this.makeEntity();
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PANEL_BG);
        int bgX = x + 14;
        int bgY = y;
        int bgWidth = 106;
        int bgHeight = this.getHeaderHeight() + 10;
        Gui.func_152125_a((int)bgX, (int)bgY, (float)0.0f, (float)0.0f, (int)bgWidth, (int)bgHeight, (int)bgWidth, (int)bgHeight, (float)16.0f, (float)16.0f);
        Gui.func_73734_a((int)bgX, (int)bgY, (int)(bgX + bgWidth), (int)(bgY + bgHeight), (int)0x55444444);
        this.drawEntity(x, y, mouseX, mouseY);
    }

    @Override
    public int getHeaderHeight() {
        return (int)(this.entity == null ? 0.0f : this.entity.field_70131_O * 33.0f) + 12;
    }
}

