/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.encyclopedia;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.encyclopedia.RecipeEntry;
import net.tropicraft.core.encyclopedia.SimplePage;

@ParametersAreNonnullByDefault
public class ItemPage
extends SimplePage {
    private final ItemStack stack;

    public ItemPage(String id, ItemStack stack) {
        super(id);
        this.stack = stack;
    }

    protected ItemStack getStack() {
        return this.stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawIcon(int x, int y, float cycle) {
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179091_B();
        RenderHelper.func_74520_c();
        Minecraft.func_71410_x().func_175599_af().func_175042_a(this.getStack(), x, y);
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
    }

    @Override
    public List<RecipeEntry> getRelevantRecipes() {
        ArrayList<RecipeEntry> recipeList = new ArrayList<RecipeEntry>();
        for (IRecipe recipe : ForgeRegistries.RECIPES.getValues()) {
            if (!recipe.func_77571_b().func_77969_a(this.getStack())) continue;
            recipeList.add(this.getFormattedRecipe(recipe));
        }
        return recipeList;
    }

    @Nullable
    protected RecipeEntry getFormattedRecipe(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            ShapedRecipes shaped = (ShapedRecipes)recipe;
            int width = shaped.field_77576_b;
            int height = shaped.field_77577_c;
            NonNullList items = shaped.field_77574_d;
            ItemStack output = recipe.func_77571_b();
            return new RecipeEntry(width, height, (NonNullList<Ingredient>)items, output);
        }
        if (recipe instanceof ShapelessRecipes) {
            return new RecipeEntry(3, 3, (NonNullList<Ingredient>)recipe.func_192400_c(), recipe.func_77571_b());
        }
        return null;
    }

    @Override
    public boolean discover(World world, EntityPlayer player) {
        for (ItemStack is : player.field_71071_by.field_70462_a) {
            ItemStack stack;
            if (is.func_190926_b() || !ItemStack.func_179545_c((ItemStack)is, (ItemStack)(stack = this.getStack())) || stack.func_77942_o() && !ItemStack.func_77970_a((ItemStack)is, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }
}

