/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.encyclopedia;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.tropicraft.core.encyclopedia.EntityPage;
import net.tropicraft.core.encyclopedia.MultiItemPage;

@ParametersAreNonnullByDefault
public abstract class MultiEntityPage
extends EntityPage {
    private final MultiItemPage delegate;
    @Nullable
    private EntityLivingBase[] variants;
    private int currentIndex;

    public MultiEntityPage(String id, ItemStack ... icons) {
        super(id, icons[0]);
        this.delegate = new MultiItemPage(id, icons);
    }

    public MultiEntityPage(String id, ResourceLocation entityId, ItemStack ... icons) {
        super(id, entityId, icons[0]);
        this.delegate = new MultiItemPage(id, icons);
    }

    protected abstract EntityLivingBase[] makeVariants();

    @Override
    public void drawIcon(int x, int y, float cycle) {
        this.delegate.drawIcon(x, y, cycle);
    }

    @Override
    @Nullable
    protected EntityLivingBase getEntity() {
        return this.variants[this.currentIndex];
    }

    @Override
    protected void drawEntity(int x, int y, float mouseX, float mouseY) {
        if (this.variants == null) {
            this.variants = this.makeVariants();
        }
        float mid = (float)(this.variants.length - 1) / 2.0f;
        for (int i = 0; i < this.variants.length; ++i) {
            this.currentIndex = i;
            super.drawEntity((int)((float)x + ((float)i - mid) * this.variants[i].field_70130_N * 40.0f), y, mouseX, mouseY);
        }
    }
}

