/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.encyclopedia;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.encyclopedia.ItemPage;
import net.tropicraft.core.encyclopedia.RecipeEntry;

@ParametersAreNonnullByDefault
public class MultiItemPage
extends ItemPage {
    private final ItemStack[] stacks;
    private int tick;

    public MultiItemPage(String id, ItemStack ... stacks) {
        super(id, stacks[0]);
        this.stacks = stacks;
    }

    @Override
    protected ItemStack getStack() {
        return this.stacks[this.tick % this.stacks.length];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawIcon(int x, int y, float cycle) {
        this.tick = MathHelper.func_76128_c((double)((double)cycle * 0.05));
        super.drawIcon(x, y, cycle);
    }

    @Override
    public List<RecipeEntry> getRelevantRecipes() {
        ArrayList<RecipeEntry> recipeList = new ArrayList<RecipeEntry>();
        for (IRecipe recipe : ForgeRegistries.RECIPES.getValues()) {
            for (ItemStack stack : this.stacks) {
                if (!recipe.func_77571_b().func_77969_a(stack)) continue;
                recipeList.add(this.getFormattedRecipe(recipe));
            }
        }
        return recipeList;
    }

    @Override
    public boolean discover(World world, EntityPlayer player) {
        for (ItemStack is : player.field_71071_by.field_70462_a) {
            if (is.func_190926_b()) continue;
            for (ItemStack stack : this.stacks) {
                if (!ItemStack.func_179545_c((ItemStack)is, (ItemStack)stack) || stack.func_77942_o() && !ItemStack.func_77970_a((ItemStack)is, (ItemStack)stack)) continue;
                return true;
            }
        }
        return false;
    }
}

