/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.encyclopedia;

import com.google.common.collect.HashMultimap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.tropicraft.core.encyclopedia.Page;
import org.apache.logging.log4j.LogManager;

public class TropicalBook {
    private LinkedHashMap<String, Page> pages = new LinkedHashMap();
    private List<String> pageIds = new ArrayList<String>();
    private Page currentBookmark;
    private Map<Page, Page> pageToBookmark = new IdentityHashMap<Page, Page>();
    private HashMap<String, ReadState> visibilities = new HashMap();
    private final String fileName;
    public String outsideTexture;
    public String insideTexture;

    public TropicalBook(String savedDataFile, String outsideTex, String insideTex) {
        this.fileName = savedDataFile;
        this.outsideTexture = outsideTex;
        this.insideTexture = insideTex;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void addPage(Page page) {
        if (!this.pages.containsKey(page.getId())) {
            this.pages.put(page.getId(), page);
            this.pageIds.add(page.getId());
            if (page.isBookmark()) {
                this.currentBookmark = page;
            } else if (this.currentBookmark != null) {
                this.pageToBookmark.put(page, this.currentBookmark);
            }
        } else {
            throw new IllegalArgumentException("Duplicate page: " + page.getId());
        }
    }

    protected File getSaveFile() {
        File root = DimensionManager.getCurrentSaveRootDirectory();
        if (root == null) {
            ServerData server = Minecraft.func_71410_x().func_147104_D();
            if (server == null) {
                throw new IllegalStateException("Cannot load encyclopedia outside of a game!");
            }
            return Paths.get("encyclopedia-servers", server.field_78847_a, this.fileName).toFile();
        }
        return new File(root, this.fileName);
    }

    @SubscribeEvent
    public void loadData(WorldEvent.Load event) {
        block16: {
            if (event.getWorld().field_73011_w.getDimension() != 0) {
                return;
            }
            try {
                File dataFile = this.getSaveFile();
                this.visibilities.clear();
                if (!dataFile.canRead()) break block16;
                try (FileInputStream dataInput = new FileInputStream(dataFile);){
                    NBTTagCompound data = CompressedStreamTools.func_74796_a((InputStream)dataInput);
                    for (String tagName : data.func_150296_c()) {
                        ReadState s = ReadState.values()[data.func_74771_c(tagName) % ReadState.values().length];
                        this.visibilities.put(tagName, s);
                    }
                }
            }
            catch (IOException ex) {
                LogManager.getLogger().error("Error reading encyclopedia data.", (Throwable)ex);
            }
        }
    }

    @SubscribeEvent
    public void saveData(WorldEvent.Save event) {
        if (event.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        this.saveData();
    }

    @SubscribeEvent
    public void saveData(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        this.saveData();
    }

    private void saveData() {
        block15: {
            try {
                File dataFile = this.getSaveFile();
                dataFile.getParentFile().mkdirs();
                dataFile.createNewFile();
                if (!dataFile.canWrite()) break block15;
                try (FileOutputStream dataOutput = new FileOutputStream(dataFile);){
                    NBTTagCompound data = new NBTTagCompound();
                    for (String s : this.visibilities.keySet()) {
                        data.func_74774_a(s, (byte)this.visibilities.get(s).ordinal());
                    }
                    CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)dataOutput);
                }
            }
            catch (IOException ex) {
                LogManager.getLogger().error("Error writing encyclopedia data.", (Throwable)ex);
            }
        }
    }

    public boolean hasRecipeList() {
        return false;
    }

    public boolean isPageVisible(String entry) {
        return this.visibilities.containsKey(entry) && this.visibilities.get(entry) != ReadState.HIDDEN;
    }

    public boolean isPageVisible(int i) {
        return this.isPageVisible(this.getPageName(i));
    }

    public boolean hasPageBeenRead(String entry) {
        return this.visibilities.containsKey(entry) && this.visibilities.get(entry) == ReadState.READ;
    }

    public boolean hasPageBeenRead(int i) {
        return this.hasPageBeenRead(this.getPageName(i));
    }

    public void markPageAsNewlyVisible(String entry) {
        Page page = this.getPage(entry);
        this.visibilities.put(entry, page == null || !page.isBookmark() ? ReadState.VISIBLE : ReadState.READ);
        this.saveData();
    }

    public void markPageAsNewlyVisible(int i) {
        this.markPageAsNewlyVisible(this.getPageName(i));
    }

    public void markPageAsRead(String entry) {
        this.visibilities.put(entry, ReadState.READ);
        this.saveData();
    }

    public void markPageAsRead(int i) {
        this.markPageAsRead(this.getPageName(i));
    }

    public void hidePage(int i) {
        this.hidePage(this.getPageName(i));
    }

    public void hidePage(String entry) {
        this.visibilities.remove(entry);
        this.saveData();
    }

    public boolean pageExists(String name) {
        return this.pages.containsKey(name);
    }

    protected String getPageName(int i) {
        if (i >= 0 && i < this.pageIds.size()) {
            return this.pageIds.get(i);
        }
        return null;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public String getPageTitleNotVisible() {
        return "Page not found";
    }

    public int getRecipeCount(int page) {
        return 0;
    }

    public Page getPage(int i) {
        return this.getPage(this.pageIds.get(i));
    }

    public Page getPage(String key) {
        return this.pages.get(key);
    }

    public void discoverPages(@Nonnull World world, @Nonnull EntityPlayer player) {
        for (Map.Entry<String, Page> e : this.pages.entrySet()) {
            if (this.isPageVisible(e.getKey()) || !e.getValue().discover(world, player)) continue;
            this.markPageAsNewlyVisible(e.getKey());
            Page bookmark = this.pageToBookmark.get(e.getValue());
            if (bookmark == null) continue;
            this.markPageAsRead(bookmark.getId());
        }
    }

    public void dumpSections() {
        HashMultimap inverseSections = HashMultimap.create();
        for (Map.Entry<Page, Page> e : this.pageToBookmark.entrySet()) {
            inverseSections.put((Object)e.getValue(), (Object)e.getKey());
        }
        inverseSections.asMap().entrySet().forEach(System.out::println);
    }

    public static enum ReadState {
        HIDDEN,
        VISIBLE,
        READ;

    }
}

