/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.client.gui;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.CircuitType;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorRedNetPort;
import erogenousbeef.bigreactors.gui.IBeefGuiControl;
import erogenousbeef.bigreactors.gui.controls.BeefGuiLabel;
import erogenousbeef.bigreactors.gui.controls.BeefGuiRedNetChannelSelector;
import erogenousbeef.bigreactors.gui.controls.grab.BeefGuiGrabSource;
import erogenousbeef.bigreactors.gui.controls.grab.RedNetConfigGrabTarget;
import erogenousbeef.bigreactors.gui.controls.grab.RedNetConfigGrabbable;
import erogenousbeef.bigreactors.net.CommonPacketHandler;
import erogenousbeef.bigreactors.net.helpers.RedNetChange;
import erogenousbeef.bigreactors.net.message.multiblock.ReactorRedNetPortChangeMessage;
import java.util.Arrays;
import java.util.LinkedList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiReactorRedNetPort
extends BeefGuiBase {
    protected static final int numChannels = 16;
    TileEntityReactorRedNetPort port;
    BeefGuiLabel titleString;
    BeefGuiLabel settingsString;
    BeefGuiLabel subSettingString;
    BeefGuiLabel subSettingValueString;
    private GuiButton commitBtn;
    private GuiButton subSettingForwardBtn;
    private GuiButton subSettingBackBtn;
    private ResourceLocation _guiBackground;
    protected static final String[] channelLabelStrings = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "Gray", "LightGray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
    public static final String[] grabbableTooltips = new String[]{"Input: Toggle reactor on/off", "Input: Change control rod insertion", "Input: Eject Waste", "Output: Fuel Temp (C)", "Output: Casing Temp (C)", "Output: Fuel mix (% fuel, 0-100)", "Output: Fuel amount", "Output: Waste amount", "Output: Energy amount (%)"};
    BeefGuiRedNetChannelSelector[] channelSelectors = new BeefGuiRedNetChannelSelector[16];
    RedNetConfigGrabTarget[] grabTargets = new RedNetConfigGrabTarget[16];
    private BlockPos[] subSettingCoords = new BlockPos[16];
    private boolean[] pulseActivated = new boolean[16];
    private int selectedChannel = 0;

    public GuiReactorRedNetPort(Container container, TileEntityReactorRedNetPort redNetPort) {
        super(container);
        this.port = redNetPort;
        this.field_146999_f = 255;
        this.field_147000_g = 214;
        this._guiBackground = BigReactors.createGuiResourceLocation("rednetport.png");
    }

    @Override
    public ResourceLocation getGuiBackground() {
        return this._guiBackground;
    }

    @Override
    public void func_73866_w_() {
        int i;
        super.func_73866_w_();
        int leftX = this.field_147003_i + 4;
        int topY = this.field_147009_r + 4;
        this.titleString = new BeefGuiLabel(this, "Reactor RedNet Port", leftX + 2, topY + 2);
        this.settingsString = new BeefGuiLabel(this, "Settings", leftX + 154, topY + 2);
        this.subSettingString = new BeefGuiLabel(this, "", leftX + 154, topY + 80);
        this.subSettingValueString = new BeefGuiLabel(this, "", leftX + 154, topY + 94);
        topY += this.titleString.getHeight() + 8;
        this.selectedChannel = 0;
        for (int i2 = 0; i2 < channelLabelStrings.length; i2 += 2) {
            this.channelSelectors[i2] = new BeefGuiRedNetChannelSelector(this, channelLabelStrings[i2], i2, leftX, topY, 60, 20);
            this.grabTargets[i2] = new RedNetConfigGrabTarget((BeefGuiBase)this, leftX + 42, topY + 2, this.port, i2);
            if (i2 == 0) {
                this.channelSelectors[i2].setSelected(true);
            }
            this.channelSelectors[i2 + 1] = new BeefGuiRedNetChannelSelector(this, channelLabelStrings[i2 + 1], i2 + 1, leftX += 74, topY, 60, 20);
            this.grabTargets[i2 + 1] = new RedNetConfigGrabTarget((BeefGuiBase)this, leftX + 42, topY + 2, this.port, i2 + 1);
            topY += 24;
            leftX = this.field_147003_i + 4;
            this.registerControl(this.channelSelectors[i2]);
            this.registerControl(this.channelSelectors[i2 + 1]);
            this.registerControl(this.grabTargets[i2]);
            this.registerControl(this.grabTargets[i2 + 1]);
        }
        CircuitType[] circuitTypes = CircuitType.values();
        RedNetConfigGrabbable[] grabbables = new RedNetConfigGrabbable[circuitTypes.length - 1];
        topY = this.field_147009_r + 21;
        leftX = this.field_147003_i + 156;
        for (int i3 = 1; i3 < circuitTypes.length; ++i3) {
            grabbables[i3 - 1] = new RedNetConfigGrabbable(grabbableTooltips[i3 - 1], circuitTypes[i3].getIcon(), circuitTypes[i3]);
            BeefGuiGrabSource source = new BeefGuiGrabSource(this, leftX, topY, grabbables[i3 - 1]);
            this.registerControl(source);
            if ((leftX += 20) < this.field_147003_i + 230) continue;
            leftX = this.field_147003_i + 156;
            topY += 20;
        }
        this.registerControl(this.titleString);
        this.registerControl(this.settingsString);
        this.registerControl(this.subSettingString);
        this.registerControl(this.subSettingValueString);
        this.commitBtn = new GuiButton(0, this.field_147003_i + 190, this.field_147009_r + 190, 56, 20, "Commit");
        this.commitBtn.field_146124_l = false;
        this.subSettingForwardBtn = new GuiButton(1, this.field_147003_i + 178, this.field_147009_r + 114, 20, 20, ">");
        this.subSettingBackBtn = new GuiButton(2, this.field_147003_i + 154, this.field_147009_r + 114, 20, 20, "<");
        this.subSettingForwardBtn.field_146125_m = false;
        this.subSettingBackBtn.field_146125_m = false;
        this.field_146292_n.add(this.commitBtn);
        this.field_146292_n.add(this.subSettingForwardBtn);
        this.field_146292_n.add(this.subSettingBackBtn);
        for (i = 0; i < 16; ++i) {
            CircuitType currentCircuitType = this.port.getChannelCircuitType(i);
            this.pulseActivated[i] = this.port.isInputActivatedOnPulse(i);
            if (currentCircuitType == CircuitType.DISABLED) {
                this.grabTargets[i].setSlotContents(null);
                continue;
            }
            this.grabTargets[i].setSlotContents(grabbables[currentCircuitType.ordinal() - 1]);
        }
        for (i = 0; i < this.subSettingCoords.length; ++i) {
            this.subSettingCoords[i] = this.port.getMappedCoord(i);
        }
        this.updateSubSettingValueText();
    }

    public void func_73876_c() {
        int i;
        super.func_73876_c();
        boolean hasChanges = false;
        boolean invalidSetting = false;
        for (RedNetConfigGrabTarget target : this.grabTargets) {
            if (!target.hasChanged()) continue;
            hasChanges = true;
        }
        for (i = 0; i < this.subSettingCoords.length; ++i) {
            if (!this.hasSubSettingChanged(i)) continue;
            hasChanges = true;
            break;
        }
        for (i = 0; i < 16; ++i) {
            if (this.port.isInputActivatedOnPulse(i) == this.pulseActivated[i]) continue;
            hasChanges = true;
            break;
        }
        this.commitBtn.field_146124_l = hasChanges && !invalidSetting;
    }

    protected boolean hasSubSettingChanged(int idx) {
        if (this.subSettingCoords[idx] == null) {
            if (this.port.getMappedCoord(idx) != null) {
                return true;
            }
        } else {
            if (this.port.getMappedCoord(idx) == null) {
                return true;
            }
            if (!this.subSettingCoords[idx].equals((Object)this.port.getMappedCoord(idx))) {
                return true;
            }
        }
        return false;
    }

    protected boolean hasSettingChanged(int idx) {
        return this.grabTargets[idx].hasChanged() || this.hasSubSettingChanged(idx) || this.port.isInputActivatedOnPulse(idx) != this.pulseActivated[idx];
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            RedNetChange[] packetData = this.getUpdatePacketData();
            if (packetData == null) {
                return;
            }
            CommonPacketHandler.INSTANCE.sendToServer((IMessage)new ReactorRedNetPortChangeMessage(this.port, packetData));
        }
        if (button.field_146127_k == 1 || button.field_146127_k == 2) {
            this.changeSubSetting(button.field_146127_k == 1);
        }
    }

    private RedNetChange[] getUpdatePacketData() {
        LinkedList<RedNetChange> packetData = new LinkedList<RedNetChange>();
        for (int i = 0; i < 16; ++i) {
            if (!this.hasSettingChanged(i)) continue;
            CircuitType circuitType = this.grabTargets[i].getCircuitType();
            RedNetChange change = new RedNetChange(i, circuitType, this.pulseActivated[i], this.subSettingCoords[i]);
            packetData.add(change);
        }
        if (packetData.size() < 1) {
            return null;
        }
        RedNetChange[] changes = new RedNetChange[packetData.size()];
        changes = packetData.toArray(changes);
        return changes;
    }

    @Override
    public void onControlClicked(IBeefGuiControl clickedControl) {
        if (clickedControl instanceof BeefGuiRedNetChannelSelector) {
            for (IBeefGuiControl control : this.controls) {
                if (!(control instanceof BeefGuiRedNetChannelSelector)) continue;
                BeefGuiRedNetChannelSelector selector = (BeefGuiRedNetChannelSelector)control;
                boolean wasSelected = selector.isSelected();
                selector.setSelected(control == clickedControl);
                if (control == clickedControl) {
                    this.selectedChannel = selector.getChannel();
                }
                this.onChannelChanged(selector.getChannel());
            }
        }
    }

    public void onChannelChanged(int changedChannel) {
        if (this.selectedChannel != changedChannel) {
            return;
        }
        CircuitType currentCircuitType = this.grabTargets[this.selectedChannel].getCircuitType();
        if (CircuitType.hasCoordinate(currentCircuitType)) {
            this.subSettingString.setLabelText("Control Rod: ");
            this.subSettingForwardBtn.field_146125_m = true;
            this.subSettingBackBtn.field_146125_m = true;
        } else if (TileEntityReactorRedNetPort.isInput(currentCircuitType) && CircuitType.canBeToggledBetweenPulseAndNormal(currentCircuitType)) {
            this.subSettingString.setLabelText("Activates On:");
            this.subSettingForwardBtn.field_146125_m = true;
            this.subSettingBackBtn.field_146125_m = true;
        } else if (currentCircuitType == CircuitType.inputEjectWaste) {
            this.subSettingString.setLabelText("Activates On:");
            this.subSettingForwardBtn.field_146125_m = false;
            this.subSettingBackBtn.field_146125_m = false;
        } else {
            this.subSettingString.setLabelText("");
            this.subSettingForwardBtn.field_146125_m = false;
            this.subSettingBackBtn.field_146125_m = false;
        }
        this.updateSubSettingValueText();
    }

    private String getControlRodLabelFromLocation(CircuitType circuitType, BlockPos location) {
        if (location == null) {
            return "-- ALL --";
        }
        TileEntity te = this.port.func_145831_w().func_175625_s(location);
        if (te instanceof TileEntityReactorControlRod) {
            TileEntityReactorControlRod rod = (TileEntityReactorControlRod)te;
            if (rod.getName().equals("")) {
                return String.format("x:%d, y:%d, z:%d", location.func_177958_n(), location.func_177956_o(), location.func_177952_p());
            }
            return rod.getName();
        }
        return "INVALID: " + location.toString();
    }

    private void changeSubSetting(boolean forward) {
        CircuitType circuitType = this.grabTargets[this.selectedChannel].getCircuitType();
        if (CircuitType.hasCoordinate(circuitType)) {
            BlockPos[] controlRodLocations = this.port.getReactorController().getControlRodLocations();
            int newIdx = 0;
            int oldIdx = Arrays.asList(controlRodLocations).indexOf(this.subSettingCoords[this.selectedChannel]);
            newIdx = forward ? oldIdx + 1 : (oldIdx == -1 ? controlRodLocations.length - 1 : oldIdx - 1);
            this.subSettingCoords[this.selectedChannel] = newIdx < 0 || newIdx >= controlRodLocations.length ? null : controlRodLocations[newIdx];
        } else if (CircuitType.canBeToggledBetweenPulseAndNormal(circuitType)) {
            this.pulseActivated[this.selectedChannel] = !this.pulseActivated[this.selectedChannel];
        }
        this.updateSubSettingValueText();
    }

    private void updateSubSettingValueText() {
        this.subSettingValueString.setLabelTooltip("");
        CircuitType circuitType = this.grabTargets[this.selectedChannel].getCircuitType();
        if (CircuitType.hasCoordinate(circuitType)) {
            this.subSettingValueString.setLabelText(this.getControlRodLabelFromLocation(circuitType, this.subSettingCoords[this.selectedChannel]));
        } else if (TileEntityReactorRedNetPort.isInput(circuitType) && CircuitType.canBeToggledBetweenPulseAndNormal(circuitType)) {
            this.subSettingValueString.setLabelText(this.pulseActivated[this.selectedChannel] ? "Pulse" : "Level");
        } else if (circuitType == CircuitType.inputEjectWaste) {
            this.subSettingValueString.setLabelText("Pulse");
        } else {
            this.subSettingValueString.setLabelText("");
        }
    }
}

