/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui.controls;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.gui.BeefGuiControlBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;

public abstract class BeefGuiVerticalProgressBar
extends BeefGuiControlBase {
    private static final int controlWidth = 20;
    private static final int controlHeight = 64;
    protected ResourceLocation controlResource = null;
    private double backgroundLeftU = this.getBackgroundLeftU();
    private double backgroundRightU = this.getBackgroundRightU();
    private double gradationLeftU = this.getGradationLeftU();
    private double gradationRightU = this.getGradationRightU();
    protected float barAbsoluteMaxHeight = this.height - 1;

    public BeefGuiVerticalProgressBar(BeefGuiBase container, int x, int y) {
        super(container, x, y, 20, 64);
    }

    protected boolean drawGradationMarks() {
        return false;
    }

    protected abstract ResourceLocation getBackgroundTexture();

    protected abstract float getProgress();

    protected abstract void drawProgressBar(Tessellator var1, TextureManager var2, int var3, int var4, int var5, int var6, int var7);

    protected double getBackgroundLeftU() {
        return 0.0;
    }

    protected double getBackgroundRightU() {
        return 0.32;
    }

    protected double getGradationLeftU() {
        return 0.77;
    }

    protected double getGradationRightU() {
        return 1.0;
    }

    @Override
    public void drawBackground(TextureManager renderEngine, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        if (null == this.controlResource) {
            this.controlResource = this.getBackgroundTexture();
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderEngine.func_110577_a(this.controlResource);
        vertexBuffer.func_181668_a(7, vertexBuffer.func_178973_g());
        vertexBuffer.func_181662_b((double)this.absoluteX, (double)(this.absoluteY + this.height), 0.0).func_187315_a(this.backgroundLeftU, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(this.absoluteX + this.width), (double)(this.absoluteY + this.height), 0.0).func_187315_a(this.backgroundRightU, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(this.absoluteX + this.width), (double)this.absoluteY, 0.0).func_187315_a(this.backgroundRightU, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)this.absoluteX, (double)this.absoluteY, 0.0).func_187315_a(this.backgroundLeftU, 0.0).func_181675_d();
        tessellator.func_78381_a();
        float progress = this.getProgress();
        if ((double)progress > 0.0) {
            int barHeight = Math.max(1, (int)Math.floor(progress * this.barAbsoluteMaxHeight));
            int barMinX = this.absoluteX + 1;
            int barMaxX = this.absoluteX + this.width - 4;
            int barMinY = this.absoluteY + this.height - barHeight;
            int barMaxY = this.absoluteY + this.height - 1;
            this.drawProgressBar(tessellator, renderEngine, barMinX, barMaxX, barMinY, barMaxY, 1);
        }
        if (this.drawGradationMarks()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            renderEngine.func_110577_a(this.controlResource);
            vertexBuffer.func_181668_a(7, vertexBuffer.func_178973_g());
            vertexBuffer.func_181662_b((double)this.absoluteX, (double)(this.absoluteY + this.height), 2.0).func_187315_a(this.gradationLeftU, 1.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(this.absoluteX + this.width - 4), (double)(this.absoluteY + this.height), 2.0).func_187315_a(this.gradationRightU, 1.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(this.absoluteX + this.width - 4), (double)this.absoluteY, 2.0).func_187315_a(this.gradationRightU, 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)this.absoluteX, (double)this.absoluteY, 2.0).func_187315_a(this.gradationLeftU, 0.0).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    @Override
    public void drawForeground(TextureManager renderEngine, int mouseX, int mouseY) {
    }
}

