/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingRecipe;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import wanion.lib.common.MetaItem;
import wanion.lib.common.Util;
import wanion.unidict.UniDict;
import wanion.unidict.UniOreDictionary;
import wanion.unidict.integration.AbstractIntegrationThread;

final class IEIntegration
extends AbstractIntegrationThread {
    private final boolean duplicateCheck;

    IEIntegration() {
        super("Immersive Engineering");
        this.duplicateCheck = UniDict.getConfig().ieIntegrationDuplicateRemoval;
    }

    public String call() {
        try {
            this.fixAlloyKilnRecipes();
            this.fixArcFurnaceRecipes();
            this.fixBlastFurnaceRecipes();
            this.fixCrusherRecipes();
            this.fixMetalPressRecipes();
            this.fixCokeOvenRecipes();
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
            e.printStackTrace();
        }
        return this.threadName + "The world's engineer appears to be more immersive.";
    }

    private void fixAlloyKilnRecipes() {
        ArrayList alloyRecipeList = AlloyRecipe.recipeList;
        ArrayList<AlloyRecipe> newRecipes = new ArrayList<AlloyRecipe>();
        Iterator alloyRecipeIterator = alloyRecipeList.iterator();
        while (alloyRecipeIterator.hasNext()) {
            AlloyRecipe alloyRecipe = (AlloyRecipe)alloyRecipeIterator.next();
            newRecipes.add(new AlloyRecipe(this.resourceHandler.getMainItemStack(alloyRecipe.output), (Object)alloyRecipe.input0, (Object)alloyRecipe.input1, alloyRecipe.time));
            alloyRecipeIterator.remove();
        }
        alloyRecipeList.clear();
        alloyRecipeList.addAll(newRecipes);
    }

    private void fixArcFurnaceRecipes() {
        ArrayList arcFurnaceRecipes = ArcFurnaceRecipe.recipeList;
        ArrayList<Object> correctRecipes = new ArrayList<Object>(new Double((double)arcFurnaceRecipes.size() * 1.3).intValue());
        Iterator arcFurnaceRecipeIterator = arcFurnaceRecipes.iterator();
        while (arcFurnaceRecipeIterator.hasNext()) {
            ArcFurnaceRecipe recipe = (ArcFurnaceRecipe)arcFurnaceRecipeIterator.next();
            int time = (int)Math.floor((float)recipe.getTotalProcessTime() / ArcFurnaceRecipe.timeModifier);
            int energy = (int)Math.floor((float)recipe.getTotalProcessEnergy() / ArcFurnaceRecipe.energyModifier / (float)recipe.getTotalProcessTime());
            if (recipe instanceof ArcRecyclingRecipe) {
                Map outputs = (Map)Util.getField(ArcRecyclingRecipe.class, (String)"outputs", (Object)recipe, Map.class);
                if (outputs == null || outputs.isEmpty()) continue;
                HashMap newOutputs = new HashMap();
                outputs.forEach((itemStack, chance) -> newOutputs.put(this.resourceHandler.getMainItemStack((ItemStack)itemStack), chance));
                correctRecipes.add(new ArcRecyclingRecipe(newOutputs, (Object)recipe.input, time, energy));
            } else {
                ItemStack correctOutput = this.resourceHandler.getMainItemStack(recipe.output);
                ItemStack correctSlag = this.resourceHandler.getMainItemStack(recipe.slag);
                if (correctOutput == recipe.output && correctSlag == recipe.slag) continue;
                correctRecipes.add(new ArcFurnaceRecipe(correctOutput, (Object)recipe.input, correctSlag, time, energy, (Object[])recipe.additives));
            }
            arcFurnaceRecipeIterator.remove();
        }
        arcFurnaceRecipes.addAll(correctRecipes);
    }

    private void fixBlastFurnaceRecipes() {
        ArrayList correctRecipes = new ArrayList(new Double((double)BlastFurnaceRecipe.recipeList.size() * 1.3).intValue());
        correctRecipes.addAll(BlastFurnaceRecipe.recipeList.stream().map(blastFurnaceRecipe -> new BlastFurnaceRecipe(this.resourceHandler.getMainItemStack(blastFurnaceRecipe.output), blastFurnaceRecipe.input, blastFurnaceRecipe.time, this.resourceHandler.getMainItemStack(blastFurnaceRecipe.slag))).collect(Collectors.toList()));
        BlastFurnaceRecipe.recipeList.clear();
        BlastFurnaceRecipe.recipeList.addAll(correctRecipes);
    }

    private void fixCrusherRecipes() {
        ArrayList crusherRecipes = CrusherRecipe.recipeList;
        ArrayList<CrusherRecipe> correctRecipes = new ArrayList<CrusherRecipe>(crusherRecipes.size());
        TIntHashSet uniques = new TIntHashSet(crusherRecipes.size(), 1.0f);
        Iterator crusherRecipesIterator = crusherRecipes.iterator();
        while (crusherRecipesIterator.hasNext()) {
            int recipeId;
            CrusherRecipe crusherRecipe = (CrusherRecipe)crusherRecipesIterator.next();
            ItemStack output = crusherRecipe.output;
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(output);
            if (output == correctOutput) continue;
            ItemStack input = null;
            if (crusherRecipe.oreInputString != null) {
                input = UniOreDictionary.getFirstEntry(crusherRecipe.oreInputString);
            }
            if (input == null && crusherRecipe.input.oreName != null) {
                input = UniOreDictionary.getFirstEntry(crusherRecipe.input.oreName);
            }
            if (input == null) {
                input = crusherRecipe.input.stack;
            }
            int n = recipeId = this.duplicateCheck ? MetaItem.getCumulative((ItemStack[])new ItemStack[]{input, correctOutput}) : 0;
            if (recipeId == 0 || !uniques.contains(recipeId)) {
                CrusherRecipe newRecipe = new CrusherRecipe(correctOutput, (Object)crusherRecipe.input, (int)Math.floor((float)crusherRecipe.getTotalProcessEnergy() / CrusherRecipe.energyModifier));
                if (crusherRecipe.secondaryOutput != null && crusherRecipe.secondaryChance != null && crusherRecipe.secondaryOutput.length == crusherRecipe.secondaryChance.length) {
                    IEIntegration.setSecondaryOutputAndChance(newRecipe, this.resourceHandler.getMainItemStacks(crusherRecipe.secondaryOutput), crusherRecipe.secondaryChance);
                }
                correctRecipes.add(newRecipe);
                uniques.add(recipeId);
            }
            crusherRecipesIterator.remove();
        }
        crusherRecipes.addAll(correctRecipes);
    }

    private void fixMetalPressRecipes() {
        ArrayListMultimap metalPressRecipes = MetalPressRecipe.recipeList;
        ArrayListMultimap correctRecipes = ArrayListMultimap.create();
        TIntHashSet uniques = new TIntHashSet(metalPressRecipes.size(), 1.0f);
        Iterator metalPressRecipesIterator = metalPressRecipes.values().iterator();
        while (metalPressRecipesIterator.hasNext()) {
            MetalPressRecipe metalPressRecipe = (MetalPressRecipe)metalPressRecipesIterator.next();
            ItemStack output = this.resourceHandler.getMainItemStack(metalPressRecipe.output);
            if (output == metalPressRecipe.output) continue;
            int id = MetaItem.getCumulative((ItemStack[])new ItemStack[]{output, metalPressRecipe.mold.stack});
            if (!uniques.contains(id)) {
                correctRecipes.put((Object)metalPressRecipe.mold, (Object)new MetalPressRecipe(output, (Object)metalPressRecipe.input, metalPressRecipe.mold, (int)Math.floor((float)metalPressRecipe.getTotalProcessEnergy() / MetalPressRecipe.energyModifier)).setInputSize(metalPressRecipe.input.inputSize));
                uniques.add(id);
            }
            metalPressRecipesIterator.remove();
        }
        metalPressRecipes.putAll((Multimap)correctRecipes);
    }

    private static void setSecondaryOutputAndChance(@Nonnull CrusherRecipe crusherRecipe, ItemStack[] itemStacks, float[] chance) {
        ArrayList<Object> secondaryAndChanceList = new ArrayList<Object>();
        for (int i = 0; i < itemStacks.length; ++i) {
            secondaryAndChanceList.add(itemStacks[i]);
            secondaryAndChanceList.add(Float.valueOf(chance[i]));
        }
        crusherRecipe.addToSecondaryOutput(secondaryAndChanceList.toArray());
    }

    private void fixCokeOvenRecipes() {
        List correctRecipes = CokeOvenRecipe.recipeList.stream().map(cokeOvenRecipe -> new CokeOvenRecipe(this.resourceHandler.getMainItemStack(cokeOvenRecipe.output), cokeOvenRecipe.input, cokeOvenRecipe.time, cokeOvenRecipe.creosoteOutput)).collect(Collectors.toList());
        CokeOvenRecipe.recipeList.clear();
        CokeOvenRecipe.recipeList.addAll(correctRecipes);
    }
}

