/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.teletoro;

import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TeleToroUtil {
    public static Block getBlock(IBlockAccess world, int i, int j, int k) {
        return world.func_180495_p(new BlockPos(i, j, k)).func_177230_c();
    }

    public static void resetStatusFields(EntityPlayerMP player) {
        try {
            Field lastExperience = TeleToroUtil.getReflectionField("field_71144_ck", "lastExperience");
            Field lastHealth = TeleToroUtil.getReflectionField("field_71149_ch", "lastHealth");
            Field lastFoodLevel = TeleToroUtil.getReflectionField("field_71146_ci", "lastFoodLevel");
            lastExperience.setInt(player, -1);
            lastHealth.setFloat(player, -1.0f);
            lastFoodLevel.setInt(player, -1);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set reset status fields via reflection", e);
        }
    }

    public static void setInvulnerableDimensionChange(EntityPlayerMP thePlayer) {
        TeleToroUtil.setInvulnerableDimensionChange(thePlayer, true);
    }

    public static void setInvulnerableDimensionChange(EntityPlayerMP thePlayer, boolean enable) {
        try {
            Field invulnerableDimensionChange = TeleToroUtil.getReflectionField("field_184851_cj", "invulnerableDimensionChange");
            invulnerableDimensionChange.setBoolean(thePlayer, enable);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set invulnerableDimensionChange via reflection", e);
        }
    }

    public static Field getReflectionField(String ... names) {
        Field f = null;
        for (String name : names) {
            f = TeleToroUtil.getFieldFromPlayer(name);
            if (f == null) continue;
            f.setAccessible(true);
            return f;
        }
        throw new RuntimeException(TeleToroUtil.join(names, ", ") + " field not found in " + EntityPlayerMP.class.getName());
    }

    public static Field getFieldFromPlayer(String name) {
        try {
            return EntityPlayerMP.class.getDeclaredField(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String join(String[] aArr, String sSep) {
        StringBuilder sbStr = new StringBuilder();
        int il = aArr.length;
        for (int i = 0; i < il; ++i) {
            if (i > 0) {
                sbStr.append(sSep);
            }
            sbStr.append(aArr[i]);
        }
        return sbStr.toString();
    }

    public static enum TeleportorType {
        PORTAL,
        FALL,
        PEARL,
        POST_TELEPORT;

    }
}

