/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.teletoro;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.torocraft.teletoro.TeleToroUtil;
import net.torocraft.teletoro.blocks.BlockEnder;
import net.torocraft.teletoro.blocks.BlockLinkedTeletoryPortal;
import net.torocraft.teletoro.blocks.BlockTeletoryPortal;
import net.torocraft.teletoro.item.armor.ItemEnderArmor;
import net.torocraft.teletoro.teleporter.FallFromTeletoryTeleporter;
import net.torocraft.teletoro.teleporter.TeletoryPearlTeleporter;
import net.torocraft.teletoro.teleporter.TeletoryTeleporter;
import net.torocraft.teletoro.world.TeletoryWorldProvider;

public class Teletory {
    public static final int DIMID = 16;
    public static final DimensionType TYPE = DimensionType.register((String)"teletory", (String)"_teletory", (int)16, TeletoryWorldProvider.class, (boolean)true);
    public static ConcurrentHashMap<Runnable, Integer> runQueue = new ConcurrentHashMap();

    public static void changeEntityDimension(Entity entity, TeleToroUtil.TeleportorType type) {
        runQueue.put(new TeleportRunner(entity, type), 0);
    }

    public static void init(FMLInitializationEvent event) {
        DimensionManager.registerDimension((int)16, (DimensionType)TYPE);
    }

    private boolean isRunTick(World world) {
        return world.func_82737_E() % 60L == 0L;
    }

    @SubscribeEvent
    public void limitBuildHeight(BlockEvent.PlaceEvent event) {
        if (event.getBlockSnapshot() != null && event.getBlockSnapshot().getDimId() != 16) {
            return;
        }
        if (event.getPlayer() == null) {
            return;
        }
        if (event.getBlockSnapshot().getPos().func_177956_o() > 32) {
            event.getPlayer().func_145747_a((ITextComponent)new TextComponentString("max build height"));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void limitEnderBlockDropsInTheTeletory(BlockEvent.HarvestDropsEvent event) {
        if (!this.isEnderBlock(event)) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        if (player == null || player.field_71093_bK != 16) {
            return;
        }
        List drops = event.getDrops();
        ArrayList<ItemStack> dropsToRemove = new ArrayList<ItemStack>(drops.size());
        Random rand = event.getWorld().field_73012_v;
        for (ItemStack drop : drops) {
            if (rand.nextInt(10) <= 2) continue;
            dropsToRemove.add(drop);
        }
        drops.removeAll(dropsToRemove);
    }

    private boolean isEnderBlock(BlockEvent.HarvestDropsEvent event) {
        return event.getState().func_177230_c().func_149739_a().equals("tile.enderBlock");
    }

    public static int getNextDimension(Entity entity) {
        if (entity.field_71093_bK != 16) {
            return 16;
        }
        return 0;
    }

    @SubscribeEvent
    public void handleWorldTick(TickEvent.WorldTickEvent event) {
        if (runQueue.size() < 1) {
            return;
        }
        this.runNextQueueItem();
    }

    protected void runNextQueueItem() {
        Runnable nextRunnable = this.popRunQueue();
        if (nextRunnable != null) {
            nextRunnable.run();
        }
    }

    private Runnable popRunQueue() {
        Map.Entry<Runnable, Integer> next = null;
        Iterator<Map.Entry<Runnable, Integer>> iterator = runQueue.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<Runnable, Integer> n;
            next = n = iterator.next();
        }
        if (next == null) {
            return null;
        }
        if ((Integer)next.getValue() < 1) {
            runQueue.remove(next.getKey());
            return next.getKey();
        }
        next.setValue(next.getValue() - 1);
        return null;
    }

    @SubscribeEvent
    public void handlePlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        if (event.player.field_71093_bK == 16) {
            this.feelThePainOfTheTeletory(event);
        }
    }

    protected void feelThePainOfTheTeletory(TickEvent.PlayerTickEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        if (event.player.field_70163_u < -5.0) {
            Teletory.changeEntityDimension((Entity)event.player, TeleToroUtil.TeleportorType.FALL);
        }
        if (this.isRunTick(event.player.field_70170_p)) {
            this.hurtPlayer((EntityLivingBase)event.player);
            this.spawnParticles((Entity)event.player);
        }
    }

    private void hurtPlayer(EntityLivingBase entity) {
        if (this.isStandingOnEnderBlock(entity)) {
            return;
        }
        if (Teletory.isWearingEnderBoots(entity)) {
            Teletory.damageEnderBoots(entity);
            return;
        }
        entity.field_70143_R = 0.0f;
        entity.func_70097_a(DamageSource.field_76379_h, 4.0f);
        if (entity.field_70170_p.field_73012_v.nextFloat() < 0.005f && entity.field_70170_p.func_82736_K().func_82766_b("doMobSpawning")) {
            EntityEndermite entityendermite = new EntityEndermite(entity.field_70170_p);
            entityendermite.func_175496_a(true);
            entityendermite.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
            entity.field_70170_p.func_72838_d((Entity)entityendermite);
        }
    }

    public static void damageEnderBoots(EntityLivingBase entity) {
        ItemStack boots = entity.func_184582_a(EntityEquipmentSlot.FEET);
        boots.func_77972_a(1, entity);
    }

    public static boolean isWearingEnderBoots(EntityLivingBase entity) {
        ItemStack boots = entity.func_184582_a(EntityEquipmentSlot.FEET);
        if (boots == null || boots.func_190916_E() != 1) {
            return false;
        }
        return boots.func_77973_b() == ItemEnderArmor.bootsItem;
    }

    private boolean isStandingOnEnderBlock(EntityLivingBase entity) {
        IBlockState block = entity.field_70170_p.func_180495_p(entity.func_180425_c().func_177977_b());
        return BlockEnder.INSTANCE == block.func_177230_c();
    }

    private void spawnParticles(Entity entity) {
        for (int i = 0; i < 32; ++i) {
            entity.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, entity.field_70165_t, entity.field_70163_u + entity.field_70170_p.field_73012_v.nextDouble() * 2.0, entity.field_70161_v, entity.field_70170_p.field_73012_v.nextGaussian(), 0.0, entity.field_70170_p.field_73012_v.nextGaussian(), new int[0]);
        }
    }

    @SubscribeEvent
    public void useFlintAndSteel(PlayerInteractEvent.RightClickBlock event) {
        boolean created;
        Block i1;
        if (event.getItemStack() == null || event.getItemStack().func_77973_b() != Items.field_151033_d) {
            return;
        }
        BlockPos pos = event.getPos();
        int par4 = pos.func_177958_n();
        int par5 = pos.func_177956_o();
        int par6 = pos.func_177952_p();
        int par7 = event.getFace() == null ? 0 : event.getFace().func_176745_a();
        if (par7 == 0) {
            --par5;
        }
        if (par7 == 1) {
            ++par5;
        }
        if (par7 == 2) {
            --par6;
        }
        if (par7 == 3) {
            ++par6;
        }
        if (par7 == 4) {
            --par4;
        }
        if (par7 == 5) {
            ++par4;
        }
        if ((i1 = TeleToroUtil.getBlock((IBlockAccess)event.getWorld(), par4, par5, par6)) == Blocks.field_150350_a && (created = BlockTeletoryPortal.INSTANCE.trySpawnPortal(event.getWorld(), new BlockPos(par4, par5, par6)))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void enderPearlTeleport(BlockEvent.BreakEvent ev) {
        if (ev.getPlayer() == null || ev.getPlayer().func_184812_l_()) {
            return;
        }
        if (ev.getState().func_177230_c() == BlockTeletoryPortal.INSTANCE || ev.getState().func_177230_c() == BlockLinkedTeletoryPortal.INSTANCE) {
            ev.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void enderPearlTeleport(EnderTeleportEvent ev) {
        if (ev.getEntity().func_130014_f_().field_72995_K || !(ev.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)ev.getEntity();
        if (Teletory.isWearingEnderBoots((EntityLivingBase)player)) {
            ev.setAttackDamage(0.01f);
            Teletory.damageEnderBoots((EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public void fallOutOfTeletory(LivingHurtEvent ev) {
        if (ev.getEntity().func_130014_f_().field_72995_K || !(ev.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        if (ev.getSource() != DamageSource.field_76380_i) {
            return;
        }
        EntityPlayerMP thePlayer = (EntityPlayerMP)ev.getEntity();
        if (thePlayer.field_71093_bK != 16) {
            return;
        }
        ev.setCanceled(true);
        Teletory.changeEntityDimension((Entity)thePlayer, TeleToroUtil.TeleportorType.FALL);
    }

    private static boolean changePlayerDimension(EntityPlayerMP player, int dimId, TeleToroUtil.TeleportorType type) {
        if (!ForgeHooks.onTravelToDimension((Entity)player, (int)dimId)) {
            return false;
        }
        if (player == null) {
            return false;
        }
        WorldServer world = player.field_71133_b.func_71218_a(dimId);
        Teleporter teleporter = Teletory.getTeleporter(world, type);
        TeleToroUtil.setInvulnerableDimensionChange(player);
        player.field_71088_bW = 10;
        player.field_71133_b.func_184103_al().transferPlayerToDimension(player, dimId, teleporter);
        TeleToroUtil.resetStatusFields(player);
        return true;
    }

    private static Teleporter getTeleporter(WorldServer world, TeleToroUtil.TeleportorType type) {
        return Teletory.getCachedTeleporter(world, type);
    }

    private static Class<? extends Teleporter> getTeleporterClass(TeleToroUtil.TeleportorType type) {
        switch (type) {
            case FALL: {
                return FallFromTeletoryTeleporter.class;
            }
            case PORTAL: {
                return TeletoryTeleporter.class;
            }
            case PEARL: {
                return TeletoryPearlTeleporter.class;
            }
        }
        throw new UnsupportedOperationException("unknown teleporter [" + (Object)((Object)type) + "]");
    }

    private static Teleporter getNewTeleporterInstance(WorldServer world, TeleToroUtil.TeleportorType type) {
        switch (type) {
            case FALL: {
                return new FallFromTeletoryTeleporter(world);
            }
            case PORTAL: {
                return new TeletoryTeleporter(world);
            }
            case PEARL: {
                return new TeletoryPearlTeleporter(world);
            }
        }
        throw new UnsupportedOperationException("unknown teleporter [" + (Object)((Object)type) + "]");
    }

    private static Teleporter getCachedTeleporter(WorldServer world, TeleToroUtil.TeleportorType type) {
        Class<? extends Teleporter> clazz = Teletory.getTeleporterClass(type);
        for (Teleporter t : world.customTeleporters) {
            if (!t.getClass().getName().equals(clazz.getName())) continue;
            return t;
        }
        Teleporter t = Teletory.getNewTeleporterInstance(world, type);
        world.customTeleporters.add(t);
        return t;
    }

    private static class AchievementRunner
    implements Runnable {
        private final EntityPlayerMP player;

        public AchievementRunner(EntityPlayerMP player) {
            this.player = player;
        }

        @Override
        public void run() {
            if (this.player == null) {
                return;
            }
            if (this.player.field_71093_bK == 16) {
                // empty if block
            }
        }
    }

    private static class TeleportRunner
    implements Runnable {
        private final Entity entity;
        private final TeleToroUtil.TeleportorType type;

        public TeleportRunner(Entity entity, TeleToroUtil.TeleportorType type) {
            this.entity = entity;
            this.type = type;
        }

        @Override
        public void run() {
            if (this.entity == null || this.type == null) {
                return;
            }
            if (this.entity instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)this.entity;
                int nextDimension = Teletory.getNextDimension((Entity)player);
                Teletory.changePlayerDimension(player, nextDimension, this.type);
                runQueue.put(new AchievementRunner((EntityPlayerMP)this.entity), 0);
            }
        }
    }
}

