/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.teletoro.blocks;

import com.google.common.cache.LoadingCache;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockAbstractPortal
extends BlockBreakable {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177706_a((String)"axis", EnumFacing.Axis.class, (Enum[])new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z});
    protected static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);

    public BlockAbstractPortal() {
        super(Material.field_151567_E, false);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X));
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
            case X: {
                return X_AABB;
            }
            default: {
                return Y_AABB;
            }
            case Z: 
        }
        return Z_AABB;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public static int getMetaForAxis(EnumFacing.Axis axis) {
        return axis == EnumFacing.Axis.X ? 1 : (axis == EnumFacing.Axis.Z ? 2 : 0);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean trySpawnPortal(World worldIn, BlockPos pos) {
        Size size = this.getSizer(worldIn, pos, EnumFacing.Axis.X);
        if (size.isValid() && size.portalBlockCount == 0) {
            size.placePortalBlocks();
            return true;
        }
        Size size1 = this.getSizer(worldIn, pos, EnumFacing.Axis.Z);
        if (size1.isValid() && size1.portalBlockCount == 0) {
            size1.placePortalBlocks();
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.breakPortalBlocks(state, worldIn, pos);
    }

    public void breakPortalBlocks(IBlockState state, World world, BlockPos pos) {
        Size sizer;
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (axis == EnumFacing.Axis.X) {
            Size sizer2 = this.getSizer(world, pos, EnumFacing.Axis.X);
            if (!sizer2.isValid() || sizer2.portalBlockCount < sizer2.width * sizer2.height) {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        } else if (!(axis != EnumFacing.Axis.Z || (sizer = this.getSizer(world, pos, EnumFacing.Axis.Z)).isValid() && sizer.portalBlockCount >= sizer.width * sizer.height)) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        boolean flag5;
        pos = pos.func_177972_a(side);
        EnumFacing.Axis enumfacing$axis = null;
        if (blockState.func_177230_c() == this) {
            enumfacing$axis = (EnumFacing.Axis)blockState.func_177229_b(AXIS);
            if (enumfacing$axis == null) {
                return false;
            }
            if (enumfacing$axis == EnumFacing.Axis.Z && side != EnumFacing.EAST && side != EnumFacing.WEST) {
                return false;
            }
            if (enumfacing$axis == EnumFacing.Axis.X && side != EnumFacing.SOUTH && side != EnumFacing.NORTH) {
                return false;
            }
        }
        boolean flag = blockAccess.func_180495_p(pos.func_177976_e()).func_177230_c() == this && blockAccess.func_180495_p(pos.func_177985_f(2)).func_177230_c() != this;
        boolean flag1 = blockAccess.func_180495_p(pos.func_177974_f()).func_177230_c() == this && blockAccess.func_180495_p(pos.func_177965_g(2)).func_177230_c() != this;
        boolean flag2 = blockAccess.func_180495_p(pos.func_177978_c()).func_177230_c() == this && blockAccess.func_180495_p(pos.func_177964_d(2)).func_177230_c() != this;
        boolean flag3 = blockAccess.func_180495_p(pos.func_177968_d()).func_177230_c() == this && blockAccess.func_180495_p(pos.func_177970_e(2)).func_177230_c() != this;
        boolean flag4 = flag || flag1 || enumfacing$axis == EnumFacing.Axis.X;
        boolean bl = flag5 = flag2 || flag3 || enumfacing$axis == EnumFacing.Axis.Z;
        return flag4 && side == EnumFacing.WEST ? true : (flag4 && side == EnumFacing.EAST ? true : (flag5 && side == EnumFacing.NORTH ? true : flag5 && side == EnumFacing.SOUTH));
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (world.field_72995_K || entity.func_184187_bx() != null || entity.func_184207_aI()) {
            return;
        }
        if (entity.field_71088_bW > 0) {
            entity.field_71088_bW = 10;
        } else if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            this.onPlayerEnterPortal(player, pos);
            player.field_71088_bW = 10;
        }
    }

    protected abstract void onPlayerEnterPortal(EntityPlayerMP var1, BlockPos var2);

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)((meta & 3) == 2 ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            worldIn.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
        }
    }

    public int func_176201_c(IBlockState state) {
        return BlockAbstractPortal.getMetaForAxis((EnumFacing.Axis)state.func_177229_b(AXIS));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z);
                    }
                    case Z: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS});
    }

    public BlockPattern.PatternHelper createPatternHelper(World worldIn, BlockPos p_181089_2_) {
        EnumFacing.Axis enumfacing$axis = EnumFacing.Axis.Z;
        Size blockportal$size = this.getSizer(worldIn, p_181089_2_, EnumFacing.Axis.X);
        LoadingCache loadingcache = BlockPattern.func_181627_a((World)worldIn, (boolean)true);
        if (!blockportal$size.isValid()) {
            enumfacing$axis = EnumFacing.Axis.X;
            blockportal$size = this.getSizer(worldIn, p_181089_2_, EnumFacing.Axis.Z);
        }
        if (!blockportal$size.isValid()) {
            return new BlockPattern.PatternHelper(p_181089_2_, EnumFacing.NORTH, EnumFacing.UP, loadingcache, 1, 1, 1);
        }
        int[] aint = new int[EnumFacing.AxisDirection.values().length];
        EnumFacing enumfacing = blockportal$size.rightDir.func_176735_f();
        BlockPos blockpos = blockportal$size.bottomLeft.func_177981_b(blockportal$size.getHeight() - 1);
        for (EnumFacing.AxisDirection enumfacing$axisdirection : EnumFacing.AxisDirection.values()) {
            BlockPattern.PatternHelper blockpattern$patternhelper = new BlockPattern.PatternHelper(enumfacing.func_176743_c() == enumfacing$axisdirection ? blockpos : blockpos.func_177967_a(blockportal$size.rightDir, blockportal$size.getWidth() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)enumfacing$axisdirection, (EnumFacing.Axis)enumfacing$axis), EnumFacing.UP, loadingcache, blockportal$size.getWidth(), blockportal$size.getHeight(), 1);
            for (int i = 0; i < blockportal$size.getWidth(); ++i) {
                for (int j = 0; j < blockportal$size.getHeight(); ++j) {
                    BlockWorldState blockworldstate = blockpattern$patternhelper.func_177670_a(i, j, 1);
                    if (blockworldstate.func_177509_a() == null || blockworldstate.func_177509_a().func_185904_a() == Material.field_151579_a) continue;
                    int n = enumfacing$axisdirection.ordinal();
                    aint[n] = aint[n] + 1;
                }
            }
        }
        EnumFacing.AxisDirection enumfacing$axisdirection1 = EnumFacing.AxisDirection.POSITIVE;
        for (EnumFacing.AxisDirection enumfacing$axisdirection2 : EnumFacing.AxisDirection.values()) {
            if (aint[enumfacing$axisdirection2.ordinal()] >= aint[enumfacing$axisdirection1.ordinal()]) continue;
            enumfacing$axisdirection1 = enumfacing$axisdirection2;
        }
        return new BlockPattern.PatternHelper(enumfacing.func_176743_c() == enumfacing$axisdirection1 ? blockpos : blockpos.func_177967_a(blockportal$size.rightDir, blockportal$size.getWidth() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)enumfacing$axisdirection1, (EnumFacing.Axis)enumfacing$axis), EnumFacing.UP, loadingcache, blockportal$size.getWidth(), blockportal$size.getHeight(), 1);
    }

    public abstract Size getSizer(World var1, BlockPos var2, EnumFacing.Axis var3);

    public static abstract class Size {
        private final World world;
        private final EnumFacing.Axis axis;
        private final EnumFacing rightDir;
        private final EnumFacing leftDir;
        public int portalBlockCount = 0;
        private BlockPos bottomLeft;
        private int height;
        private int width;

        public abstract Block getFrameBlock();

        public abstract BlockAbstractPortal getPortalBlock();

        public Size(World worldIn, BlockPos pos, EnumFacing.Axis axis) {
            this.world = worldIn;
            this.axis = axis;
            if (axis == EnumFacing.Axis.X) {
                this.leftDir = EnumFacing.EAST;
                this.rightDir = EnumFacing.WEST;
            } else {
                this.leftDir = EnumFacing.NORTH;
                this.rightDir = EnumFacing.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.isEmptyBlock(worldIn.func_180495_p(pos.func_177977_b()).func_177230_c())) {
                pos = pos.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos p_180120_1_, EnumFacing p_180120_2_) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.isEmptyBlock(this.world.func_180495_p(blockpos = p_180120_1_.func_177967_a(p_180120_2_, i)).func_177230_c()) && this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == this.getFrameBlock(); ++i) {
            }
            Block block = this.world.func_180495_p(p_180120_1_.func_177967_a(p_180120_2_, i)).func_177230_c();
            return block == this.getFrameBlock() ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    Block block = this.world.func_180495_p(blockpos).func_177230_c();
                    if (!this.isEmptyBlock(block)) break block0;
                    if (block == this.getPortalBlock()) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? (block = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir)).func_177230_c()) != this.getFrameBlock() : i == this.width - 1 && (block = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir)).func_177230_c()) != this.getFrameBlock()) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                if (this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height)).func_177230_c() == this.getFrameBlock()) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        private Material getMaterial(Block blockIn) {
            try {
                return blockIn.func_149688_o(null);
            }
            catch (Exception e) {
                return Material.field_151576_e;
            }
        }

        protected boolean isEmptyBlock(Block blockIn) {
            return this.getMaterial(blockIn) == Material.field_151579_a || blockIn == Blocks.field_150480_ab || blockIn == this.getPortalBlock();
        }

        public boolean isValid() {
            boolean valid = this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
            return valid;
        }

        public void placePortalBlocks() {
            this.placePortalBlocks(this.getPortalBlock());
        }

        public void placePortalBlocks(BlockAbstractPortal portalBlock) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    IBlockState blockState = portalBlock == null ? Blocks.field_150350_a.func_176223_P() : portalBlock.func_176223_P().func_177226_a(AXIS, (Comparable)this.axis);
                    this.world.func_180501_a(blockpos.func_177981_b(j), blockState, 2);
                }
            }
        }

        public BlockPos getBottomLeft() {
            return this.bottomLeft;
        }
    }
}

