/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.teletoro.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.torocraft.teletoro.TeleToroUtil;
import net.torocraft.teletoro.Teletory;
import net.torocraft.teletoro.blocks.BlockAbstractPortal;
import net.torocraft.teletoro.blocks.BlockEnder;
import net.torocraft.teletoro.blocks.TileEntityLinkedTeletoryPortal;
import net.torocraft.teletoro.item.ItemTeletoryPortalLinker;

@Mod.EventBusSubscriber
public class BlockLinkedTeletoryPortal
extends BlockAbstractPortal
implements ITileEntityProvider {
    public static BlockLinkedTeletoryPortal INSTANCE;
    public static Item ITEM_INSTANCE;
    public static final String NAME = "linkedteletoryportalblock";
    public static ResourceLocation REGISTRY_NAME;

    @SubscribeEvent
    public static void init(RegistryEvent.Register<Block> event) {
        INSTANCE = (BlockLinkedTeletoryPortal)new BlockLinkedTeletoryPortal().func_149663_c(NAME);
        INSTANCE.setRegistryName(REGISTRY_NAME);
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE);
    }

    @SubscribeEvent
    public static void initItem(RegistryEvent.Register<Item> event) {
        ITEM_INSTANCE = new ItemBlock((Block)INSTANCE);
        ITEM_INSTANCE.setRegistryName(REGISTRY_NAME);
        event.getRegistry().register((IForgeRegistryEntry)ITEM_INSTANCE);
    }

    public static void registerRenders() {
        ModelResourceLocation model = new ModelResourceLocation("teletoro:linkedteletoryportalblock", "inventory");
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(ITEM_INSTANCE, 0, model);
    }

    public BlockLinkedTeletoryPortal() {
        this.field_149758_A = true;
    }

    @Override
    public Size getSizer(World worldIn, BlockPos p_i45694_2_, EnumFacing.Axis p_i45694_3_) {
        return new Size(worldIn, p_i45694_2_, p_i45694_3_);
    }

    @Override
    protected void onPlayerEnterPortal(EntityPlayerMP player, BlockPos thisPortalLocation) {
        ItemTeletoryPortalLinker.ControlBlockLocation thisPortal = ItemTeletoryPortalLinker.findControllerBlock(player.field_70170_p, thisPortalLocation, ItemTeletoryPortalLinker.LINKED_SIZER);
        if (thisPortal == null) {
            return;
        }
        TileEntityLinkedTeletoryPortal te = this.getTileEntity(player, thisPortal.pos);
        if (te == null) {
            this.breakPortal(player, thisPortalLocation);
            return;
        }
        if (te.getDimId() != player.field_71093_bK) {
            this.breakPortal(player, thisPortalLocation);
            return;
        }
        if (te.getDestination() == null) {
            this.breakPortal(player, thisPortalLocation);
            return;
        }
        ItemTeletoryPortalLinker.ControlBlockLocation remotePortal = ItemTeletoryPortalLinker.findControllerBlock(player.field_70170_p, te.getDestination(), ItemTeletoryPortalLinker.LINKED_SIZER);
        if (remotePortal == null) {
            this.breakPortal(player, thisPortalLocation);
            return;
        }
        if (player.field_70170_p.func_180495_p(remotePortal.pos).func_177230_c() != INSTANCE) {
            this.breakPortal(player, thisPortalLocation);
            return;
        }
        float yaw = EnumFacing.Axis.X.equals((Object)remotePortal.axis) ? (te.getSide() == 1 ? 0.0f : 180.0f) : (te.getSide() == 1 ? -90.0f : 90.0f);
        Vec3d transportTo = EnumFacing.Axis.X.equals((Object)remotePortal.axis) ? new Vec3d(this.d(remotePortal.pos.func_177958_n()) + 0.5, (double)(remotePortal.pos.func_177956_o() + 1), (double)remotePortal.pos.func_177952_p() + 0.5) : new Vec3d((double)remotePortal.pos.func_177958_n() + 0.5, (double)(remotePortal.pos.func_177956_o() + 1), this.d(remotePortal.pos.func_177952_p()) + 0.5);
        this.queueTeleport(player, yaw, transportTo);
    }

    private double d(int x) {
        return x;
    }

    private void queueTeleport(final EntityPlayerMP player, final float yaw, final Vec3d transportTo) {
        Teletory.runQueue.put(new Runnable(){

            @Override
            public void run() {
                if (!player.field_71135_a.func_147362_b().func_150724_d() || player.func_70608_bn()) {
                    return;
                }
                player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                TeleToroUtil.setInvulnerableDimensionChange(player, true);
                player.field_71135_a.func_147364_a(transportTo.field_72450_a, transportTo.field_72448_b, transportTo.field_72449_c, yaw, player.field_70125_A);
                player.field_70159_w = 0.0;
                player.field_70181_x = 0.0;
                player.field_70179_y = 0.0;
                TeleToroUtil.setInvulnerableDimensionChange(player, false);
                player.field_70170_p.func_184148_a((EntityPlayer)null, transportTo.field_72450_a, transportTo.field_72448_b, transportTo.field_72449_c, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                BlockLinkedTeletoryPortal.this.hurtPlayer((EntityLivingBase)player, transportTo);
            }
        }, 1);
    }

    private void hurtPlayer(EntityLivingBase entity, Vec3d transportTo) {
        if (Teletory.isWearingEnderBoots(entity)) {
            Teletory.damageEnderBoots(entity);
            return;
        }
        entity.field_70143_R = 0.0f;
        entity.func_70097_a(DamageSource.field_76379_h, 4.0f);
        if (entity.field_70170_p.field_73012_v.nextFloat() < 0.05f && entity.field_70170_p.func_82736_K().func_82766_b("doMobSpawning")) {
            EntityEndermite entityendermite = new EntityEndermite(entity.field_70170_p);
            entityendermite.func_175496_a(true);
            System.out.println("spawn at " + transportTo.field_72450_a + " " + transportTo.field_72448_b + " " + transportTo.field_72449_c);
            entityendermite.func_70012_b(transportTo.field_72450_a, transportTo.field_72448_b, transportTo.field_72449_c, entity.field_70177_z, entity.field_70125_A);
            entity.field_70170_p.func_72838_d((Entity)entityendermite);
        }
    }

    private void breakPortal(EntityPlayerMP player, BlockPos thisPortalLocation) {
        player.field_70170_p.func_175656_a(thisPortalLocation, Blocks.field_150350_a.func_176223_P());
        player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187835_fT, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    private TileEntityLinkedTeletoryPortal getTileEntity(EntityPlayerMP player, BlockPos pos) {
        try {
            return (TileEntityLinkedTeletoryPortal)player.field_70170_p.func_175625_s(pos);
        }
        catch (Exception e) {
            return null;
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Blocks.field_150350_a);
    }

    static {
        REGISTRY_NAME = new ResourceLocation("teletoro", NAME);
    }

    public static class Size
    extends BlockAbstractPortal.Size {
        public Size(World world, BlockPos pos, EnumFacing.Axis axis) {
            super(world, pos, axis);
        }

        @Override
        public Block getFrameBlock() {
            return BlockEnder.INSTANCE;
        }

        @Override
        public BlockAbstractPortal getPortalBlock() {
            return INSTANCE;
        }
    }
}

