/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.teletoro.item;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.torocraft.teletoro.Teletory;
import net.torocraft.teletoro.blocks.BlockAbstractPortal;
import net.torocraft.teletoro.blocks.BlockLinkedTeletoryPortal;
import net.torocraft.teletoro.blocks.BlockTeletoryPortal;
import net.torocraft.teletoro.blocks.TileEntityLinkedTeletoryPortal;

@Mod.EventBusSubscriber
public class ItemTeletoryPortalLinker
extends Item {
    public static ItemTeletoryPortalLinker INSTANCE;
    public static final String NAME = "teletory_portal_linker";
    public static ModelResourceLocation model;
    public static ModelResourceLocation modelOn;
    public static final SizerFactory STANDARD_SIZER;
    public static final SizerFactory LINKED_SIZER;

    @SubscribeEvent
    public static void init(RegistryEvent.Register<Item> event) {
        INSTANCE = new ItemTeletoryPortalLinker();
        INSTANCE.setRegistryName(new ResourceLocation("teletoro", NAME.toLowerCase()));
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE);
    }

    public static boolean isActive(ItemStack stack) {
        PortalLinkerOrigin remoteInfo = ItemTeletoryPortalLinker.getLinkOrigin(stack);
        return remoteInfo != null && remoteInfo.pos != null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRendersForLinkerStatic() {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)INSTANCE, 0, model);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRendersForLinker2() {
        ModelBakery.registerItemVariants((Item)INSTANCE, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)INSTANCE, (ItemMeshDefinition)MeshDefinitionFix.create(stack -> {
            if (ItemTeletoryPortalLinker.isActive(stack)) {
                return modelOn;
            }
            return model;
        }));
        ModelLoader.registerItemVariants((Item)INSTANCE, (ResourceLocation[])new ModelResourceLocation[]{model, modelOn});
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRendersForLinker() {
        ModelLoader.setCustomMeshDefinition((Item)INSTANCE, stack -> {
            if (ItemTeletoryPortalLinker.isActive(stack)) {
                return modelOn;
            }
            return model;
        });
        ModelLoader.registerItemVariants((Item)INSTANCE, (ResourceLocation[])new ModelResourceLocation[]{model, modelOn});
    }

    public ItemTeletoryPortalLinker() {
        this.func_77655_b(NAME);
        this.field_77777_bU = 1;
        this.func_77656_e(2);
        this.func_77637_a(CreativeTabs.field_78026_f);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == BlockTeletoryPortal.INSTANCE) {
            this.onItemUsedOnPortalBlock(player, world, pos, player.func_184586_b(hand));
        }
        return EnumActionResult.PASS;
    }

    private void onItemUsedOnPortalBlock(EntityPlayer player, World world, BlockPos pos, ItemStack stack) {
        if (world.field_72995_K || player.field_71093_bK != 0) {
            return;
        }
        if (stack == null || stack.func_77973_b() != INSTANCE) {
            return;
        }
        ControlBlockLocation thisPortal = ItemTeletoryPortalLinker.findControllerBlock(world, pos, STANDARD_SIZER);
        if (thisPortal == null || thisPortal.pos == null) {
            return;
        }
        PortalLinkerOrigin remoteInfo = ItemTeletoryPortalLinker.getLinkOrigin(stack);
        if (remoteInfo == null || remoteInfo.pos == null) {
            this.setOriginPortal(player, stack, thisPortal);
        } else {
            this.linkPortalWithOrigin(player, world, stack, thisPortal, remoteInfo);
        }
    }

    private void linkPortalWithOrigin(EntityPlayer player, World world, ItemStack stack, ControlBlockLocation thisPortal, PortalLinkerOrigin remoteInfo) {
        ControlBlockLocation remotePortal = ItemTeletoryPortalLinker.findControllerBlock(world, remoteInfo.pos, STANDARD_SIZER);
        stack.func_77983_a("origin", (NBTBase)new NBTTagLong(0L));
        stack.func_77983_a("dimid", (NBTBase)new NBTTagInt(0));
        if (remotePortal == null) {
            return;
        }
        this.linkPortalTo(world, thisPortal, remotePortal, remoteInfo.dimId, remoteInfo.side);
        this.linkPortalTo(world, remotePortal, thisPortal, player.field_71093_bK, this.getSide(player, thisPortal));
        this.playSound(player);
        stack.func_77972_a(1, (EntityLivingBase)player);
    }

    private void setOriginPortal(EntityPlayer player, ItemStack stack, ControlBlockLocation thisPortal) {
        stack.func_77983_a("origin", (NBTBase)new NBTTagLong(thisPortal.pos.func_177986_g()));
        stack.func_77983_a("dimid", (NBTBase)new NBTTagInt(player.field_71093_bK));
        int side = this.getSide(player, thisPortal);
        stack.func_77983_a("side", (NBTBase)new NBTTagInt(side));
        this.playSound(player);
    }

    private void playSound(EntityPlayer player) {
        player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    private int getSide(EntityPlayer player, ControlBlockLocation thisPortal) {
        int side = EnumFacing.Axis.X.equals((Object)thisPortal.axis) ? (player.func_180425_c().func_177952_p() > thisPortal.pos.func_177952_p() ? 1 : 0) : (player.func_180425_c().func_177958_n() > thisPortal.pos.func_177958_n() ? 1 : 0);
        return side;
    }

    private void linkPortalTo(final World world, final ControlBlockLocation from, final ControlBlockLocation to, final int remoteDimId, final int remoteSide) {
        final BlockAbstractPortal.Size size = STANDARD_SIZER.get(world, from.pos, from.axis);
        Teletory.runQueue.put(new Runnable(){

            @Override
            public void run() {
                size.placePortalBlocks(BlockLinkedTeletoryPortal.INSTANCE);
                TileEntityLinkedTeletoryPortal te = new TileEntityLinkedTeletoryPortal();
                te.setDimId(remoteDimId);
                te.setDestination(to.pos);
                te.setSide(remoteSide);
                world.func_175690_a(from.pos, (TileEntity)te);
            }
        }, 0);
    }

    private static PortalLinkerOrigin getLinkOrigin(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        long serializedPos = stack.func_77978_p().func_74763_f("origin");
        if (serializedPos == 0L) {
            return null;
        }
        PortalLinkerOrigin o = new PortalLinkerOrigin();
        o.dimId = stack.func_77978_p().func_74762_e("dimid");
        o.pos = BlockPos.func_177969_a((long)serializedPos);
        o.side = stack.func_77978_p().func_74762_e("side");
        return o;
    }

    public static ControlBlockLocation findControllerBlock(World world, BlockPos pos, SizerFactory sizerFactory) {
        BlockAbstractPortal.Size size = sizerFactory.get(world, pos, EnumFacing.Axis.X);
        ControlBlockLocation loc = new ControlBlockLocation();
        if (size.isValid()) {
            loc.pos = size.getBottomLeft();
            loc.axis = EnumFacing.Axis.X;
            return loc;
        }
        size = sizerFactory.get(world, pos, EnumFacing.Axis.Z);
        if (size.isValid()) {
            loc.pos = size.getBottomLeft();
            loc.axis = EnumFacing.Axis.Z;
            return loc;
        }
        return null;
    }

    static {
        model = new ModelResourceLocation("teletoro:teletory_portal_linker", "inventory");
        modelOn = new ModelResourceLocation("teletoro:teletory_portal_linker_on", "inventory");
        STANDARD_SIZER = new SizerFactory(){

            @Override
            public BlockAbstractPortal.Size get(World world, BlockPos pos, EnumFacing.Axis axis) {
                return new BlockTeletoryPortal.Size(world, pos, axis);
            }
        };
        LINKED_SIZER = new SizerFactory(){

            @Override
            public BlockAbstractPortal.Size get(World world, BlockPos pos, EnumFacing.Axis axis) {
                return new BlockLinkedTeletoryPortal.Size(world, pos, axis);
            }
        };
    }

    public static class PortalLinkerOrigin {
        public BlockPos pos;
        public int dimId;
        public int side;
    }

    public static class ControlBlockLocation {
        public EnumFacing.Axis axis;
        public BlockPos pos;
    }

    public static interface SizerFactory {
        public BlockAbstractPortal.Size get(World var1, BlockPos var2, EnumFacing.Axis var3);
    }

    static interface MeshDefinitionFix
    extends ItemMeshDefinition {
        public ModelResourceLocation getLocation(ItemStack var1);

        public static ItemMeshDefinition create(MeshDefinitionFix lambda) {
            return lambda;
        }

        default public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.getLocation(stack);
        }
    }
}

