/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.teletoro.teleporter;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;

public class FallFromTeletoryTeleporter
extends Teleporter {
    protected final WorldServer field_85192_a;
    protected final Random field_77187_a;

    public FallFromTeletoryTeleporter(WorldServer worldIn) {
        super(worldIn);
        this.field_85192_a = worldIn;
        this.field_77187_a = new Random(worldIn.func_72905_C());
    }

    public void func_180266_a(Entity entityIn, float rotationYaw) {
        this.func_180620_b(entityIn, rotationYaw);
    }

    public boolean func_180620_b(Entity entity, float rotationYaw) {
        PortalSearchState search = new PortalSearchState(entity, this.field_85192_a);
        return this.fallIntoOverWorld(entity, rotationYaw, search);
    }

    protected boolean fallIntoOverWorld(Entity entity, float rotationYaw, PortalSearchState search) {
        BlockPos placement = this.findTopOfWorld(search);
        double x = (double)placement.func_177958_n() + 0.5;
        double y = placement.func_177956_o() + 14 + this.field_77187_a.nextInt(4);
        double z = (double)placement.func_177952_p() + 0.5;
        double speed = 10.0;
        double xVel = speed * Math.sin(rotationYaw);
        double zVel = speed * Math.cos(rotationYaw);
        entity.field_70159_w = xVel;
        entity.field_70179_y = zVel;
        entity.field_70181_x = 0.0;
        entity.field_70143_R = 0.0f;
        entity.field_70133_I = true;
        entity.func_70012_b(x, y, z, rotationYaw, -5.0f);
        return true;
    }

    protected BlockPos findTopOfWorld(PortalSearchState search) {
        int xSearch = MathHelper.func_76128_c((double)search.xEntity);
        int zSearch = MathHelper.func_76128_c((double)search.zEntity);
        BlockPos searchPos = new BlockPos(xSearch, this.field_85192_a.func_72940_L() - 1, zSearch);
        while (searchPos.func_177956_o() >= 0) {
            if (!this.field_85192_a.func_175623_d(searchPos)) {
                return searchPos;
            }
            searchPos = searchPos.func_177977_b();
        }
        return searchPos;
    }

    public boolean func_85188_a(Entity e) {
        return true;
    }

    public static class PortalSearchState {
        public double xEntity;
        public double yEntity;
        public double zEntity;

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("xEntity[").append(this.xEntity).append("] ");
            s.append("yEntity[").append(this.yEntity).append("] ");
            s.append("zEntity[").append(this.zEntity).append("] ");
            return s.toString();
        }

        public PortalSearchState(Entity entity, WorldServer world) {
            if (entity.field_71093_bK == 16) {
                this.xEntity = entity.field_70165_t / 64.0;
                this.yEntity = entity.field_70163_u;
                this.zEntity = entity.field_70161_v / 64.0;
            } else {
                this.xEntity = entity.field_70165_t * 64.0;
                this.yEntity = entity.field_70163_u;
                this.zEntity = entity.field_70161_v * 64.0;
            }
        }
    }
}

