/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.teletoro.teleporter;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.torocraft.teletoro.blocks.BlockEnder;
import net.torocraft.teletoro.blocks.BlockTeletoryPortal;
import net.torocraft.teletoro.item.ItemTeletoryPortalLinker;

public class TeletoryTeleporter
extends Teleporter {
    public static final int TRAVEL_FACTOR = 64;
    private static final int PORTAL_SEARCH_RADIUS = 200;
    private final WorldServer world;
    private final Random random;
    private final Long2ObjectMap<Teleporter.PortalPosition> destinationCoordinateCache = new Long2ObjectOpenHashMap(4096);

    public TeletoryTeleporter(WorldServer worldIn) {
        super(worldIn);
        this.world = worldIn;
        this.random = new Random(worldIn.func_72905_C());
    }

    public void func_180266_a(Entity entityIn, float rotationYaw) {
        if (!this.func_180620_b(entityIn, rotationYaw)) {
            this.func_85188_a(entityIn);
            this.func_180620_b(entityIn, rotationYaw);
        }
    }

    public boolean func_180620_b(Entity entity, float rotationYaw) {
        PortalSearchState state = new PortalSearchState(entity, this.world);
        if (this.portalIsCached(state.longXZPair, entity)) {
            this.readCachedPortal(state);
        } else {
            this.searchForNearbyPortals(state);
        }
        if (this.noPortalFound(state.distance)) {
            return false;
        }
        this.handleFoundPortal(entity, rotationYaw, state);
        return true;
    }

    private void readCachedPortal(PortalSearchState search) {
        Teleporter.PortalPosition portalposition = (Teleporter.PortalPosition)this.destinationCoordinateCache.get(search.longXZPair);
        search.distance = 0.0;
        search.portalPos = portalposition;
        portalposition.field_85087_d = this.world.func_82737_E();
        search.notCached = false;
    }

    private void searchForNearbyPortals(PortalSearchState search) {
        BlockPos entityPos = new BlockPos(search.xSearch, this.world.func_72940_L() - 1, search.zSearch);
        int searchRadius = 200;
        if (this.world.field_73011_w.getDimension() == 16) {
            searchRadius = 4;
        }
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int z = -searchRadius; z <= searchRadius; ++z) {
                BlockPos searchPos = entityPos.func_177982_a(x, 0, z - 2);
                while (searchPos.func_177956_o() >= 0) {
                    BlockPos nextSearch = searchPos.func_177977_b();
                    this.searchForPortalAtBlock(search, entityPos, nextSearch, searchPos);
                    searchPos = nextSearch;
                }
            }
        }
    }

    protected void searchForPortalAtBlock(PortalSearchState search, BlockPos entityPos, BlockPos nextSearch, BlockPos searchPos) {
        if (!this.isPortal(searchPos)) {
            return;
        }
        while (this.world.func_180495_p(nextSearch = searchPos.func_177977_b()).func_177230_c() == BlockTeletoryPortal.INSTANCE) {
            searchPos = nextSearch;
        }
        double distanceToFoundPortal = searchPos.func_177951_i((Vec3i)entityPos);
        if (this.noPortalFound(search.distance) || distanceToFoundPortal < search.distance) {
            search.distance = distanceToFoundPortal;
            search.portalPos = searchPos;
        }
    }

    private boolean noPortalFound(double distance) {
        return distance < 0.0;
    }

    private void handleFoundPortal(Entity entity, float rotationYaw, PortalSearchState search) {
        this.cachePortalLocation(search);
        double x = (double)search.portalPos.func_177958_n() + 0.5;
        double y = (double)search.portalPos.func_177956_o() + 0.5;
        double z = (double)search.portalPos.func_177952_p() + 0.5;
        entity.field_70179_y = 0.0;
        entity.field_70181_x = 0.0;
        entity.field_70159_w = 0.0;
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71135_a.func_147364_a(x, y, z, entity.field_70177_z, entity.field_70125_A);
        }
        entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
        entity.func_70634_a(x, y, z);
    }

    private void cachePortalLocation(PortalSearchState search) {
        if (search.notCached) {
            this.destinationCoordinateCache.put(search.longXZPair, (Object)new Teleporter.PortalPosition((Teleporter)this, search.portalPos, this.world.func_82737_E()));
        }
    }

    private boolean isPortal(BlockPos blockpos) {
        return this.world.func_180495_p(blockpos).func_177230_c() == BlockTeletoryPortal.INSTANCE;
    }

    private boolean portalIsCached(long longIJPair, Entity entity) {
        boolean found;
        boolean cached = this.destinationCoordinateCache.containsKey((Object)longIJPair);
        if (!cached) {
            return false;
        }
        PortalSearchState state = new PortalSearchState(entity, this.world);
        this.readCachedPortal(state);
        if (state.portalPos == null) {
            this.destinationCoordinateCache.remove(longIJPair);
            return false;
        }
        ItemTeletoryPortalLinker.ControlBlockLocation loc = ItemTeletoryPortalLinker.findControllerBlock((World)this.world, state.portalPos, ItemTeletoryPortalLinker.STANDARD_SIZER);
        boolean bl = found = loc != null && loc.pos != null;
        if (!found) {
            this.destinationCoordinateCache.remove(longIJPair);
        }
        return found;
    }

    public boolean func_85188_a(Entity e) {
        if (e.field_71093_bK == 16) {
            return this.makePortalOnPlatform(e);
        }
        return this.makePortalOnExistingGround(e);
    }

    public boolean makePortalOnPlatform(Entity e) {
        PortalSearchState search = new PortalSearchState(e, this.world);
        int x = search.xSearch;
        int y = 13;
        int z = search.zSearch;
        this.buildPortalFloor(x, y, z);
        this.placePortalBlocks(z, x, y, 1, 0);
        return true;
    }

    public boolean makePortalOnExistingGround(Entity e) {
        double d4;
        double d3;
        int i5;
        int l4;
        int k4;
        int j4;
        int i4;
        int l3;
        int k3;
        int j3;
        int i3;
        double d2;
        int zPos;
        double d1;
        int i2;
        PortalSearchState search = new PortalSearchState(e, this.world);
        int b0 = 16;
        double d0 = -1.0;
        int i = search.xSearch;
        int j = MathHelper.func_76128_c((double)e.field_70163_u);
        int k = search.zSearch;
        int l = i;
        int i1 = j;
        int j1 = k;
        int k1 = 0;
        int l1 = this.random.nextInt(4);
        for (i2 = i - b0; i2 <= i + b0; ++i2) {
            d1 = (double)i2 + 0.5 - search.xEntity;
            for (zPos = k - b0; zPos <= k + b0; ++zPos) {
                d2 = (double)zPos + 0.5 - search.zEntity;
                block2: for (i3 = this.world.func_72940_L() - 1; i3 >= 0; --i3) {
                    if (!this.world.func_175623_d(new BlockPos(i2, i3, zPos))) continue;
                    while (i3 > 0 && this.world.func_175623_d(new BlockPos(i2, i3 - 1, zPos))) {
                        --i3;
                    }
                    for (j3 = l1; j3 < l1 + 4; ++j3) {
                        k3 = j3 % 2;
                        l3 = 1 - k3;
                        if (j3 % 4 >= 2) {
                            k3 = -k3;
                            l3 = -l3;
                        }
                        for (i4 = 0; i4 < 3; ++i4) {
                            for (j4 = 0; j4 < 4; ++j4) {
                                for (k4 = -1; k4 < 4; ++k4) {
                                    l4 = i2 + (j4 - 1) * k3 + i4 * l3;
                                    i5 = i3 + k4;
                                    int j5 = zPos + (j4 - 1) * l3 - i4 * k3;
                                    Block tmp = this.world.func_180495_p(new BlockPos(l4, i5, j5)).func_177230_c();
                                    if (k4 < 0 && !tmp.func_149688_o(tmp.func_176223_P()).func_76220_a() || k4 >= 0 && !this.world.func_175623_d(new BlockPos(l4, i5, j5))) continue block2;
                                }
                            }
                        }
                        d3 = (double)i3 + 0.5 - search.yEntity;
                        d4 = d1 * d1 + d3 * d3 + d2 * d2;
                        if (!this.noPortalFound(d0) && !(d4 < d0)) continue;
                        d0 = d4;
                        l = i2;
                        i1 = i3;
                        j1 = zPos;
                        k1 = j3 % 4;
                    }
                }
            }
        }
        if (this.noPortalFound(d0)) {
            for (i2 = i - b0; i2 <= i + b0; ++i2) {
                d1 = (double)i2 + 0.5 - search.xEntity;
                for (zPos = k - b0; zPos <= k + b0; ++zPos) {
                    d2 = (double)zPos + 0.5 - search.zEntity;
                    block10: for (i3 = this.world.func_72940_L() - 1; i3 >= 0; --i3) {
                        if (!this.world.func_175623_d(new BlockPos(i2, i3, zPos))) continue;
                        while (i3 > 0 && this.world.func_175623_d(new BlockPos(i2, i3 - 1, zPos))) {
                            --i3;
                        }
                        for (j3 = l1; j3 < l1 + 2; ++j3) {
                            k3 = j3 % 2;
                            l3 = 1 - k3;
                            for (i4 = 0; i4 < 4; ++i4) {
                                for (j4 = -1; j4 < 4; ++j4) {
                                    k4 = i2 + (i4 - 1) * k3;
                                    l4 = i3 + j4;
                                    i5 = zPos + (i4 - 1) * l3;
                                    Block tmpb = this.world.func_180495_p(new BlockPos(k4, l4, i5)).func_177230_c();
                                    if (j4 < 0 && !tmpb.func_149688_o(tmpb.func_176223_P()).func_76220_a() || j4 >= 0 && !this.world.func_175623_d(new BlockPos(k4, l4, i5))) continue block10;
                                }
                            }
                            d3 = (double)i3 + 0.5 - search.yEntity;
                            d4 = d1 * d1 + d3 * d3 + d2 * d2;
                            if (!this.noPortalFound(d0) && !(d4 < d0)) continue;
                            d0 = d4;
                            l = i2;
                            i1 = i3;
                            j1 = zPos;
                            k1 = j3 % 2;
                        }
                    }
                }
            }
        }
        int xPos = l;
        int yPos = i1;
        zPos = j1;
        int l5 = k1 % 2;
        int l2 = 1 - l5;
        if (k1 % 4 >= 2) {
            l5 = -l5;
            l2 = -l2;
        }
        if (this.noPortalFound(d0)) {
            yPos = i1 = MathHelper.func_76125_a((int)i1, (int)70, (int)(this.world.func_72940_L() - 10));
            for (i3 = -1; i3 <= 1; ++i3) {
                for (j3 = 1; j3 < 3; ++j3) {
                    for (k3 = -1; k3 < 3; ++k3) {
                        l3 = xPos + (j3 - 1) * l5 + i3 * l2;
                        i4 = yPos + k3;
                        j4 = zPos + (j3 - 1) * l2 - i3 * l5;
                        boolean flag = k3 < 0;
                        this.world.func_175656_a(new BlockPos(l3, i4, j4), flag ? BlockEnder.INSTANCE.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
        this.placePortalBlocks(zPos, xPos, yPos, l5, l2);
        return true;
    }

    private void buildPortalFloor(int x, int y, int z) {
        int y1 = y - 1;
        for (int x1 = -1; x1 < 1; ++x1) {
            for (int z1 = -1; z1 < 2; ++z1) {
                BlockPos pos = new BlockPos(x1 + x + 1, y1, z1 + z);
                if (this.world.isSideSolid(pos, EnumFacing.UP)) continue;
                this.world.func_175656_a(pos, Blocks.field_150377_bs.func_176223_P());
            }
        }
    }

    private void placePortalBlocks(int zIn, int xIn, int yIn, int l5, int l2) {
        IBlockState iblockstate = BlockTeletoryPortal.INSTANCE.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)(l5 == 0 ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
        for (int j3 = 0; j3 < 4; ++j3) {
            int z;
            int y;
            int x;
            int l3;
            int k3;
            for (k3 = 0; k3 < 4; ++k3) {
                for (l3 = -1; l3 < 4; ++l3) {
                    x = xIn + (k3 - 1) * l5;
                    y = yIn + l3;
                    z = zIn + (k3 - 1) * l2;
                    boolean flag1 = k3 == 0 || k3 == 3 || l3 == -1 || l3 == 3;
                    this.world.func_180501_a(new BlockPos(x, y, z), flag1 ? BlockEnder.INSTANCE.func_176223_P() : iblockstate, 2);
                }
            }
            for (k3 = 0; k3 < 4; ++k3) {
                for (l3 = -1; l3 < 4; ++l3) {
                    x = xIn + (k3 - 1) * l5;
                    y = yIn + l3;
                    z = zIn + (k3 - 1) * l2;
                    this.world.func_175685_c(new BlockPos(x, y, z), this.world.func_180495_p(new BlockPos(x, y, z)).func_177230_c(), false);
                }
            }
        }
    }

    public static class PortalSearchState {
        public double distance = -1.0;
        public BlockPos portalPos = BlockPos.field_177992_a;
        public boolean notCached = true;
        public double xEntity;
        public double yEntity;
        public double zEntity;
        public int xSearch;
        public int zSearch;
        public long longXZPair;

        public PortalSearchState(Entity entity, WorldServer world) {
            if (world.field_73011_w.getDimension() == 16) {
                this.longXZPair = ChunkPos.func_77272_a((int)MathHelper.func_76128_c((double)entity.field_70165_t), (int)MathHelper.func_76128_c((double)entity.field_70161_v));
                this.xEntity = entity.field_70165_t / 64.0;
                this.yEntity = entity.field_70163_u;
                this.zEntity = entity.field_70161_v / 64.0;
                this.xSearch = MathHelper.func_76128_c((double)this.xEntity);
                this.zSearch = MathHelper.func_76128_c((double)this.zEntity);
            } else {
                this.xEntity = entity.field_70165_t * 64.0;
                this.yEntity = entity.field_70163_u;
                this.zEntity = entity.field_70161_v * 64.0;
                this.xSearch = MathHelper.func_76128_c((double)this.xEntity);
                this.zSearch = MathHelper.func_76128_c((double)this.zEntity);
                this.longXZPair = ChunkPos.func_77272_a((int)this.xSearch, (int)this.zSearch);
            }
        }
    }
}

