/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.teletoro.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraftforge.event.ForgeEventFactory;
import net.torocraft.teletoro.blocks.BlockEnderOre;

public class TeletoryChunkProvider
implements IChunkGenerator {
    private final World world;
    private final Random random;
    private final NoiseGeneratorOctaves noise1;
    private double[] noiseBuffer;
    private final int xSize = 16;
    private final int ySize = 5;
    private final int zSize = 16;
    private final int xScale = 5;
    private final int yScale = 6;
    private final int zScale = 15;
    private final int yOffset = 0;
    private final IBlockState base;
    private final IBlockState dirt;
    private final IBlockState ore;
    private final IBlockState bush;
    public static final int surfaceHeight = 8;
    public static final int surfaceThickness = 5;
    public static final int dirtHeight = 11;
    private IBlockState block;

    public TeletoryChunkProvider(World worldIn, long seed) {
        this.world = worldIn;
        this.random = new Random(seed);
        this.noise1 = new NoiseGeneratorOctaves(this.random, 8);
        this.base = Blocks.field_150377_bs.func_176223_P();
        this.dirt = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT);
        this.ore = BlockEnderOre.INSTANCE.func_176223_P();
        this.bush = Blocks.field_150330_I.func_176223_P();
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        ChunkPrimer chunkprimer = new ChunkPrimer();
        int xOffset = chunkX * 16;
        int zOffset = chunkZ * 16;
        this.noiseBuffer = this.noise1.func_76304_a(this.noiseBuffer, xOffset, 0, zOffset, 16, 5, 16, 5.0, 6.0, 15.0);
        this.drawNoise(chunkprimer);
        return this.createChunk(chunkX, chunkZ, chunkprimer);
    }

    private void drawNoise(ChunkPrimer chunkprimer) {
        int pointer = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 5; ++y) {
                    if (this.noiseBuffer[pointer] > 70.0 - (double)(8 * (5 - y))) {
                        this.setBlock(chunkprimer, x, y + 8, z);
                    }
                    ++pointer;
                }
            }
        }
    }

    protected void setBlock(ChunkPrimer chunkprimer, int x, int y, int z) {
        this.block = y >= 11 ? (this.isAir(chunkprimer, x, y - 1, z) ? this.base : this.dirt) : (this.random.nextInt(100) > 85 ? this.ore : this.base);
        chunkprimer.func_177855_a(x, y, z, this.block);
        if (this.block == this.dirt && this.random.nextInt(100) > 80) {
            chunkprimer.func_177855_a(x, y + 1, z, this.bush);
        }
    }

    protected boolean isAir(ChunkPrimer chunkprimer, int x, int y, int z) {
        return chunkprimer.func_177856_a(x, y, z) == null || chunkprimer.func_177856_a(x, y, z) == Blocks.field_150350_a.func_176223_P();
    }

    private Chunk createChunk(int chunkX, int chunkZ, ChunkPrimer chunkprimer) {
        Chunk chunk = new Chunk(this.world, chunkprimer, chunkX, chunkZ);
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        this.setChunkSeed(chunkX, chunkZ);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)false);
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)false);
        BlockFalling.field_149832_M = false;
    }

    protected void setChunkSeed(int chunkX, int chunkZ) {
        this.random.setSeed(this.world.func_72905_C());
        long k = this.random.nextLong() / 2L * 2L + 1L;
        long l = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)chunkX * k + (long)chunkZ * l ^ this.world.func_72905_C());
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return new ArrayList<Biome.SpawnListEntry>(0);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

