/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.net;

import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbutilities.data.Leaderboard;
import com.feed_the_beast.ftbutilities.data.LeaderboardValue;
import com.feed_the_beast.ftbutilities.gui.GuiLeaderboard;
import com.feed_the_beast.ftbutilities.net.FTBUtilitiesNetHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageLeaderboardResponse
extends MessageToClient {
    private static final DataOut.Serializer<LeaderboardValue> VALUE_SERIALIZER = (data, object) -> {
        data.writeString(object.username);
        data.writeTextComponent(object.value);
        data.writeByte(object.color.ordinal());
    };
    private static final DataIn.Deserializer<LeaderboardValue> VALUE_DESERIALIZER = data -> {
        LeaderboardValue value = new LeaderboardValue();
        value.username = data.readString();
        value.value = data.readTextComponent();
        value.color = TextFormatting.values()[data.readUnsignedByte()];
        return value;
    };
    private ITextComponent title;
    private List<LeaderboardValue> values;

    public MessageLeaderboardResponse() {
    }

    public MessageLeaderboardResponse(EntityPlayerMP player, Leaderboard leaderboard) {
        this.title = leaderboard.getTitle();
        this.values = new ArrayList<LeaderboardValue>();
        ForgePlayer p0 = Universe.get().getPlayer((ICommandSender)player);
        ArrayList<ForgePlayer> players = new ArrayList<ForgePlayer>(Universe.get().getPlayers());
        players.sort(leaderboard.getComparator());
        for (int i = 0; i < players.size(); ++i) {
            ForgePlayer p = (ForgePlayer)players.get(i);
            LeaderboardValue value = new LeaderboardValue();
            value.username = p.getDisplayNameString();
            value.value = leaderboard.createValue(p);
            value.color = p == p0 ? TextFormatting.DARK_GREEN : (!leaderboard.hasValidValue(p) ? TextFormatting.DARK_GRAY : (i < 3 ? TextFormatting.GOLD : TextFormatting.RESET));
            this.values.add(value);
        }
    }

    public NetworkWrapper getWrapper() {
        return FTBUtilitiesNetHandler.STATS;
    }

    public void writeData(DataOut data) {
        data.writeTextComponent(this.title);
        data.writeCollection(this.values, VALUE_SERIALIZER);
    }

    public void readData(DataIn data) {
        this.title = data.readTextComponent();
        this.values = new ArrayList<LeaderboardValue>();
        data.readCollection(this.values, VALUE_DESERIALIZER);
    }

    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        new GuiLeaderboard(this.title, this.values).openGui();
    }
}

