/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import java.util.ArrayList;
import java.util.List;
import lumien.randomthings.block.BlockContainerBase;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.container.ContainerCustomWorkbench;
import lumien.randomthings.tileentity.TileEntityCustomWorkbench;
import lumien.randomthings.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCustomWorkbench
extends BlockContainerBase {
    public static final WoodStateProperty WOOD_STATE = new WoodStateProperty();

    public BlockCustomWorkbench() {
        super("customWorkbench", Material.field_151575_d);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityCustomWorkbench te = (TileEntityCustomWorkbench)world.func_175625_s(pos);
        String woodName = te.getWoodMaterial().getRegistryName().toString();
        int meta = te.getWoodMeta();
        ItemStack pickedWorkbench = new ItemStack((Block)this);
        NBTTagCompound compound = new NBTTagCompound();
        pickedWorkbench.func_77982_d(compound);
        compound.func_74778_a("woodName", woodName);
        compound.func_74768_a("woodMeta", meta);
        return pickedWorkbench;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityCustomWorkbench te = (TileEntityCustomWorkbench)worldIn.func_175625_s(pos);
        String woodName = te.getWoodMaterial().getRegistryName().toString();
        int meta = te.getWoodMeta();
        ItemStack droppedWorkbench = new ItemStack((Block)this);
        NBTTagCompound compound = new NBTTagCompound();
        droppedWorkbench.func_77982_d(compound);
        compound.func_74778_a("woodName", woodName);
        compound.func_74768_a("woodMeta", meta);
        WorldUtil.spawnItemStack(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), droppedWorkbench);
        super.func_180663_b(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList list) {
        for (BlockPlanks.EnumType type : BlockPlanks.EnumType.values()) {
            ItemStack workBench = new ItemStack((Block)this);
            NBTTagCompound compound = new NBTTagCompound();
            workBench.func_77982_d(compound);
            compound.func_74778_a("woodName", "minecraft:planks");
            compound.func_74768_a("woodMeta", type.ordinal());
            list.add((Object)workBench);
        }
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityCustomWorkbench();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{WOOD_STATE});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityCustomWorkbench te = (TileEntityCustomWorkbench)worldIn.func_175625_s(pos);
        IExtendedBlockState actualState = (IExtendedBlockState)state;
        if (te != null && te.getWoodState() != null) {
            return actualState.withProperty((IUnlistedProperty)WOOD_STATE, (Object)te.getWoodState());
        }
        return actualState.withProperty((IUnlistedProperty)WOOD_STATE, (Object)Blocks.field_150344_f.func_176223_P());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int meta;
        String woodName;
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            woodName = compound.func_74779_i("woodName");
            meta = compound.func_74762_e("woodMeta");
        } else {
            woodName = "minecraft:planks";
            meta = 0;
        }
        TileEntityCustomWorkbench te = (TileEntityCustomWorkbench)worldIn.func_175625_s(pos);
        Block woodBlock = Block.func_149684_b((String)woodName);
        if (woodBlock == null) {
            woodBlock = Blocks.field_150344_f;
            meta = 0;
        }
        te.setWood(woodBlock, meta);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        playerIn.func_180468_a((IInteractionObject)new InterfaceCraftingTable(worldIn, pos));
        return true;
    }

    public static class InterfaceCraftingTable
    implements IInteractionObject {
        private final World world;
        private final BlockPos position;
        private static final String __OBFID = "CL_00002127";

        public InterfaceCraftingTable(World worldIn, BlockPos pos) {
            this.world = worldIn;
            this.position = pos;
        }

        public String func_70005_c_() {
            return null;
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentTranslation(ModBlocks.customWorkbench.func_149739_a() + ".name", new Object[0]);
        }

        public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
            return new ContainerCustomWorkbench(playerInventory, this.world, this.position);
        }

        public String func_174875_k() {
            return "minecraft:crafting_table";
        }
    }

    private static class WoodStateProperty
    implements IUnlistedProperty<IBlockState> {
        private WoodStateProperty() {
        }

        public String getName() {
            return "woodState";
        }

        public boolean isValid(IBlockState value) {
            return true;
        }

        public Class<IBlockState> getType() {
            return IBlockState.class;
        }

        public String valueToString(IBlockState value) {
            return value.toString();
        }
    }
}

