/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler.spectrelens;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SpectreLensHandler
extends WorldSavedData {
    static final String ID = "rtSpectreLensHandler";
    Map<UUID, LensEntry> lensEntries = new HashMap<UUID, LensEntry>();

    public SpectreLensHandler() {
        this(ID);
    }

    public SpectreLensHandler(String id) {
        super(id);
    }

    public static SpectreLensHandler get(World worldObj) {
        SpectreLensHandler instance = (SpectreLensHandler)worldObj.getPerWorldStorage().func_75742_a(SpectreLensHandler.class, ID);
        if (instance == null) {
            instance = new SpectreLensHandler();
            worldObj.getPerWorldStorage().func_75745_a(ID, (WorldSavedData)instance);
        }
        return instance;
    }

    public void removeLens(UUID uuid) {
        this.lensEntries.remove(uuid);
    }

    public void addLens(UUID uuid, int levels, int primary, int secondary) {
        if (this.lensEntries.containsKey(uuid)) {
            LensEntry entry = this.lensEntries.get(uuid);
            entry.setPrimary(primary);
            entry.setSecondary(secondary);
        } else {
            LensEntry entry = new LensEntry(levels, primary, secondary);
            this.lensEntries.put(uuid, entry);
        }
    }

    public void tick(World worldObj) {
        if (worldObj.func_82737_E() % 60L == 0L) {
            for (UUID uuid : this.lensEntries.keySet()) {
                Potion potion;
                int amplifier;
                EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(uuid);
                if (player == null || player.field_70170_p != worldObj) continue;
                LensEntry entry = this.lensEntries.get(uuid);
                int n = amplifier = entry.primary == entry.secondary ? 1 : 0;
                if (entry.primary != -1 && (potion = (Potion)Potion.field_188414_b.func_148754_a(entry.primary)) != null) {
                    player.func_70690_d(new PotionEffect(potion, 200, amplifier, true, true));
                }
                if (entry.secondary == -1 || (potion = (Potion)Potion.field_188414_b.func_148754_a(entry.secondary)) == null) continue;
                player.func_70690_d(new PotionEffect(potion, 200, amplifier, true, true));
            }
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("lensEntries", 10);
        this.lensEntries.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            UUID uuid = UUID.fromString(compound.func_74779_i("uuid"));
            LensEntry entry = new LensEntry();
            entry.readFromNBT(compound);
            this.lensEntries.put(uuid, entry);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<UUID, LensEntry> entry : this.lensEntries.entrySet()) {
            NBTTagCompound entryCompound = new NBTTagCompound();
            entry.getValue().writeToNBT(entryCompound);
            entryCompound.func_74778_a("uuid", entry.getKey().toString());
            list.func_74742_a((NBTBase)entryCompound);
        }
        compound.func_74782_a("lensEntries", (NBTBase)list);
        return compound;
    }

    public boolean func_76188_b() {
        return true;
    }

    static class LensEntry {
        int levels;
        int primary;
        int secondary;

        public LensEntry() {
        }

        public LensEntry(int levels, int primary, int secondary) {
            this.levels = levels;
            this.primary = primary;
            this.secondary = secondary;
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.levels = compound.func_74762_e("levels");
            this.primary = compound.func_74762_e("primary");
            this.secondary = compound.func_74762_e("secondary");
        }

        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74768_a("levels", this.levels);
            compound.func_74768_a("primary", this.primary);
            compound.func_74768_a("secondary", this.secondary);
        }

        public int getPrimary() {
            return this.primary;
        }

        public void setPrimary(int primary) {
            this.primary = primary;
        }

        public int getSecondary() {
            return this.secondary;
        }

        public void setSecondary(int secondary) {
            this.secondary = secondary;
        }

        public int getLevels() {
            return this.levels;
        }

        public void setLevels(int levels) {
            this.levels = levels;
        }
    }
}

