/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.UUID;
import lumien.randomthings.tileentity.TileEntityBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class TileEntityPlayerInterface
extends TileEntityBase {
    UUID playerUUID = null;

    public boolean isCurrentlyConnected() {
        return this.getPlayerInventory() != null;
    }

    protected PlayerInventoryWrapper getPlayerInventory() {
        if (this.playerUUID == null) {
            return null;
        }
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.playerUUID);
        return player != null ? new PlayerInventoryWrapper((ContainerPlayer)player.field_71069_bz, player.field_71071_by) : null;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            PlayerInventoryWrapper playerInventory = this.getPlayerInventory();
            if (playerInventory == null) {
                return (T)new EmptyHandler();
            }
            if (facing == EnumFacing.UP) {
                return (T)new RangedWrapper((IItemHandlerModifiable)new InvWrapper((IInventory)playerInventory), 36, 40);
            }
            if (facing == EnumFacing.DOWN) {
                return (T)new RangedWrapper((IItemHandlerModifiable)new InvWrapper((IInventory)playerInventory), 0, 9);
            }
            if (facing == EnumFacing.NORTH) {
                return (T)new RangedWrapper((IItemHandlerModifiable)new InvWrapper((IInventory)playerInventory), 40, 41);
            }
            return (T)new RangedWrapper((IItemHandlerModifiable)new InvWrapper((IInventory)playerInventory), 9, 36);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public void setPlayerUUID(UUID uuid) {
        this.playerUUID = uuid;
        this.func_70296_d();
        this.syncTE();
    }

    @Override
    public void writeDataToNBT(NBTTagCompound nbt, boolean sync) {
        if (this.playerUUID != null) {
            nbt.func_74778_a("player-uuid", this.playerUUID.toString());
        }
    }

    @Override
    public void readDataFromNBT(NBTTagCompound nbt, boolean sync) {
        if (nbt.func_74764_b("player-uuid")) {
            this.playerUUID = UUID.fromString(nbt.func_74779_i("player-uuid"));
        }
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    private class PlayerInventoryWrapper
    implements IInventory {
        ContainerPlayer container;
        InventoryPlayer inventory;

        public PlayerInventoryWrapper(ContainerPlayer container, InventoryPlayer inventory) {
            this.container = container;
            this.inventory = inventory;
        }

        public String func_70005_c_() {
            return this.inventory.func_70005_c_();
        }

        public boolean func_145818_k_() {
            return this.inventory.func_145818_k_();
        }

        public ITextComponent func_145748_c_() {
            return this.inventory.func_145748_c_();
        }

        public int func_70302_i_() {
            return this.inventory.func_70302_i_();
        }

        public boolean func_191420_l() {
            return this.inventory.func_191420_l();
        }

        public ItemStack func_70301_a(int index) {
            return this.inventory.func_70301_a(index);
        }

        public ItemStack func_70298_a(int index, int count) {
            return this.inventory.func_70298_a(index, count);
        }

        public ItemStack func_70304_b(int index) {
            return this.inventory.func_70304_b(index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.inventory.func_70299_a(index, stack);
        }

        public int func_70297_j_() {
            return this.inventory.func_70297_j_();
        }

        public void func_70296_d() {
            this.inventory.func_70296_d();
        }

        public boolean func_70300_a(EntityPlayer player) {
            return this.inventory.func_70300_a(player);
        }

        public void func_174889_b(EntityPlayer player) {
            this.inventory.func_174889_b(player);
        }

        public void func_174886_c(EntityPlayer player) {
            this.inventory.func_174886_c(player);
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return this.container.func_75147_a((IInventory)this.inventory, index).func_75214_a(stack);
        }

        public int func_174887_a_(int id) {
            return this.inventory.func_174887_a_(id);
        }

        public void func_174885_b(int id, int value) {
            this.inventory.func_174885_b(id, value);
        }

        public int func_174890_g() {
            return this.inventory.func_174890_g();
        }

        public void func_174888_l() {
            this.inventory.func_174888_l();
        }
    }
}

