/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves2api.api.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TransitionInventory
extends InventoryBasic {
    public TransitionInventory(int slotCount) {
        super("Temp", false, slotCount);
    }

    public TransitionInventory(NBTTagList tagList) {
        this(TransitionInventory.getMaxSlotInTagList(tagList));
        this.readFromTagList(tagList);
    }

    private static int getMaxSlotInTagList(NBTTagList tagList) {
        int max = -1;
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compound = tagList.func_150305_b(i);
            int val = compound.func_74771_c("Slot") & 0xFF;
            if (val <= max) continue;
            max = val;
        }
        return max + 1;
    }

    public NBTTagList writeToTagList(NBTTagList list) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i).func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        return list;
    }

    public void readFromTagList(NBTTagList list) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            ItemStack stack = new ItemStack(compound);
            this.func_70299_a(compound.func_74771_c("Slot") & 0xFF, stack);
        }
    }

    public List<ItemStack> getListOfNonEmptyItemStacks() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack inSlot = this.func_70301_a(i);
            if (inSlot.func_190926_b()) continue;
            ret.add(inSlot);
        }
        return ret;
    }

    public static List<String> getGuiStringsForItemStack(int number, ItemStack stack) {
        ArrayList<String> ret = new ArrayList<String>();
        if (!stack.func_190926_b()) {
            String name = stack.func_82833_r();
            if (name.length() > 28) {
                name = name.substring(0, 25) + "...";
            }
            ret.add(number + ") " + name + (stack.func_190916_E() > 1 ? " x" + stack.func_190916_E() : ""));
            ret.addAll(EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().map(entry -> "    " + ((Enchantment)entry.getKey()).func_77316_c(((Integer)entry.getValue()).intValue())).collect(Collectors.toList()));
        }
        return ret;
    }

    public static List<String> getGuiStringsForItemStackList(List<ItemStack> items) {
        ArrayList<String> ret = new ArrayList<String>();
        AtomicInteger itemNumber = new AtomicInteger(1);
        items.stream().forEach(stack -> ret.addAll(TransitionInventory.getGuiStringsForItemStack(itemNumber.getAndIncrement(), stack)));
        return ret;
    }

    public ArrayList<String> getListOfItemsInInventoryAsStrings() {
        ArrayList<String> ret = new ArrayList<String>();
        AtomicInteger itemNumber = new AtomicInteger(1);
        this.getListOfNonEmptyItemStacks().stream().forEach(inSlot -> ret.addAll(TransitionInventory.getGuiStringsForItemStack(itemNumber.getAndIncrement(), inSlot)));
        return ret;
    }
}

