/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting;

import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingRequestInfo;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class CraftingRequestInfo
implements ICraftingRequestInfo {
    private static final String NBT_FLUID = "Fluid";
    private static final String NBT_STACK = "Stack";
    private ItemStack item;
    private FluidStack fluid;

    public CraftingRequestInfo(NBTTagCompound tag) throws CraftingTaskReadException {
        if (!tag.func_74767_n(NBT_FLUID)) {
            this.item = StackUtils.deserializeStackFromNbt(tag.func_74775_l(NBT_STACK));
            if (this.item.func_190926_b()) {
                throw new CraftingTaskReadException("Extractor stack is empty");
            }
        } else {
            this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l(NBT_STACK));
            if (this.fluid == null) {
                throw new CraftingTaskReadException("Extractor fluid stack is emty");
            }
        }
    }

    public CraftingRequestInfo(ItemStack item) {
        this.item = item;
    }

    public CraftingRequestInfo(FluidStack fluid) {
        this.fluid = fluid;
    }

    @Override
    @Nullable
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    @Nullable
    public FluidStack getFluid() {
        return this.fluid;
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a(NBT_FLUID, this.fluid != null);
        if (this.fluid != null) {
            tag.func_74782_a(NBT_STACK, (NBTBase)this.fluid.writeToNBT(new NBTTagCompound()));
        } else {
            tag.func_74782_a(NBT_STACK, (NBTBase)StackUtils.serializeStackToNbt(this.item));
        }
        return tag;
    }
}

