/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor;

import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CraftingMonitorElementFluidRender
implements ICraftingMonitorElement {
    private static final int COLOR_PROCESSING = -2494985;
    private static final int COLOR_MISSING = -860450;
    private static final int COLOR_SCHEDULED = -1514038;
    private static final int COLOR_CRAFTING = -5383226;
    public static final String ID = "fluid_render";
    private FluidStack stack;
    private int stored;
    private int missing;
    private int processing;
    private int scheduled;
    private int crafting;

    public CraftingMonitorElementFluidRender(FluidStack stack, int stored, int missing, int processing, int scheduled, int crafting) {
        this.stack = stack;
        this.stored = stored;
        this.missing = missing;
        this.processing = processing;
        this.scheduled = scheduled;
        this.crafting = crafting;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, IElementDrawers drawers) {
        if (this.missing > 0) {
            drawers.getOverlayDrawer().draw(x, y, -860450);
        } else if (this.processing > 0) {
            drawers.getOverlayDrawer().draw(x, y, -2494985);
        } else if (this.scheduled > 0) {
            drawers.getOverlayDrawer().draw(x, y, -1514038);
        } else if (this.crafting > 0) {
            drawers.getOverlayDrawer().draw(x, y, -5383226);
        }
        drawers.getFluidDrawer().draw(x + 4, y + 6, this.stack);
        float scale = drawers.getFontRenderer().func_82883_a() ? 1.0f : 0.5f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        int yy = y + 7;
        if (this.stored > 0) {
            drawers.getStringDrawer().draw(RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy, scale), I18n.func_135052_a((String)"gui.refinedstorage:crafting_monitor.stored", (Object[])new Object[]{API.instance().getQuantityFormatter().formatInBucketForm(this.stored)}));
            yy += 7;
        }
        if (this.missing > 0) {
            drawers.getStringDrawer().draw(RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy, scale), I18n.func_135052_a((String)"gui.refinedstorage:crafting_monitor.missing", (Object[])new Object[]{API.instance().getQuantityFormatter().formatInBucketForm(this.missing)}));
            yy += 7;
        }
        if (this.processing > 0) {
            drawers.getStringDrawer().draw(RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy, scale), I18n.func_135052_a((String)"gui.refinedstorage:crafting_monitor.processing", (Object[])new Object[]{API.instance().getQuantityFormatter().formatInBucketForm(this.processing)}));
            yy += 7;
        }
        if (this.scheduled > 0) {
            drawers.getStringDrawer().draw(RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy, scale), I18n.func_135052_a((String)"gui.refinedstorage:crafting_monitor.scheduled", (Object[])new Object[]{API.instance().getQuantityFormatter().formatInBucketForm(this.scheduled)}));
            yy += 7;
        }
        if (this.crafting > 0) {
            drawers.getStringDrawer().draw(RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy, scale), I18n.func_135052_a((String)"gui.refinedstorage:crafting_monitor.crafting", (Object[])new Object[]{API.instance().getQuantityFormatter().formatInBucketForm(this.crafting)}));
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    @Nullable
    public String getTooltip() {
        return this.stack.getLocalizedName();
    }

    @Override
    public void write(ByteBuf buf) {
        StackUtils.writeFluidStack(buf, this.stack);
        buf.writeInt(this.stored);
        buf.writeInt(this.missing);
        buf.writeInt(this.processing);
        buf.writeInt(this.scheduled);
        buf.writeInt(this.crafting);
    }

    @Override
    public boolean merge(ICraftingMonitorElement element) {
        if (element.getId().equals(this.getId()) && this.elementHashCode() == element.elementHashCode()) {
            this.stored += ((CraftingMonitorElementFluidRender)element).stored;
            this.missing += ((CraftingMonitorElementFluidRender)element).missing;
            this.processing += ((CraftingMonitorElementFluidRender)element).processing;
            this.scheduled += ((CraftingMonitorElementFluidRender)element).scheduled;
            this.crafting += ((CraftingMonitorElementFluidRender)element).crafting;
            return true;
        }
        return false;
    }

    @Override
    public int elementHashCode() {
        return API.instance().getFluidStackHashCode(this.stack);
    }
}

