/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingTask;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.ProcessingState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

class Processing {
    private static final String NBT_PATTERN = "Pattern";
    private static final String NBT_ITEMS_TO_RECEIVE = "ItemsToReceive";
    private static final String NBT_FLUIDS_TO_RECEIVE = "FluidsToReceive";
    private static final String NBT_ITEMS_TO_PUT = "ItemsToPut";
    private static final String NBT_FLUIDS_TO_PUT = "FluidsToPut";
    private static final String NBT_STATE = "State";
    private static final String NBT_ROOT = "Root";
    private ICraftingPattern pattern;
    private IStackList<ItemStack> itemsToReceive;
    private IStackList<FluidStack> fluidsToReceive;
    private IStackList<ItemStack> itemsToPut;
    private IStackList<FluidStack> fluidsToPut;
    private ProcessingState state = ProcessingState.READY;
    private boolean root;

    public Processing(ICraftingPattern pattern, IStackList<ItemStack> itemsToReceive, IStackList<FluidStack> fluidsToReceive, IStackList<ItemStack> itemsToPut, IStackList<FluidStack> fluidsToPut, boolean root) {
        this.pattern = pattern;
        this.itemsToReceive = itemsToReceive;
        this.fluidsToReceive = fluidsToReceive;
        this.itemsToPut = itemsToPut;
        this.fluidsToPut = fluidsToPut;
        this.root = root;
    }

    public Processing(INetwork network, NBTTagCompound tag) throws CraftingTaskReadException {
        this.pattern = CraftingTask.readPatternFromNbt(tag.func_74775_l(NBT_PATTERN), network.world());
        this.itemsToReceive = CraftingTask.readItemStackList(tag.func_150295_c(NBT_ITEMS_TO_RECEIVE, 10));
        this.fluidsToReceive = CraftingTask.readFluidStackList(tag.func_150295_c(NBT_FLUIDS_TO_RECEIVE, 10));
        this.root = tag.func_74767_n(NBT_ROOT);
        this.itemsToPut = CraftingTask.readItemStackList(tag.func_150295_c(NBT_ITEMS_TO_PUT, 10));
        this.fluidsToPut = CraftingTask.readFluidStackList(tag.func_150295_c(NBT_FLUIDS_TO_PUT, 10));
        this.state = ProcessingState.values()[tag.func_74762_e(NBT_STATE)];
    }

    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    public IStackList<ItemStack> getItemsToReceive() {
        return this.itemsToReceive;
    }

    public IStackList<FluidStack> getFluidsToReceive() {
        return this.fluidsToReceive;
    }

    public IStackList<ItemStack> getItemsToPut() {
        return this.itemsToPut;
    }

    public IStackList<FluidStack> getFluidsToPut() {
        return this.fluidsToPut;
    }

    public void setState(ProcessingState state) {
        this.state = state;
    }

    public ProcessingState getState() {
        return this.state;
    }

    public boolean isRoot() {
        return this.root;
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(NBT_PATTERN, (NBTBase)CraftingTask.writePatternToNbt(this.pattern));
        tag.func_74782_a(NBT_ITEMS_TO_RECEIVE, (NBTBase)CraftingTask.writeItemStackList(this.itemsToReceive));
        tag.func_74782_a(NBT_FLUIDS_TO_RECEIVE, (NBTBase)CraftingTask.writeFluidStackList(this.fluidsToReceive));
        tag.func_74757_a(NBT_ROOT, this.root);
        tag.func_74782_a(NBT_ITEMS_TO_PUT, (NBTBase)CraftingTask.writeItemStackList(this.itemsToPut));
        tag.func_74782_a(NBT_FLUIDS_TO_PUT, (NBTBase)CraftingTask.writeFluidStackList(this.fluidsToPut));
        tag.func_74768_a(NBT_STATE, this.state.ordinal());
        return tag;
    }
}

