/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.grid;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridFactory;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridManager;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.gui.ResizableDisplayDummy;
import com.raoulvdberge.refinedstorage.network.MessageGridOpen;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class GridManager
implements IGridManager {
    private List<IGridFactory> factories = new ArrayList<IGridFactory>();

    @Override
    public int add(IGridFactory factory) {
        this.factories.add(factory);
        return this.factories.size() - 1;
    }

    @Override
    @Nullable
    public IGridFactory get(int id) {
        if (id < 0 || id >= this.factories.size()) {
            return null;
        }
        return this.factories.get(id);
    }

    @Override
    public void openGrid(int id, EntityPlayerMP player, BlockPos pos) {
        this.openGrid(id, player, null, pos, -1);
    }

    @Override
    public void openGrid(int id, EntityPlayerMP player, ItemStack stack, int slotId) {
        this.openGrid(id, player, stack, null, slotId);
    }

    private void openGrid(int id, EntityPlayerMP player, @Nullable ItemStack stack, @Nullable BlockPos pos, int slotId) {
        Pair<IGrid, TileEntity> grid = this.createGrid(id, (EntityPlayer)player, stack, pos, slotId);
        if (grid == null) {
            return;
        }
        player.func_71117_bO();
        player.func_71128_l();
        RS.INSTANCE.network.sendTo((IMessage)new MessageGridOpen(player.field_71139_cq, pos, id, stack, slotId), player);
        player.field_71070_bA = new ContainerGrid((IGrid)grid.getLeft(), new ResizableDisplayDummy(), grid.getRight() instanceof TileBase ? (TileBase)((Object)grid.getRight()) : null, (EntityPlayer)player);
        player.field_71070_bA.field_75152_c = player.field_71139_cq;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((EntityPlayer)player, player.field_71070_bA));
    }

    @Override
    @Nullable
    public Pair<IGrid, TileEntity> createGrid(int id, EntityPlayer player, @Nullable ItemStack stack, @Nullable BlockPos pos, int slotId) {
        IGridFactory factory = this.get(id);
        if (factory == null) {
            return null;
        }
        IGrid grid = null;
        TileEntity tile = factory.getRelevantTile(player.field_70170_p, pos);
        switch (factory.getType()) {
            case STACK: {
                grid = factory.createFromStack(player, stack, slotId);
                break;
            }
            case BLOCK: {
                grid = factory.createFromBlock(player, pos);
            }
        }
        if (grid == null) {
            return null;
        }
        return Pair.of((Object)grid, (Object)tile);
    }
}

