/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.control;

import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.control.ScrollbarListener;
import java.util.LinkedList;
import java.util.List;
import org.lwjgl.input.Mouse;

public class Scrollbar {
    private static final int SCROLLER_HEIGHT = 15;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean enabled = false;
    private int offset;
    private int maxOffset;
    private boolean wasClicking = false;
    private boolean isScrolling = false;
    private List<ScrollbarListener> listeners = new LinkedList<ScrollbarListener>();

    public Scrollbar(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void addListener(ScrollbarListener listener) {
        this.listeners.add(listener);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void draw(GuiBase gui) {
        gui.bindTexture("icons.png");
        gui.drawTexture(gui.getGuiLeft() + this.x, gui.getGuiTop() + this.y + (int)Math.min((float)(this.height - 15), (float)this.offset / (float)this.maxOffset * (float)(this.height - 15)), this.isEnabled() ? 232 : 244, 0, 12, 15);
    }

    public void update(GuiBase gui, int mouseX, int mouseY) {
        if (!this.isEnabled()) {
            this.isScrolling = false;
            this.wasClicking = false;
        } else {
            boolean down = Mouse.isButtonDown((int)0);
            if (!this.wasClicking && down && gui.inBounds(this.x, this.y, this.width, this.height, mouseX, mouseY)) {
                this.isScrolling = true;
            }
            if (!down) {
                this.isScrolling = false;
            }
            this.wasClicking = down;
            if (this.isScrolling) {
                this.setOffset((int)Math.floor((float)(mouseY - this.y) / (float)(this.height - 15) * (float)this.maxOffset));
            }
        }
    }

    public void wheel(int delta) {
        if (this.isEnabled()) {
            this.setOffset(this.offset + Math.max(Math.min(-delta, 1), -1));
        }
    }

    public void setMaxOffset(int maxOffset) {
        this.maxOffset = maxOffset;
        if (this.offset > maxOffset) {
            this.offset = Math.max(0, maxOffset);
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        int oldOffset = this.offset;
        if (offset >= 0 && offset <= this.maxOffset) {
            this.offset = offset;
            this.listeners.forEach(l -> l.onOffsetChanged(oldOffset, offset));
        }
    }
}

