/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render.model.baked;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternRenderHandler;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.CraftingPattern;
import com.raoulvdberge.refinedstorage.item.ItemPattern;
import com.raoulvdberge.refinedstorage.render.model.baked.BakedModelDelegate;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelPattern
extends BakedModelDelegate {
    public BakedModelPattern(IBakedModel base) {
        super(base);
    }

    @Override
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = (TRSRTransformation)RenderUtils.getDefaultItemTransforms().get((Object)cameraTransformType);
        return Pair.of((Object)this, (Object)(transform == null ? RenderUtils.EMPTY_MATRIX_TRANSFORM : transform.getMatrix()));
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList((List)this.base.func_188617_f().getOverrides()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                ItemStack outputToRender;
                CraftingPattern pattern = ItemPattern.getPatternFromCache(world, stack);
                if (BakedModelPattern.canDisplayOutput(stack, pattern) && !BakedModelPattern.this.hasBrokenRendering(outputToRender = (ItemStack)pattern.getOutputs().get(0))) {
                    return Minecraft.func_71410_x().func_175599_af().func_184393_a(outputToRender, world, entity);
                }
                return super.handleItemState(originalModel, stack, world, entity);
            }
        };
    }

    private boolean hasBrokenRendering(ItemStack stack) {
        if ("gregtech".equals(stack.func_77973_b().getCreatorModId(stack))) {
            if ("tile.pipe".equals(stack.func_77977_a())) {
                return true;
            }
            if ("machine".equals(stack.func_77973_b().delegate.name().func_110623_a())) {
                return true;
            }
        }
        return false;
    }

    public static boolean canDisplayOutput(ItemStack patternStack, CraftingPattern pattern) {
        if (pattern.isValid() && pattern.getOutputs().size() == 1) {
            for (ICraftingPatternRenderHandler renderHandler : API.instance().getPatternRenderHandlers()) {
                if (!renderHandler.canRenderOutput(patternStack)) continue;
                return true;
            }
        }
        return false;
    }
}

