/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.world.gen.components;

import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.blocks.dungeon.BlockDungeonBase;
import com.gildedgames.the_aether.blocks.dungeon.BlockTreasureChest;
import com.gildedgames.the_aether.blocks.util.EnumCloudType;
import com.gildedgames.the_aether.blocks.util.EnumStoneType;
import com.gildedgames.the_aether.entities.bosses.valkyrie_queen.EntityValkyrieQueen;
import com.gildedgames.the_aether.registry.AetherLootTables;
import com.gildedgames.the_aether.world.gen.AetherGenUtils;
import com.gildedgames.the_aether.world.gen.AetherStructure;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class ComponentSilverDungeon
extends AetherStructure {
    private static final IBlockState LOCKED_ANGELIC_STONE = BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic));
    private static final IBlockState LOCKED_LIGHT_ANGELIC_STONE = BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic));
    private int[][][] rooms = new int[3][3][3];
    private int firstStaircaseZ;
    private int secondStaircaseZ;
    private int finalStaircaseZ;
    private int xTendency;
    private int zTendency;

    public ComponentSilverDungeon() {
    }

    public ComponentSilverDungeon(int chunkX, int chunkZ) {
        this.func_186164_a(EnumFacing.NORTH);
        this.field_74887_e = new StructureBoundingBox(chunkX, 80, chunkZ, chunkX + 100, 220, chunkZ + 100);
    }

    public void setStaircasePosition(int first, int second, int third) {
        this.firstStaircaseZ = first;
        this.secondStaircaseZ = second;
        this.finalStaircaseZ = third;
    }

    public void setCloudTendencies(int xTendency, int zTendency) {
        this.xTendency = xTendency;
        this.zTendency = zTendency;
    }

    @Override
    public boolean generate() {
        int z;
        int y;
        int z2;
        int x;
        this.replaceAir = true;
        this.setStructureOffset(21, 17, 20);
        for (int tries = 0; tries < 100; ++tries) {
            AetherGenUtils.generateClouds(this, EnumCloudType.Cold, false, 10, this.random.nextInt(77), 0, this.random.nextInt(50), this.xTendency, this.zTendency);
        }
        this.setStructureOffset(31, 24, 30);
        this.replaceSolid = true;
        this.setBlocks(BlocksAether.holystone.func_176223_P(), BlocksAether.mossy_holystone.func_176223_P(), 30);
        this.addSolidBox(0, -5, 0, 55, 5, 30);
        for (x = 0; x < 55; x += 4) {
            this.generateColumn(x, 0, 0, 14);
            this.generateColumn(x, 0, 27, 14);
        }
        for (z2 = 0; z2 < 12; z2 += 4) {
            this.generateColumn(0, 0, z2, 14);
            this.generateColumn(52, 0, z2, 14);
        }
        for (z2 = 19; z2 < 30; z2 += 4) {
            this.generateColumn(0, 0, z2, 14);
            this.generateColumn(52, 0, z2, 14);
        }
        this.setBlocks(LOCKED_ANGELIC_STONE, LOCKED_LIGHT_ANGELIC_STONE, 20);
        this.addHollowBox(4, -1, 4, 47, 16, 22);
        this.addPlaneX(11, 0, 5, 15, 20);
        this.addPlaneX(18, 0, 5, 15, 20);
        this.addPlaneX(25, 0, 5, 15, 20);
        this.addPlaneZ(5, 0, 11, 20, 15);
        this.addPlaneZ(5, 0, 18, 20, 15);
        this.setBlocks(LOCKED_ANGELIC_STONE, BlocksAether.dungeon_trap.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic)), 30);
        this.addPlaneY(5, 4, 5, 20, 20);
        this.addPlaneY(5, 9, 5, 20, 20);
        for (y = 0; y < 2; ++y) {
            for (int z3 = 14; z3 < 16; ++z3) {
                this.setBlockWithOffset(4, y, z3, Blocks.field_150350_a.func_176223_P());
            }
        }
        this.setBlocks(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 1);
        this.addSolidBox(0, -4, 14, 1, 4, 2);
        this.addSolidBox(1, -3, 14, 1, 3, 2);
        this.addSolidBox(2, -2, 14, 1, 2, 2);
        this.addSolidBox(3, -1, 14, 1, 1, 2);
        this.setBlocks(LOCKED_ANGELIC_STONE, LOCKED_LIGHT_ANGELIC_STONE, 15);
        for (y = 0; y < 7; ++y) {
            this.addPlaneY(-1, 15 + y, -1 + 2 * y, 57, 32 - 4 * y);
        }
        this.generateStaircase(19, 0, 5 + this.finalStaircaseZ * 7, 10);
        this.rooms[2][0][this.finalStaircaseZ] = 2;
        this.rooms[2][1][this.finalStaircaseZ] = 2;
        this.rooms[2][2][this.finalStaircaseZ] = 1;
        x = 25;
        for (int y2 = 0; y2 < 2; ++y2) {
            for (z = 7 + 7 * this.finalStaircaseZ; z < 9 + 7 * this.finalStaircaseZ; ++z) {
                this.setBlockWithOffset(x, y2, z, Blocks.field_150350_a.func_176223_P());
            }
        }
        this.generateStaircase(12, 0, 5 + this.firstStaircaseZ * 7, 5);
        this.rooms[1][0][this.firstStaircaseZ] = 1;
        this.rooms[1][1][this.firstStaircaseZ] = 1;
        this.generateStaircase(5, 5, 5 + this.secondStaircaseZ * 7, 5);
        this.rooms[0][1][this.secondStaircaseZ] = 1;
        this.rooms[0][2][this.secondStaircaseZ] = 1;
        for (int p = 0; p < 3; ++p) {
            for (int q = 0; q < 3; ++q) {
                block15: for (int r = 0; r < 3; ++r) {
                    int newType;
                    if (p == 0 && q != 0 && this.secondStaircaseZ == r) {
                        if (r == 0) {
                            this.generateDoorX(11 + 7 * p, 5 * q, 7 + 7 * r, 2, 2);
                            this.generateDoorZ(-3 + 7 * r, 7 + 7 * p, 5 * q, 2, 2);
                            continue;
                        }
                        if (r == 1) {
                            this.generateDoorX(11 + 7 * p, 5 * q, 7 + 7 * r, 2, 2);
                            this.generateDoorZ(4 + 7 * r, 7 + 7 * p, 5 * q, 2, 2);
                            this.generateDoorZ(11 + 7 * r, 7 + 7 * p, 5 * q, 2, 2);
                            continue;
                        }
                        if (r != 2) continue;
                        this.generateDoorX(11 + 7 * p, 5 * q, 7 + 7 * r, 2, 2);
                        this.generateDoorZ(4 + 7 * r, 7 + 7 * p, 5 * q, 2, 2);
                        continue;
                    }
                    if (p == 1 && q != 2 && this.firstStaircaseZ == r) {
                        if (this.firstStaircaseZ != this.finalStaircaseZ) {
                            this.generateDoorX(11 + 7 * p, 5 * q, 7 + 7 * r, 2, 2);
                        }
                        if (r == 0) {
                            this.generateDoorZ(11 + 7 * r, 7 + 7 * p, 5 * q, 2, 2);
                            this.generateDoorX(4 + 7 * p, 5 * q, 7 + 7 * r, 2, 2);
                            continue;
                        }
                        if (r == 1) {
                            this.generateDoorZ(4 + 7 * r, 7 + 7 * p, 5 * q, 2, 2);
                            this.generateDoorZ(11 + 7 * r, 7 + 7 * p, 5 * q, 2, 2);
                            this.generateDoorX(4 + 7 * p, 5 * q, 7 + 7 * r, 2, 2);
                            continue;
                        }
                        if (r != 2) continue;
                        this.generateDoorZ(4 + 7 * r, 7 + 7 * p, 5 * q, 2, 2);
                        this.generateDoorX(4 + 7 * p, 5 * q, 7 + 7 * r, 2, 2);
                        continue;
                    }
                    if (p == 2 && this.finalStaircaseZ == r) {
                        if (q == 0) {
                            this.generateDoorX(11 + 7 * p, 5 * q, 7 + 7 * r, 2, 2);
                            continue;
                        }
                        if (q != 2) continue;
                        if (r == 0) {
                            this.generateDoorX(4 + 7 * p, 5 * q, 7 + 7 * r, 2, 2);
                            this.generateDoorZ(11 + 7 * r, 7 + 7 * p, 5 * q, 2, 2);
                            continue;
                        }
                        if (r == 1) {
                            this.generateDoorX(4 + 7 * p, 5 * q, 7 + 7 * r, 2, 2);
                            this.generateDoorZ(4 + 7 * r, 7 + 7 * p, 5 * q, 2, 2);
                            this.generateDoorZ(11 + 7 * r, 7 + 7 * p, 5 * q, 2, 2);
                            continue;
                        }
                        if (r != 2) continue;
                        this.generateDoorX(4 + 7 * p, 5 * q, 7 + 7 * r, 2, 2);
                        this.generateDoorZ(4 + 7 * r, 7 + 7 * p, 5 * q, 2, 2);
                        continue;
                    }
                    int type = this.rooms[p][q][r];
                    if (p + 1 < 3 && (newType = this.rooms[p + 1][q][r]) != 2 && (newType != 1 || type != 1)) {
                        this.rooms[p][q][r] = 3;
                        type = 3;
                        this.generateDoorX(11 + 7 * p, 5 * q, 7 + 7 * r, 2, 2);
                    }
                    if (p - 1 > 0 && (newType = this.rooms[p - 1][q][r]) != 2 && (newType != 1 || type != 1)) {
                        this.rooms[p][q][r] = 4;
                        type = 4;
                        this.generateDoorX(4 + 7 * p, 5 * q, 7 + 7 * r, 2, 2);
                    }
                    if (r + 1 < 3 && (newType = this.rooms[p][q][r + 1]) != 2 && (newType != 1 || type != 1)) {
                        this.rooms[p][q][r] = 5;
                        type = 5;
                        this.generateDoorZ(11 + 7 * r, 7 + 7 * p, 5 * q, 2, 2);
                    }
                    if (r - 1 > 0 && (newType = this.rooms[p][q][r - 1]) != 2 && (newType != 1 || type != 1)) {
                        this.rooms[p][q][r] = 6;
                        type = 6;
                        this.generateDoorZ(4 + 7 * r, 7 + 7 * p, 5 * q, 2, 2);
                    }
                    int roomType = this.random.nextInt(3);
                    if (type < 3) continue;
                    this.setBlockWithOffset(7 + p * 7, -1 + q * 5, 7 + r * 7, BlocksAether.dungeon_trap.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)));
                    switch (roomType) {
                        case 1: {
                            this.addPlaneY(7 + 7 * p, 5 * q, 7 + 7 * r, 2, 2);
                            int u = 7 + 7 * p + this.random.nextInt(2);
                            int v = 7 + 7 * r + this.random.nextInt(2);
                            if (this.getBlockState(u, 5 * q + 1, v).func_185904_a() != Material.field_151579_a) continue block15;
                            this.setBlockWithOffset(u, 5 * q + 1, v, BlocksAether.dungeon_chest.func_176223_P());
                            TileEntity tileEntity = this.getTileEntityFromPosWithOffset(u, 5 * q + 1, v);
                            if (!(tileEntity instanceof TileEntityChest)) continue block15;
                            TileEntityChest chest = (TileEntityChest)tileEntity;
                            chest.func_189404_a(AetherLootTables.silver_dungeon_chest, this.random.nextLong());
                            continue block15;
                        }
                        case 2: {
                            this.addPlaneY(7 + 7 * p, 5 * q, 7 + 7 * r, 2, 2);
                            this.setBlockWithOffset(7 + 7 * p + this.random.nextInt(2), 5 * q + 1, 7 + 7 * r + this.random.nextInt(2), BlocksAether.chest_mimic.func_176223_P());
                            if (!this.random.nextBoolean()) continue block15;
                            this.setBlockWithOffset(7 + 7 * p + this.random.nextInt(2), 5 * q + 1, 7 + 7 * r + this.random.nextInt(2), BlocksAether.chest_mimic.func_176223_P());
                        }
                    }
                }
            }
        }
        for (x = 0; x < 24; ++x) {
            for (z = 0; z < 20; ++z) {
                int distance = (int)(Math.sqrt(x * x + (z - 7) * (z - 7)) + Math.sqrt(x * x + (z - 12) * (z - 12)));
                if (distance == 21) {
                    this.setBlockWithOffset(26 + x, 0, 5 + z, BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic)));
                    continue;
                }
                if (distance <= 21) continue;
                this.setBlockWithOffset(26 + x, 0, 5 + z, BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)));
            }
        }
        this.setBlocks(LOCKED_ANGELIC_STONE, LOCKED_LIGHT_ANGELIC_STONE, 20);
        this.addPlaneY(44, 1, 11, 6, 8);
        this.addSolidBox(46, 2, 13, 4, 2, 4);
        this.addLineX(46, 4, 13, 4);
        this.addLineX(46, 4, 16, 4);
        this.addPlaneX(49, 4, 13, 4, 4);
        this.setBlocks(Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BLUE), Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BLUE), 20);
        this.addPlaneY(47, 3, 14, 2, 2);
        for (x = 0; x < 2; ++x) {
            for (z = 0; z < 2; ++z) {
                this.setBlockWithOffset(44 + x * 5, 2, 11 + z * 7, BlocksAether.ambrosium_torch.func_176223_P());
            }
        }
        this.setBlocks(LOCKED_ANGELIC_STONE, LOCKED_LIGHT_ANGELIC_STONE, 20);
        this.addPlaneY(35, 1, 5, 6, 3);
        this.addPlaneY(35, 1, 22, 6, 3);
        this.addLineZ(34, 1, 5, 2);
        this.addLineZ(41, 1, 5, 2);
        this.addLineX(36, 1, 8, 4);
        this.addLineZ(34, 1, 23, 2);
        this.addLineZ(41, 1, 23, 2);
        this.addLineX(36, 1, 21, 4);
        this.setBlocks(Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), 1);
        this.addPlaneY(35, 1, 5, 6, 3);
        this.addPlaneY(35, 1, 22, 6, 3);
        this.setBlockWithOffset(35, 1, 7, BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)));
        this.setBlockWithOffset(40, 1, 7, BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)));
        this.setBlockWithOffset(35, 1, 22, BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)));
        this.setBlockWithOffset(40, 1, 22, BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)));
        for (x = 36; x < 40; x += 3) {
            for (z = 8; z < 22; z += 13) {
                this.setBlockWithOffset(x, 2, z, BlocksAether.ambrosium_torch.func_176223_P());
            }
        }
        this.generateChandelier(28, 0, 10, 8);
        this.generateChandelier(43, 0, 10, 8);
        this.generateChandelier(43, 0, 19, 8);
        this.generateChandelier(28, 0, 19, 8);
        this.generateGoldenOakSapling(45, 1, 6);
        this.generateGoldenOakSapling(45, 1, 21);
        EntityValkyrieQueen valkyrieQueen = new EntityValkyrieQueen(this.worldObj, this.getActualX(40, 15), (double)this.getActualY(1) + 0.5, this.getActualZ(40, 15));
        valkyrieQueen.func_70107_b(this.getActualX(40, 15), this.getActualY(2), this.getActualZ(40, 15));
        valkyrieQueen.setDungeonPosition(this.getActualX(26, 24), this.getActualY(0), this.getActualZ(26, 24));
        this.spawnEntity((Entity)valkyrieQueen, 40, 1, 15);
        this.setBlocks(LOCKED_ANGELIC_STONE, LOCKED_LIGHT_ANGELIC_STONE, 20);
        this.addHollowBox(41, -2, 13, 4, 4, 4);
        x = 42 + this.random.nextInt(2);
        z = 14 + this.random.nextInt(2);
        this.setBlockWithOffset(x, -1, z, ((BlockTreasureChest)BlocksAether.treasure_chest).correctFacing(this.worldObj, new BlockPos(this.getActualX(x, z), this.getActualY(-1), this.getActualZ(x, z)), BlocksAether.treasure_chest.func_176223_P()));
        return true;
    }

    public void generateGoldenOakSapling(int x, int y, int z) {
        this.setBlocks(LOCKED_ANGELIC_STONE, LOCKED_LIGHT_ANGELIC_STONE, 2);
        this.addPlaneY(x, y, z, 3, 3);
        this.setBlockWithOffset(x + 1, y, z + 1, BlocksAether.aether_dirt.func_176223_P());
        this.setBlockWithOffset(x + 1, y + 1, z + 1, BlocksAether.golden_oak_sapling.func_176223_P());
        for (int lineX = x; lineX < x + 3; lineX += 2) {
            for (int lineZ = z; lineZ < z + 3; lineZ += 2) {
                this.setBlockWithOffset(lineX, y + 1, lineZ, BlocksAether.ambrosium_torch.func_176223_P());
            }
        }
    }

    public void generateChandelier(int x, int y, int z, int height) {
        int lineY;
        for (lineY = y + (height + 3); lineY < y + (height + 6); ++lineY) {
            this.setBlockWithOffset(x, lineY, z, Blocks.field_180407_aO.func_176223_P());
        }
        for (int lineX = x - 1; lineX < x + 2; ++lineX) {
            this.setBlockWithOffset(lineX, y + (height + 1), z, Blocks.field_150426_aN.func_176223_P());
        }
        for (lineY = y + height; lineY < y + (height + 3); ++lineY) {
            this.setBlockWithOffset(x, lineY, z, Blocks.field_150426_aN.func_176223_P());
        }
        for (int lineZ = z - 1; lineZ < z + 2; ++lineZ) {
            this.setBlockWithOffset(x, y + (height + 1), lineZ, Blocks.field_150426_aN.func_176223_P());
        }
    }

    public void generateColumn(int x, int y, int z, int yRange) {
        this.setBlocks(BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic)), 20);
        this.addPlaneY(x, y, z, 3, 3);
        this.addPlaneY(x, y + yRange, z, 3, 3);
        this.setBlocks(BlocksAether.pillar.func_176223_P(), BlocksAether.pillar.func_176223_P(), 1);
        this.addLineY(x + 1, y, z + 1, yRange - 1);
        this.setBlockWithOffset(x + 1, y + (yRange - 1), z + 1, BlocksAether.pillar_top.func_176223_P());
    }

    public void generateStaircase(int x, int y, int z, int height) {
        this.setBlocks(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 1);
        this.addSolidBox(x + 1, y, z + 1, 4, height, 4);
        this.setBlocks(BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic)), 5);
        this.addSolidBox(x + 2, y, z + 2, 2, height + 4, 2);
        IBlockState slab = Blocks.field_150333_U.func_176223_P();
        IBlockState double_slab = Blocks.field_150334_T.func_176223_P();
        this.setBlockWithOffset(x + 1, y, z + 1, slab);
        this.setBlockWithOffset(x + 2, y, z + 1, double_slab);
        this.setBlockWithOffset(x + 3, y + 1, z + 1, slab);
        this.setBlockWithOffset(x + 4, y + 1, z + 1, double_slab);
        this.setBlockWithOffset(x + 4, y + 2, z + 2, slab);
        this.setBlockWithOffset(x + 4, y + 2, z + 3, double_slab);
        this.setBlockWithOffset(x + 4, y + 3, z + 4, slab);
        this.setBlockWithOffset(x + 3, y + 3, z + 4, double_slab);
        this.setBlockWithOffset(x + 2, y + 4, z + 4, slab);
        this.setBlockWithOffset(x + 1, y + 4, z + 4, double_slab);
        if (height == 5) {
            return;
        }
        this.setBlockWithOffset(x + 1, y + 5, z + 3, slab);
        this.setBlockWithOffset(x + 1, y + 5, z + 2, double_slab);
        this.setBlockWithOffset(x + 1, y + 6, z + 1, slab);
        this.setBlockWithOffset(x + 2, y + 6, z + 1, double_slab);
        this.setBlockWithOffset(x + 3, y + 7, z + 1, slab);
        this.setBlockWithOffset(x + 4, y + 7, z + 1, double_slab);
        this.setBlockWithOffset(x + 4, y + 8, z + 2, slab);
        this.setBlockWithOffset(x + 4, y + 8, z + 3, double_slab);
        this.setBlockWithOffset(x + 4, y + 9, z + 4, slab);
        this.setBlockWithOffset(x + 3, y + 9, z + 4, double_slab);
    }

    public void generateDoorX(int x, int y, int z, int yF, int zF) {
        for (int yFinal = y; yFinal < y + yF; ++yFinal) {
            for (int zFinal = z; zFinal < z + zF; ++zFinal) {
                this.setBlockWithOffset(x, yFinal, zFinal, Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    public void generateDoorZ(int z, int x, int y, int xF, int yF) {
        for (int xFinal = x; xFinal < x + xF; ++xFinal) {
            for (int yFinal = y; yFinal < y + yF; ++yFinal) {
                this.setBlockWithOffset(xFinal, yFinal, z, Blocks.field_150350_a.func_176223_P());
            }
        }
    }
}

