/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.client.render.entity;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import morph.avaritia.entity.EntityGapingVoid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class RenderGapingVoid
extends Render<EntityGapingVoid> {
    private ResourceLocation fill = new ResourceLocation("avaritia", "textures/entity/void.png");
    private ResourceLocation halo = new ResourceLocation("avaritia", "textures/entity/voidhalo.png");
    private CCModel model = (CCModel)OBJParser.parseModels((ResourceLocation)new ResourceLocation("avaritia", "model/hemisphere.obj")).get("model");

    public RenderGapingVoid(RenderManager manager) {
        super(manager);
    }

    public void doRender(EntityGapingVoid ent, double x, double y, double z, float entityYaw, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        CCRenderState ccrs = CCRenderState.instance();
        TextureUtils.changeTexture((ResourceLocation)this.halo);
        double age = (float)ent.getAge() + partialTicks;
        this.setColour(age, 1.0);
        double scale = EntityGapingVoid.getVoidScale(age);
        double fullfadedist = 0.6 * scale;
        double fadedist = fullfadedist + 1.5;
        double halocoord = 0.58 * scale;
        double haloscaledist = 2.2 * scale;
        double dx = ent.field_70165_t - this.field_76990_c.field_78725_b;
        double dy = ent.field_70163_u - this.field_76990_c.field_78726_c;
        double dz = ent.field_70161_v - this.field_76990_c.field_78723_d;
        double xzlen = Math.sqrt(dx * dx + dz * dz);
        double len = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (len <= haloscaledist) {
            double close = (haloscaledist - len) / haloscaledist;
            halocoord *= 1.0 + close * close * close * close * 1.5;
        }
        double yang = Math.atan2(xzlen, dy) * 57.29577951308232;
        double xang = Math.atan2(dx, dz) * 57.29577951308232;
        GlStateManager.func_179140_f();
        mc.field_71460_t.func_175072_h();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)((float)xang), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(yang + 90.0)), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179132_a((boolean)false);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(-halocoord, 0.0, -halocoord).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(-halocoord, 0.0, halocoord).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(halocoord, 0.0, halocoord).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(halocoord, 0.0, -halocoord).func_187315_a(1.0, 0.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
        TextureUtils.changeTexture((ResourceLocation)this.fill);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        GlStateManager.func_179129_p();
        ccrs.startDrawing(7, DefaultVertexFormats.field_181710_j);
        this.model.render(ccrs, new IVertexOperation[0]);
        ccrs.draw();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        if (len <= fadedist) {
            double alpha = 1.0;
            if (len >= fullfadedist) {
                alpha = 1.0 - (len - fullfadedist) / (fadedist - fullfadedist);
                alpha = alpha * alpha * (3.0 - 2.0 * alpha);
            }
            this.setColour(age, alpha);
            GlStateManager.func_179094_E();
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_179114_b((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
            double d = 0.0;
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(-100.0, 100.0, d).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-100.0, -100.0, d).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(100.0, -100.0, d).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(100.0, 100.0, d).func_187315_a(1.0, 0.0).func_181675_d();
            tess.func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179121_F();
        }
        mc.field_71460_t.func_180436_i();
        GlStateManager.func_179145_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected ResourceLocation getEntityTexture(EntityGapingVoid ent) {
        return this.fill;
    }

    private void setColour(double age, double alpha) {
        double life = age / 186.0;
        double f = Math.max(0.0, (life - EntityGapingVoid.collapse) / (1.0 - EntityGapingVoid.collapse));
        f = Math.max(f, 1.0 - life * 30.0);
        GlStateManager.func_179131_c((float)((float)f), (float)((float)f), (float)((float)f), (float)((float)alpha));
    }
}

