/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.handler;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import morph.avaritia.item.ItemArmorInfinity;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class AbilityHandler {
    public static final Set<String> entitiesWithHelmets = new HashSet<String>();
    public static final Set<String> entitiesWithChestplates = new HashSet<String>();
    public static final Set<String> entitiesWithLeggings = new HashSet<String>();
    public static final Set<String> entitiesWithBoots = new HashSet<String>();
    public static final Set<String> entitiesWithFlight = new HashSet<String>();

    public static boolean isPlayerWearing(EntityLivingBase entity, EntityEquipmentSlot slot, Predicate<Item> predicate) {
        ItemStack stack = entity.func_184582_a(slot);
        return !stack.func_190926_b() && predicate.test(stack.func_77973_b());
    }

    @SubscribeEvent
    public void updateAbilities(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        String key = entity.func_189512_bd() + "|" + entity.field_70170_p.field_72995_K;
        boolean hasHelmet = AbilityHandler.isPlayerWearing(event.getEntityLiving(), EntityEquipmentSlot.HEAD, item -> item instanceof ItemArmorInfinity);
        boolean hasChestplate = AbilityHandler.isPlayerWearing(event.getEntityLiving(), EntityEquipmentSlot.CHEST, item -> item instanceof ItemArmorInfinity);
        boolean hasLeggings = AbilityHandler.isPlayerWearing(event.getEntityLiving(), EntityEquipmentSlot.LEGS, item -> item instanceof ItemArmorInfinity);
        boolean hasBoots = AbilityHandler.isPlayerWearing(event.getEntityLiving(), EntityEquipmentSlot.FEET, item -> item instanceof ItemArmorInfinity);
        if (hasHelmet) {
            entitiesWithHelmets.add(key);
            AbilityHandler.handleHelmetStateChange(entity, true);
        }
        if (!hasHelmet) {
            entitiesWithHelmets.remove(key);
            AbilityHandler.handleHelmetStateChange(entity, false);
        }
        if (hasChestplate) {
            entitiesWithChestplates.add(key);
            AbilityHandler.handleChestplateStateChange(entity, true);
        }
        if (!hasChestplate) {
            entitiesWithChestplates.remove(key);
            AbilityHandler.handleChestplateStateChange(entity, false);
        }
        if (hasLeggings) {
            entitiesWithLeggings.add(key);
            AbilityHandler.handleLeggingsStateChange(entity, true);
        }
        if (!hasLeggings) {
            entitiesWithLeggings.remove(key);
            AbilityHandler.handleLeggingsStateChange(entity, false);
        }
        if (hasBoots) {
            AbilityHandler.handleBootsStateChange(entity);
            entitiesWithBoots.add(key);
        }
        if (!hasBoots) {
            AbilityHandler.handleBootsStateChange(entity);
            entitiesWithBoots.remove(key);
        }
        if (entitiesWithHelmets.contains(key)) {
            AbilityHandler.tickHelmetAbilities(entity);
        }
        if (entitiesWithChestplates.contains(key)) {
            AbilityHandler.tickChestplateAbilities(entity);
        }
        if (entitiesWithLeggings.contains(key)) {
            AbilityHandler.tickLeggingsAbilities(entity);
        }
        if (entitiesWithBoots.contains(key)) {
            AbilityHandler.tickBootsAbilities(entity);
        }
    }

    private static void stripAbilities(EntityLivingBase entity) {
        String key = entity.func_189512_bd() + "|" + entity.field_70170_p.field_72995_K;
        if (entitiesWithHelmets.remove(key)) {
            AbilityHandler.handleHelmetStateChange(entity, false);
        }
        if (entitiesWithChestplates.remove(key)) {
            AbilityHandler.handleChestplateStateChange(entity, false);
        }
        if (entitiesWithLeggings.remove(key)) {
            AbilityHandler.handleLeggingsStateChange(entity, false);
        }
        if (entitiesWithBoots.remove(key)) {
            AbilityHandler.handleBootsStateChange(entity);
        }
    }

    private static void handleHelmetStateChange(EntityLivingBase entity, boolean isNew) {
    }

    private static void handleChestplateStateChange(EntityLivingBase entity, boolean isNew) {
        String key = entity.func_189512_bd() + "|" + entity.field_70170_p.field_72995_K;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (isNew) {
                player.field_71075_bZ.field_75101_c = true;
                entitiesWithFlight.add(key);
            } else if (!player.field_71075_bZ.field_75098_d && entitiesWithFlight.contains(key)) {
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75100_b = false;
                entitiesWithFlight.remove(key);
            }
        }
    }

    private static void handleLeggingsStateChange(EntityLivingBase entity, boolean isNew) {
    }

    private static void handleBootsStateChange(EntityLivingBase entity) {
        String temp_key = entity.func_189512_bd() + "|" + entity.field_70170_p.field_72995_K;
        boolean hasBoots = AbilityHandler.isPlayerWearing(entity, EntityEquipmentSlot.FEET, item -> item instanceof ItemArmorInfinity);
        if (hasBoots) {
            entity.field_70138_W = 1.0625f;
            if (!entitiesWithBoots.contains(temp_key)) {
                entitiesWithBoots.add(temp_key);
            }
        } else if (entitiesWithBoots.contains(temp_key)) {
            entity.field_70138_W = 0.5f;
            entitiesWithBoots.remove(temp_key);
        }
    }

    private static void tickHelmetAbilities(EntityLivingBase entity) {
    }

    private static void tickChestplateAbilities(EntityLivingBase entity) {
    }

    private static void tickLeggingsAbilities(EntityLivingBase entity) {
    }

    private static void tickBootsAbilities(EntityLivingBase entity) {
        boolean swimming;
        boolean flying = entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b;
        boolean bl = swimming = entity.func_70055_a(Material.field_151586_h) || entity.func_70090_H();
        if (entity.field_70122_E || flying || swimming) {
            boolean sneaking = entity.func_70093_af();
            float speed = 0.15f * (flying ? 1.1f : 1.0f) * (sneaking ? 0.1f : 1.0f);
            if (entity.field_191988_bg > 0.0f) {
                entity.func_191958_b(0.0f, 0.0f, 1.0f, speed);
            } else if (entity.field_191988_bg < 0.0f) {
                entity.func_191958_b(0.0f, 0.0f, 1.0f, -speed * 0.3f);
            }
            if (entity.field_70702_br != 0.0f) {
                entity.func_191958_b(1.0f, 0.0f, 0.0f, speed * 0.5f * Math.signum(entity.field_70702_br));
            }
        }
    }

    @SubscribeEvent
    public void jumpBoost(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entitiesWithBoots.contains(entity.func_189512_bd() + "|" + entity.field_70170_p.field_72995_K)) {
            entity.field_70181_x += (double)0.4f;
        }
    }

    @SubscribeEvent
    public void onPlayerDemensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        AbilityHandler.stripAbilities((EntityLivingBase)event.player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        AbilityHandler.stripAbilities((EntityLivingBase)event.player);
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        AbilityHandler.stripAbilities((EntityLivingBase)event.player);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        AbilityHandler.stripAbilities((EntityLivingBase)event.player);
    }

    @SubscribeEvent
    public void entityContstructedEvent(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        AbilityHandler.stripAbilities(event.getEntityLiving());
    }
}

