/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import twilightforest.world.feature.TFGenCaveStalactite;

public class IMCHandler {
    private static final ImmutableSet.Builder<IBlockState> BLACKLIST_BUILDER = ImmutableSet.builder();
    private static final ImmutableList.Builder<IBlockState> ORE_BLOCKS_BUILDER = ImmutableList.builder();
    private static final ImmutableList.Builder<ItemStack> LOADING_ICONS_BUILDER = ImmutableList.builder();
    private static final ImmutableMultimap.Builder<IBlockState, IBlockState> CRUMBLE_BLOCKS_BUILDER = ImmutableMultimap.builder();
    private static final ImmutableMultimap.Builder<Integer, TFGenCaveStalactite.StalactiteEntry> STALACTITE_BUILDER = ImmutableMultimap.builder();

    static void onIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (message.isNBTMessage()) {
                NBTTagCompound imcCompound = message.getNBTValue();
                IMCHandler.readStatesFromTagList(imcCompound.func_150295_c("Blacklist", 10), arg_0 -> BLACKLIST_BUILDER.add(arg_0));
                IMCHandler.readFromTagList(imcCompound.func_150295_c("Ore_Blocks", 10), IMCHandler::handleOre);
                IMCHandler.readFromTagList(imcCompound.func_150295_c("Crumbling", 10), IMCHandler::handleCrumble);
            }
            if (!message.isItemStackMessage() || !message.key.equals("Loading_Icon")) continue;
            LOADING_ICONS_BUILDER.add((Object)message.getItemStackValue());
        }
    }

    private static void readFromTagList(NBTTagList list, Consumer<NBTTagCompound> consumer) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            consumer.accept(list.func_150305_b(i));
        }
    }

    private static void readStatesFromTagList(NBTTagList list, Consumer<IBlockState> consumer) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)list.func_150305_b(i));
            if (state.func_177230_c() == Blocks.field_150350_a) continue;
            consumer.accept(state);
        }
    }

    private static void handleCrumble(NBTTagCompound nbt) {
        IBlockState key = NBTUtil.func_190008_d((NBTTagCompound)nbt);
        if (key.func_177230_c() != Blocks.field_150350_a) {
            IMCHandler.readStatesFromTagList(nbt.func_150295_c("Crumbling", 10), value -> CRUMBLE_BLOCKS_BUILDER.put((Object)key, value));
        }
    }

    private static void handleOre(NBTTagCompound nbt) {
        IBlockState nbtState = NBTUtil.func_190008_d((NBTTagCompound)nbt);
        if (nbtState.func_177230_c() != Blocks.field_150350_a) {
            ORE_BLOCKS_BUILDER.add((Object)nbtState);
            if (nbt.func_150297_b("Stalactite_Settings", 10)) {
                NBTTagCompound settings = nbt.func_74775_l("Stalactite_Settings");
                int weight = IMCHandler.readInt(settings, "Weight", 15);
                int hillSize = IMCHandler.readInt(settings, "Hill_Size", 3);
                float size = IMCHandler.readFloat(settings, "Size", 0.7f);
                int maxLength = IMCHandler.readInt(settings, "Max_Length", 8);
                int minHeight = IMCHandler.readInt(settings, "Min_Height", 1);
                STALACTITE_BUILDER.put((Object)hillSize, (Object)new TFGenCaveStalactite.StalactiteEntry(nbtState, size, maxLength, minHeight, weight));
            }
        }
    }

    private static int readInt(NBTTagCompound tag, String key, int defaultValue) {
        return tag.func_150297_b(key, 99) ? tag.func_74762_e(key) : defaultValue;
    }

    private static float readFloat(NBTTagCompound tag, String key, float defaultValue) {
        return tag.func_150297_b(key, 99) ? tag.func_74760_g(key) : defaultValue;
    }

    public static ImmutableSet<IBlockState> getBlacklistedBlocks() {
        return BLACKLIST_BUILDER.build();
    }

    public static ImmutableList<IBlockState> getOreBlocks() {
        return ORE_BLOCKS_BUILDER.build();
    }

    public static ImmutableList<ItemStack> getLoadingIconStacks() {
        return LOADING_ICONS_BUILDER.build();
    }

    public static ImmutableMultimap<IBlockState, IBlockState> getCrumblingBlocks() {
        return CRUMBLE_BLOCKS_BUILDER.build();
    }

    public static ImmutableMultimap<Integer, TFGenCaveStalactite.StalactiteEntry> getStalactites() {
        return STALACTITE_BUILDER.build();
    }
}

