/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.stronghold;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.TFFeature;
import twilightforest.structures.StructureTFComponentOld;
import twilightforest.structures.start.StructureStartKnightStronghold;
import twilightforest.structures.stronghold.ComponentTFStrongholdAccessChamber;
import twilightforest.structures.stronghold.ComponentTFStrongholdAtrium;
import twilightforest.structures.stronghold.ComponentTFStrongholdBalconyRoom;
import twilightforest.structures.stronghold.ComponentTFStrongholdBossRoom;
import twilightforest.structures.stronghold.ComponentTFStrongholdCrossing;
import twilightforest.structures.stronghold.ComponentTFStrongholdDeadEnd;
import twilightforest.structures.stronghold.ComponentTFStrongholdEntrance;
import twilightforest.structures.stronghold.ComponentTFStrongholdFoundry;
import twilightforest.structures.stronghold.ComponentTFStrongholdLeftTurn;
import twilightforest.structures.stronghold.ComponentTFStrongholdRightTurn;
import twilightforest.structures.stronghold.ComponentTFStrongholdSmallHallway;
import twilightforest.structures.stronghold.ComponentTFStrongholdSmallStairs;
import twilightforest.structures.stronghold.ComponentTFStrongholdTrainingRoom;
import twilightforest.structures.stronghold.ComponentTFStrongholdTreasureCorridor;
import twilightforest.structures.stronghold.ComponentTFStrongholdTreasureRoom;
import twilightforest.structures.stronghold.ComponentTFStrongholdUpperAscender;
import twilightforest.structures.stronghold.ComponentTFStrongholdUpperCorridor;
import twilightforest.structures.stronghold.ComponentTFStrongholdUpperLeftTurn;
import twilightforest.structures.stronghold.ComponentTFStrongholdUpperRightTurn;
import twilightforest.structures.stronghold.ComponentTFStrongholdUpperTIntersection;
import twilightforest.structures.stronghold.StructureTFStrongholdComponent;
import twilightforest.structures.stronghold.StructureTFStrongholdShield;
import twilightforest.structures.stronghold.TFStrongholdPieceWeight;

public class TFStrongholdPieces {
    private static final TFStrongholdPieceWeight[] pieceWeightArray = new TFStrongholdPieceWeight[]{new TFStrongholdPieceWeight(ComponentTFStrongholdSmallHallway::new, 40, 0), new TFStrongholdPieceWeight(ComponentTFStrongholdLeftTurn::new, 20, 0), new TFStrongholdPieceWeight(ComponentTFStrongholdCrossing::new, 10, 4), new TFStrongholdPieceWeight(ComponentTFStrongholdRightTurn::new, 20, 0), new TFStrongholdPieceWeight(ComponentTFStrongholdDeadEnd::new, 5, 0), new TFStrongholdPieceWeight(ComponentTFStrongholdBalconyRoom::new, 10, 3, 2), new TFStrongholdPieceWeight(ComponentTFStrongholdTrainingRoom::new, 10, 2), new TFStrongholdPieceWeight(ComponentTFStrongholdSmallStairs::new, 10, 0), new TFStrongholdPieceWeight(ComponentTFStrongholdTreasureCorridor::new, 5, 0), new TFStrongholdPieceWeight(ComponentTFStrongholdAtrium::new, 5, 2, 3), new TFStrongholdPieceWeight(ComponentTFStrongholdFoundry::new, 5, 1, 4), new TFStrongholdPieceWeight(ComponentTFStrongholdTreasureRoom::new, 5, 1, 4), new TFStrongholdPieceWeight(ComponentTFStrongholdBossRoom::new, 10, 1, 4)};
    private List<TFStrongholdPieceWeight> pieceList;
    static int totalWeight = 0;
    private static TFStrongholdPieceWeight lastPieceMade;

    public static void registerPieces() {
        MapGenStructureIO.func_143034_b(StructureStartKnightStronghold.class, (String)"TFKSt");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdSmallHallway.class, (String)"TFSSH");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdLeftTurn.class, (String)"TFSLT");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdCrossing.class, (String)"TFSCr");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdRightTurn.class, (String)"TFSRT");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdDeadEnd.class, (String)"TFSDE");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdBalconyRoom.class, (String)"TFSBR");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdTrainingRoom.class, (String)"TFSTR");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdSmallStairs.class, (String)"TFSSS");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdTreasureCorridor.class, (String)"TFSTC");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdAtrium.class, (String)"TFSAt");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdFoundry.class, (String)"TFSFo");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdTreasureRoom.class, (String)"TFTreaR");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdBossRoom.class, (String)"TFSBR");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdAccessChamber.class, (String)"TFSAC");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdEntrance.class, (String)"TFSEnter");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdUpperAscender.class, (String)"TFSUA");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdUpperLeftTurn.class, (String)"TFSULT");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdUpperRightTurn.class, (String)"TFSURT");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdUpperCorridor.class, (String)"TFSUCo");
        MapGenStructureIO.func_143031_a(ComponentTFStrongholdUpperTIntersection.class, (String)"TFSUTI");
        MapGenStructureIO.func_143031_a(StructureTFStrongholdShield.class, (String)"TFSShield");
    }

    public void prepareStructurePieces() {
        this.pieceList = new ArrayList<TFStrongholdPieceWeight>();
        for (TFStrongholdPieceWeight piece : pieceWeightArray) {
            piece.instancesSpawned = 0;
            this.pieceList.add(piece);
        }
    }

    public void markBossRoomUsed() {
        this.pieceList.remove(this.pieceList.size() - 1);
    }

    private boolean hasMoreLimitedPieces() {
        boolean flag = false;
        totalWeight = 0;
        for (TFStrongholdPieceWeight piece : this.pieceList) {
            totalWeight += piece.pieceWeight;
            if (piece.instancesLimit <= 0 || piece.instancesSpawned >= piece.instancesLimit) continue;
            flag = true;
        }
        return flag;
    }

    public StructureTFStrongholdComponent getNextComponent(StructureComponent parent, List<StructureComponent> list, Random random, TFFeature feature, int index, EnumFacing facing, int x, int y, int z) {
        if (!this.hasMoreLimitedPieces()) {
            return null;
        }
        block0: for (int i = 0; i < 5; ++i) {
            int counter = random.nextInt(totalWeight);
            for (TFStrongholdPieceWeight piece : this.pieceList) {
                if ((counter -= piece.pieceWeight) >= 0) continue;
                if (!piece.isDeepEnough(index) || piece == lastPieceMade) continue block0;
                StructureTFStrongholdComponent component = piece.factory.newInstance(feature, index, facing, x, y, z);
                if (StructureComponent.func_74883_a(list, (StructureBoundingBox)component.func_74874_b()) != null) continue;
                ++piece.instancesSpawned;
                if (!piece.canSpawnMoreStructures()) {
                    this.pieceList.remove(piece);
                }
                lastPieceMade = piece;
                return component;
            }
        }
        ComponentTFStrongholdDeadEnd deadEnd = new ComponentTFStrongholdDeadEnd(parent instanceof StructureTFComponentOld ? ((StructureTFComponentOld)parent).getFeatureType() : TFFeature.NOTHING, index, facing, x, y, z);
        if (StructureComponent.func_74883_a(list, (StructureBoundingBox)deadEnd.func_74874_b()) == null) {
            return deadEnd;
        }
        return null;
    }
}

