/*
 * Decompiled with CFR 0.152.
 */
package erebus.block.bamboo;

import erebus.Erebus;
import erebus.ModBlocks;
import erebus.ModTabs;
import erebus.api.IErebusEnum;
import erebus.blocks.EnumWood;
import erebus.core.helper.Utils;
import erebus.proxy.CommonProxy;
import erebus.tileentity.TileEntityBambooCrate;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBambooCrate
extends BlockContainer
implements ModBlocks.IHasCustomItem {
    public static final PropertyEnum<EnumCrateType> CRATE_TYPE = PropertyEnum.func_177709_a((String)"crate_type", EnumCrateType.class);

    public BlockBambooCrate() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(ModTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(CRATE_TYPE, (Comparable)((Object)EnumCrateType.DEFAULT)));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityBambooCrate();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CRATE_TYPE});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == ModTabs.BLOCKS) {
            list.add((Object)new ItemStack((Block)this, 1, EnumCrateType.DEFAULT.ordinal()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(CRATE_TYPE, (Comparable)((Object)EnumCrateType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        EnumCrateType type = (EnumCrateType)((Object)state.func_177229_b(CRATE_TYPE));
        return type.ordinal();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (this.isCrate(world, pos)) {
            if (this.isCrate(world, pos.func_177984_a()) && this.isCrate(world, pos.func_177982_a(1, 1, 0)) && this.isCrate(world, pos.func_177982_a(1, 1, 1)) && this.isCrate(world, pos.func_177982_a(0, 1, 1)) && this.isCrate(world, pos.func_177982_a(1, 0, 0)) && this.isCrate(world, pos.func_177982_a(1, 0, 1)) && this.isCrate(world, pos.func_177982_a(0, 0, 1))) {
                world.func_180501_a(pos, this.func_176223_P().func_177226_a(CRATE_TYPE, (Comparable)((Object)EnumCrateType.BTL)), 3);
                return;
            }
            if (this.isCrate(world, pos.func_177984_a()) && this.isCrate(world, pos.func_177982_a(-1, 1, 0)) && this.isCrate(world, pos.func_177982_a(-1, 1, 1)) && this.isCrate(world, pos.func_177982_a(0, 1, 1)) && this.isCrate(world, pos.func_177982_a(-1, 0, 0)) && this.isCrate(world, pos.func_177982_a(-1, 0, 1)) && this.isCrate(world, pos.func_177982_a(0, 0, 1))) {
                world.func_180501_a(pos, this.func_176223_P().func_177226_a(CRATE_TYPE, (Comparable)((Object)EnumCrateType.BTR)), 3);
                return;
            }
            if (this.isCrate(world, pos.func_177984_a()) && this.isCrate(world, pos.func_177982_a(1, 1, 0)) && this.isCrate(world, pos.func_177982_a(1, 1, -1)) && this.isCrate(world, pos.func_177982_a(0, 1, -1)) && this.isCrate(world, pos.func_177982_a(1, 0, 0)) && this.isCrate(world, pos.func_177982_a(1, 0, -1)) && this.isCrate(world, pos.func_177982_a(0, 0, -1))) {
                world.func_180501_a(pos, this.func_176223_P().func_177226_a(CRATE_TYPE, (Comparable)((Object)EnumCrateType.BBL)), 3);
                return;
            }
            if (this.isCrate(world, pos.func_177984_a()) && this.isCrate(world, pos.func_177982_a(-1, 1, 0)) && this.isCrate(world, pos.func_177982_a(-1, 1, -1)) && this.isCrate(world, pos.func_177982_a(0, 1, -1)) && this.isCrate(world, pos.func_177982_a(-1, 0, 0)) && this.isCrate(world, pos.func_177982_a(-1, 0, -1)) && this.isCrate(world, pos.func_177982_a(0, 0, -1))) {
                world.func_180501_a(pos, this.func_176223_P().func_177226_a(CRATE_TYPE, (Comparable)((Object)EnumCrateType.BBR)), 3);
                return;
            }
            if (this.isCrate(world, pos.func_177977_b()) && this.isCrate(world, pos.func_177982_a(1, -1, 0)) && this.isCrate(world, pos.func_177982_a(1, -1, 1)) && this.isCrate(world, pos.func_177982_a(0, -1, 1)) && this.isCrate(world, pos.func_177982_a(1, 0, 0)) && this.isCrate(world, pos.func_177982_a(1, 0, 1)) && this.isCrate(world, pos.func_177982_a(0, 0, 1))) {
                world.func_180501_a(pos, this.func_176223_P().func_177226_a(CRATE_TYPE, (Comparable)((Object)EnumCrateType.TTL)), 3);
                return;
            }
            if (this.isCrate(world, pos.func_177977_b()) && this.isCrate(world, pos.func_177982_a(-1, -1, 0)) && this.isCrate(world, pos.func_177982_a(-1, -1, 1)) && this.isCrate(world, pos.func_177982_a(0, -1, 1)) && this.isCrate(world, pos.func_177982_a(-1, 0, 0)) && this.isCrate(world, pos.func_177982_a(-1, 0, 1)) && this.isCrate(world, pos.func_177982_a(0, 0, 1))) {
                world.func_180501_a(pos, this.func_176223_P().func_177226_a(CRATE_TYPE, (Comparable)((Object)EnumCrateType.TTR)), 3);
                return;
            }
            if (this.isCrate(world, pos.func_177977_b()) && this.isCrate(world, pos.func_177982_a(1, -1, 0)) && this.isCrate(world, pos.func_177982_a(1, -1, -1)) && this.isCrate(world, pos.func_177982_a(0, -1, -1)) && this.isCrate(world, pos.func_177982_a(1, 0, 0)) && this.isCrate(world, pos.func_177982_a(1, 0, -1)) && this.isCrate(world, pos.func_177982_a(0, 0, -1))) {
                world.func_180501_a(pos, this.func_176223_P().func_177226_a(CRATE_TYPE, (Comparable)((Object)EnumCrateType.TBL)), 3);
                return;
            }
            if (this.isCrate(world, pos.func_177977_b()) && this.isCrate(world, pos.func_177982_a(-1, -1, 0)) && this.isCrate(world, pos.func_177982_a(-1, -1, -1)) && this.isCrate(world, pos.func_177982_a(0, -1, -1)) && this.isCrate(world, pos.func_177982_a(-1, 0, 0)) && this.isCrate(world, pos.func_177982_a(-1, 0, -1)) && this.isCrate(world, pos.func_177982_a(0, 0, -1))) {
                world.func_180501_a(pos, this.func_176223_P().func_177226_a(CRATE_TYPE, (Comparable)((Object)EnumCrateType.TBR)), 3);
                return;
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (block == this) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        if (world.func_180495_p(pos.func_177982_a(i, k, j)).func_177230_c() != this) continue;
                        this.func_176213_c(world, pos.func_177982_a(i, k, j), world.func_180495_p(pos.func_177982_a(i, k, j)));
                    }
                }
            }
        }
    }

    private boolean isCrate(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == this;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            IBlockState state = world.func_180495_p(pos.func_177982_a(dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e()));
            if (state.func_177230_c() != this) continue;
            int meta = state.func_177230_c().func_176201_c(state);
            if (meta != 0) {
                return false;
            }
            if (world.func_180495_p(pos.func_177982_a(dir.func_176734_d().func_82601_c(), dir.func_176734_d().func_96559_d(), dir.func_176734_d().func_82599_e())).func_177230_c() != this) continue;
            return false;
        }
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityBambooCrate tileCrate = Utils.getTileEntity((IBlockAccess)world, pos, TileEntityBambooCrate.class);
        if (tileCrate != null) {
            if (state.func_177230_c().func_176201_c(state) == 0) {
                ItemStack current = player.field_71071_by.func_70448_g();
                if (!current.func_190926_b() && current.func_77973_b() == Item.func_150898_a((Block)this)) {
                    return false;
                }
                player.openGui((Object)Erebus.INSTANCE, CommonProxy.GuiID.BAMBOO_CRATE.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            IBlockState crateState;
                            if (world.func_180495_p(pos.func_177982_a(i, k, j)).func_177230_c() != this || (crateState = world.func_180495_p(pos.func_177982_a(i, k, j))).func_177230_c().func_176201_c(crateState) != 1) continue;
                            player.openGui((Object)Erebus.INSTANCE, CommonProxy.GuiID.COLOSSAL_CRATE.ordinal(), world, pos.func_177958_n() + i, pos.func_177956_o() + k, pos.func_177952_p() + j);
                            return true;
                        }
                    }
                }
            }
        }
        return true;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityBambooCrate tile;
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && (tile = Utils.getTileEntity((IBlockAccess)world, pos, TileEntityBambooCrate.class)) != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            tile.func_189515_b(nbt);
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, 0);
            for (int i = 0; i < tile.func_70302_i_(); ++i) {
                ItemStack itemstack = tile.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                stack.func_77982_d(nbt);
                break;
            }
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            world.func_175713_t(pos);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && stack.func_77942_o() && stack.func_77978_p().func_74764_b("Items")) {
            TileEntityBambooCrate tile = Utils.getTileEntity((IBlockAccess)world, pos, TileEntityBambooCrate.class);
            if (tile != null) {
                NBTTagList tags = stack.func_77978_p().func_150295_c("Items", 10);
                tile.inventory = NonNullList.func_191197_a((int)tile.func_70302_i_(), (Object)ItemStack.field_190927_a);
                for (int i = 0; i < tags.func_74745_c(); ++i) {
                    NBTTagCompound data = tags.func_150305_b(i);
                    int j = data.func_74771_c("Slot") & 0xFF;
                    if (j < 0 || j >= tile.inventory.size()) continue;
                    tile.inventory.set(j, (Object)new ItemStack(data));
                }
            }
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.resetCrates(world, pos, state.func_177230_c().func_176201_c(state));
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)EnumWood.BAMBOO.getLog().func_176223_P()));
        super.func_180663_b(world, pos, state);
    }

    private void resetCrates(World world, BlockPos pos, int meta) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    IBlockState crateState;
                    if (world.func_180495_p(pos.func_177982_a(i, k, j)).func_177230_c() != this || (crateState = world.func_180495_p(pos.func_177982_a(i, k, j))).func_177230_c().func_176201_c(crateState) == 0) continue;
                    world.func_180501_a(pos.func_177982_a(i, k, j), this.func_176203_a(0), 3);
                }
            }
        }
    }

    @Override
    public ItemBlock getItemBlock() {
        ItemBlock CRATE_ITEM = new ItemBlock(this.func_176223_P().func_177226_a(CRATE_TYPE, (Comparable)((Object)EnumCrateType.DEFAULT)).func_177230_c()){

            @SideOnly(value=Side.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
                list.add("Stores Items When Broken");
                if (stack.func_77942_o() && stack.func_77978_p().func_150295_c("Items", 10) != null) {
                    NBTTagList tags = stack.func_77978_p().func_150295_c("Items", 10);
                    for (int i = 0; i < tags.func_74745_c(); ++i) {
                        NBTTagCompound data = tags.func_150305_b(i);
                        int j = data.func_74771_c("Slot") & 0xFF;
                        list.add("Slot " + (j + 1) + ": " + TextFormatting.GREEN + new ItemStack(data).func_82833_r() + " x " + new ItemStack(data).func_190916_E());
                    }
                }
            }
        };
        return CRATE_ITEM;
    }

    public static enum EnumCrateType implements IErebusEnum
    {
        DEFAULT,
        BTL,
        BTR,
        BBL,
        BBR,
        TTL,
        TTR,
        TBL,
        TBR;


        @Override
        public ItemStack createStack(int size) {
            return new ItemStack(ModBlocks.BAMBOO_CRATE, size, this.ordinal());
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

