/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModItems;
import erebus.ModTabs;
import erebus.core.helper.Utils;
import erebus.items.ItemErebusFood;
import erebus.items.ItemMaterials;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDarkFruitVine
extends BlockBush {
    public static final PropertyInteger DARK_VINE_AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)6);
    private static final AxisAlignedBB[] DARK_VINE_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.875, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.1875, 0.625, 0.1875, 0.8125, 1.0, 0.8125), new AxisAlignedBB(0.1875, 0.375, 0.1875, 0.8125, 1.0, 0.8125), new AxisAlignedBB(0.1875, 0.1875, 0.1875, 0.8125, 1.0, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125), new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875)};

    public BlockDarkFruitVine() {
        this.func_149711_c(0.0f);
        this.func_149647_a(ModTabs.PLANTS);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DARK_VINE_AGE, (Comparable)Integer.valueOf(0)));
    }

    public int func_149738_a(World world) {
        return 5;
    }

    protected PropertyInteger getAgeProperty() {
        return DARK_VINE_AGE;
    }

    public int getMaxAge() {
        return 6;
    }

    protected int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DARK_VINE_AGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DARK_VINE_AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DARK_VINE_AGE);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return DARK_VINE_AABB[(Integer)state.func_177229_b((IProperty)this.getAgeProperty())];
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int age = this.getAge(state);
        if (world.func_175623_d(pos.func_177977_b()) && this.canBlockStay(world, pos.func_177977_b())) {
            switch (age) {
                case 4: 
                case 5: 
                case 6: {
                    world.func_175656_a(pos.func_177977_b(), this.withAge(0));
                }
            }
        }
        switch (age) {
            case 0: {
                world.func_175656_a(pos, this.withAge(1));
                break;
            }
            case 1: {
                world.func_175656_a(pos, this.withAge(2));
                break;
            }
            case 2: {
                world.func_175656_a(pos, this.withAge(3));
                break;
            }
            case 3: {
                world.func_175656_a(pos, this.withAge(4));
            }
        }
        if (age == 4 && rand.nextInt(50) == 0) {
            world.func_175656_a(pos, this.withAge(5));
        }
        if (age == 5 && rand.nextInt(10) == 0) {
            world.func_175656_a(pos, this.withAge(6));
        }
        if (age == 6 && rand.nextInt(10) == 0) {
            world.func_175656_a(pos, this.withAge(4));
        }
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int age = this.getAge(state);
        if (age == 5) {
            ItemStack item = new ItemStack(ModItems.EREBUS_FOOD, 1, ItemErebusFood.EnumFoodType.DARK_FRUIT.ordinal());
            world.func_184133_a(player, pos, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, 2.0f);
            if (!player.field_71071_by.func_70441_a(item)) {
                Utils.dropStack(world, pos, item);
            }
            world.func_175656_a(pos, this.withAge(4));
            return true;
        }
        if (age == 6) {
            ItemStack item = new ItemStack(ModItems.MATERIALS, 1, ItemMaterials.EnumErebusMaterialsType.DARK_FRUIT_SEEDS.ordinal());
            world.func_184133_a(player, pos, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, 2.0f);
            if (!player.field_71071_by.func_70441_a(item)) {
                Utils.dropStack(world, pos, item);
            }
            world.func_175656_a(pos, this.withAge(4));
            return true;
        }
        return true;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        int age = this.getAge(state);
        ItemStack item = ItemStack.field_190927_a;
        if (age == 5) {
            item = new ItemStack(ModItems.EREBUS_FOOD, 2, ItemErebusFood.EnumFoodType.DARK_FRUIT.ordinal());
            Utils.dropStack(world, pos, item);
        }
        if (age == 6) {
            item = new ItemStack(ModItems.MATERIALS, 2, ItemMaterials.EnumErebusMaterialsType.DARK_FRUIT_SEEDS.ordinal());
            Utils.dropStack(world, pos, item);
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177984_a());
        return this.isValidBlock(state) && this.canBlockStay(world, pos);
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177984_a());
        return this.isValidBlock(state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int age = this.getAge(state);
        ItemStack item = ItemStack.field_190927_a;
        if (world.func_175623_d(pos.func_177984_a())) {
            if (age == 5) {
                item = new ItemStack(ModItems.EREBUS_FOOD, 1, ItemErebusFood.EnumFoodType.DARK_FRUIT.ordinal());
                Utils.dropStack(world, pos, item);
            }
            if (age == 6) {
                item = new ItemStack(ModItems.MATERIALS, 1, ItemMaterials.EnumErebusMaterialsType.DARK_FRUIT_SEEDS.ordinal());
                Utils.dropStack(world, pos, item);
            }
            world.func_175698_g(pos);
        }
        this.canBlockStay(world, pos);
    }

    private boolean isValidBlock(IBlockState state) {
        Block block = state.func_177230_c();
        return state.func_185904_a().func_76230_c() || block == this;
    }
}

