/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModBlocks;
import erebus.api.IErebusEnum;
import erebus.core.helper.Utils;
import erebus.items.block.ItemBlockEnum;
import erebus.tileentity.TileEntityPreservedBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPreservedBlock
extends Block
implements ITileEntityProvider,
ModBlocks.IHasCustomItem,
ModBlocks.ISubBlocksBlock {
    public static final PropertyEnum<EnumAmberType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumAmberType.class);

    public BlockPreservedBlock() {
        super(Material.field_151592_s);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumAmberType.AMBER)));
        this.func_149711_c(10.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.setHarvestLevel("pickaxe", 0);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumAmberType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        EnumAmberType type = (EnumAmberType)((Object)state.func_177229_b(TYPE));
        return type.ordinal();
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityPreservedBlock tile;
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && (tile = Utils.getTileEntity((IBlockAccess)world, pos, TileEntityPreservedBlock.class)) != null) {
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()) > 0) {
                NBTTagCompound nbt = new NBTTagCompound();
                tile.func_189515_b(nbt);
                ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, this.func_180651_a(world.func_180495_p(pos)));
                nbt.func_74782_a("EntityNBT", (NBTBase)tile.getEntityNBT());
                stack.func_77982_d(nbt);
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            } else {
                tile.spawnTrappedEntity();
            }
            world.func_175713_t(pos);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && stack.func_77942_o() && stack.func_77978_p().func_74764_b("EntityNBT")) {
            TileEntityPreservedBlock tile = Utils.getTileEntity((IBlockAccess)world, pos, TileEntityPreservedBlock.class);
            if (tile != null) {
                NBTTagCompound nbt = stack.func_77978_p().func_74775_l("EntityNBT");
                tile.setEntityNBT(nbt);
                tile.rotation = (byte)((MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) % 4);
            }
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPreservedBlock();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityPreservedBlock tile = Utils.getTileEntity((IBlockAccess)world, pos, TileEntityPreservedBlock.class);
        EnumAmberType type = (EnumAmberType)((Object)state.func_177229_b(TYPE));
        if (tile != null) {
            ItemStack stack = new ItemStack((Block)this, 1, this.func_180651_a(state));
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("EntityNBT", (NBTBase)tile.getEntityNBT());
            stack.func_77982_d(nbt);
            return stack;
        }
        if (type != null && type.ordinal() != 0) {
            return new ItemStack(ModBlocks.AMBER_GLASS, 1, 0);
        }
        return new ItemStack(ModBlocks.AMBER, 1, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = world.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        return block == this || block == ModBlocks.AMBER ? false : super.func_176225_a(state, world, pos, side);
    }

    @Override
    public ItemBlock getItemBlock() {
        return ItemBlockEnum.create(this, EnumAmberType.class);
    }

    @Override
    public List<String> getModels() {
        ArrayList<String> models = new ArrayList<String>();
        for (EnumAmberType type : EnumAmberType.values()) {
            models.add(type.func_176610_l());
        }
        return models;
    }

    public static enum EnumAmberType implements IErebusEnum
    {
        AMBER,
        AMBER_GLASS;


        @Override
        public ItemStack createStack(int size) {
            return new ItemStack(ModBlocks.PRESERVED_BLOCK, size, this.ordinal());
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

