/*
 * Decompiled with CFR 0.152.
 */
package erebus.client.render.tile;

import erebus.ModBlocks;
import erebus.blocks.BlockBones;
import erebus.client.model.block.ModelBoneBlock;
import erebus.tileentity.TileEntityBones;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityBoneBlockRenderer
extends TileEntitySpecialRenderer<TileEntityBones> {
    private final ResourceLocation TEXTURE = new ResourceLocation("erebus:textures/special/tiles/bone_block.png");
    private final ModelBoneBlock MODEL = new ModelBoneBlock();

    public void renderTile(TileEntityBones tile, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (state == null || state.func_177230_c() != ModBlocks.BLOCK_OF_BONES) {
            return;
        }
        this.func_147499_a(this.TEXTURE);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockBones.field_176387_N);
        if (facing == null) {
            return;
        }
        switch (facing) {
            case DOWN: {
                break;
            }
            case UP: {
                break;
            }
            case NORTH: {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.MODEL.render();
                GlStateManager.func_179121_F();
                break;
            }
            case SOUTH: {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.MODEL.render();
                GlStateManager.func_179121_F();
                break;
            }
            case WEST: {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.MODEL.render();
                GlStateManager.func_179121_F();
                break;
            }
            case EAST: {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.MODEL.render();
                GlStateManager.func_179121_F();
            }
        }
        if (!StringUtils.func_151246_b((String)tile.getOwnerName())) {
            this.renderNameTag(tile.getOwnerName(), x + 0.5, y, z + 0.5);
        }
    }

    public void render(TileEntityBones tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile == null || !tile.func_145830_o()) {
            this.renderTileAsItem(x, y, z);
            return;
        }
        this.renderTile(tile, x, y, z, partialTicks, destroyStage, alpha);
    }

    private void renderTileAsItem(double x, double y, double z) {
        GlStateManager.func_179094_E();
        this.func_147499_a(this.TEXTURE);
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.MODEL.render();
        GlStateManager.func_179121_F();
    }

    private void renderNameTag(String name, double x, double y, double z) {
        float scale = 0.02666667f;
        float height = 0.8f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y + (double)height + 0.5), (double)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)scale);
        GlStateManager.func_179114_b((float)Minecraft.func_71410_x().func_175598_ae().field_78735_i, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        int width = fontrenderer.func_78256_a(name) / 2;
        vertexbuffer.func_181662_b(x - (double)width - 1.0, y - 1.0, z).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b(x - (double)width - 1.0, y + 8.0, z).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b(x + (double)width + 1.0, y + 8.0, z).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b(x + (double)width + 1.0, y - 1.0, z).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        fontrenderer.func_78276_b(name, -fontrenderer.func_78256_a(name) / 2, 0, 0x20FFFFFF);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        fontrenderer.func_78276_b(name, -fontrenderer.func_78256_a(name) / 2, 0, -1);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

