/*
 * Decompiled with CFR 0.152.
 */
package erebus.client.render.tile;

import erebus.ModBlocks;
import erebus.blocks.BlockLiquifier;
import erebus.client.model.block.ModelLiquifier;
import erebus.tileentity.TileEntityLiquifier;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityLiquifierRenderer
extends TileEntitySpecialRenderer<TileEntityLiquifier> {
    private static final ResourceLocation BASE_TEXTURE = new ResourceLocation("erebus:textures/special/tiles/liquifier.png");
    private final ModelLiquifier MODEL = new ModelLiquifier();

    public void renderTile(TileEntityLiquifier tile, double x, double y, double z, float partialTick, int destroyStage) {
        IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (state == null || state.func_177230_c() != ModBlocks.LIQUIFIER) {
            return;
        }
        float fluidLevel = tile.tank.getFluidAmount();
        if (fluidLevel > 0.0f) {
            FluidStack fluidStack = new FluidStack(tile.tank.getFluid(), 100);
            float height = 0.375f / (float)tile.tank.getCapacity() * fluidLevel;
            TextureAtlasSprite fluidStillSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStack.getFluid().getStill().toString());
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            int fluidColor = fluidStack.getFluid().getColor(fluidStack);
            GlStateManager.func_179140_f();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            this.setGLColorFromInt(fluidColor);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            float yMin = 0.0f;
            float xMax = 1.984375f;
            float zMax = 1.984375f;
            float xMin = 0.015625f;
            float zMin = 0.015625f;
            yMin = 0.015625f;
            this.renderCuboid(buffer, xMax, xMin, yMin, height, zMin, zMax, fluidStillSprite);
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
        }
        float ticks = (float)tile.animationTicks + (float)(tile.animationTicks - tile.prevAnimationTicks) * partialTick;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)y, (double)(z + 0.5));
        if (!tile.func_70301_a(0).func_190926_b()) {
            GlStateManager.func_179114_b((float)ticks, (float)0.0f, (float)-1.0f, (float)0.0f);
            this.renderItemInSlot(tile, tile.func_70301_a(0), 0.0f, 0.5f, 0.0f, 0.175f);
        }
        GlStateManager.func_179121_F();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockLiquifier.field_176387_N);
        this.func_147499_a(BASE_TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        switch (facing) {
            case NORTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
        this.MODEL.renderLidAnimated(tile, partialTick);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)ticks, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.MODEL.renderBlades();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        this.MODEL.renderTank();
        GlStateManager.func_179121_F();
    }

    public void render(TileEntityLiquifier te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te == null || !te.func_145830_o()) {
            return;
        }
        this.renderTile(te, x, y, z, partialTicks, destroyStage);
    }

    public void renderItemInSlot(TileEntityLiquifier tile, ItemStack stack, float x, float y, float z, float scale) {
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)z);
            GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)scale);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.func_147499_a(TextureMap.field_110575_b);
            Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            Minecraft.func_71410_x().func_175599_af().func_180454_a(stack, Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, (World)null, (EntityLivingBase)null));
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    private void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private void renderCuboid(BufferBuilder buffer, float xMax, float xMin, float yMin, float height, float zMin, float zMax, TextureAtlasSprite textureAtlasSprite) {
        double uMin = textureAtlasSprite.func_94209_e();
        double uMax = textureAtlasSprite.func_94212_f();
        double vMin = textureAtlasSprite.func_94206_g();
        double vMax = textureAtlasSprite.func_94210_h();
        double vHeight = vMax - vMin;
        this.addVertexWithUV(buffer, xMax, height, zMax, uMax, vMin);
        this.addVertexWithUV(buffer, xMax, height, zMin, uMin, vMin);
        this.addVertexWithUV(buffer, xMin, height, zMin, uMin, vMax);
        this.addVertexWithUV(buffer, xMin, height, zMax, uMax, vMax);
        this.addVertexWithUV(buffer, xMax, yMin, zMin, uMax, vMin);
        this.addVertexWithUV(buffer, xMin, yMin, zMin, uMin, vMin);
        this.addVertexWithUV(buffer, xMin, height, zMin, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, height, zMin, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, yMin, zMax, uMin, vMin);
        this.addVertexWithUV(buffer, xMax, height, zMax, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, height, zMax, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, yMin, zMax, uMax, vMin);
        this.addVertexWithUV(buffer, xMax, yMin, zMin, uMin, vMin);
        this.addVertexWithUV(buffer, xMax, height, zMin, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, height, zMax, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, yMin, zMax, uMax, vMin);
        this.addVertexWithUV(buffer, xMin, yMin, zMax, uMin, vMin);
        this.addVertexWithUV(buffer, xMin, height, zMax, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, height, zMin, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, yMin, zMin, uMax, vMin);
        this.addVertexWithUV(buffer, xMax, yMin, zMin, uMax, vMin);
        this.addVertexWithUV(buffer, xMax, yMin, zMax, uMin, vMin);
        this.addVertexWithUV(buffer, xMin, yMin, zMax, uMin, vMax);
        this.addVertexWithUV(buffer, xMin, yMin, zMin, uMax, vMax);
    }

    private void addVertexWithUV(BufferBuilder buffer, float x, float y, float z, double u, double v) {
        buffer.func_181662_b((double)(x / 2.0f), (double)y, (double)(z / 2.0f)).func_187315_a(u, v).func_181675_d();
    }

    private void addVertexWithColor(BufferBuilder buffer, float x, float y, float z, float red, float green, float blue, float alpha) {
        buffer.func_181662_b((double)(x / 2.0f), (double)y, (double)(z / 2.0f)).func_181666_a(red, green, blue, alpha).func_181675_d();
    }
}

