/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.Erebus;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.ModSounds;
import erebus.block.silo.TileEntitySiloTank;
import erebus.core.handler.configs.ConfigHandler;
import erebus.core.helper.Utils;
import erebus.entity.ai.EntityAIAntBonemealCrops;
import erebus.entity.ai.EntityAIAntHarvestCrops;
import erebus.entity.ai.EntityAIAntPlantCrops;
import erebus.proxy.CommonProxy;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class EntityBlackAnt
extends EntityTameable
implements IInventory {
    private static final DataParameter<Integer> DROP_POINT_X = EntityDataManager.func_187226_a(EntityBlackAnt.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DROP_POINT_Y = EntityDataManager.func_187226_a(EntityBlackAnt.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DROP_POINT_Z = EntityDataManager.func_187226_a(EntityBlackAnt.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> TAME_TYPE = EntityDataManager.func_187226_a(EntityBlackAnt.class, (DataSerializer)DataSerializers.field_187191_a);
    public EntityAIPanic aiPanic;
    public EntityAIAntHarvestCrops aiHarvestCrops;
    public EntityAIAntPlantCrops aiPlantCrops;
    public EntityAIAntBonemealCrops aiBonemealCrops;
    public EntityAIWander aiWander;
    public boolean setAttributes;
    public boolean canPickupItems;
    public boolean canCollectFromSilo;
    public boolean canAddToSilo;
    public NonNullList<ItemStack> inventory;
    public static final int TOOL_SLOT = 0;
    public static final int CROP_ID_SLOT = 1;
    public static final int INVENTORY_SLOT = 2;
    private static final String[] names = new String[]{"Antwan", "George", "Geoff", "Alberto", "Jose", "Linda", "Chantelle", "Dave", "Basil", "Gertrude", "Herbert", "Russel", "Adam", "Gwen", "Billy Bob Joe Bob Joe Harrison Jr.", "Sid", "Dylan", "Jade"};

    public EntityBlackAnt(World world) {
        super(world);
        this.func_184644_a(PathNodeType.WATER, -8.0f);
        this.field_70138_W = 1.0f;
        this.setAttributes = false;
        this.canPickupItems = false;
        this.canAddToSilo = false;
        this.canCollectFromSilo = false;
        this.func_70105_a(0.9f, 0.4f);
        this.inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DROP_POINT_X, (Object)0);
        this.field_70180_af.func_187214_a(DROP_POINT_Y, (Object)0);
        this.field_70180_af.func_187214_a(DROP_POINT_Z, (Object)0);
        this.field_70180_af.func_187214_a(TAME_TYPE, (Object)0);
    }

    protected void func_184651_r() {
        this.aiPanic = new EntityAIPanic((EntityCreature)this, 0.8);
        this.aiHarvestCrops = new EntityAIAntHarvestCrops((EntityLivingBase)this, 0.6, 1);
        this.aiPlantCrops = new EntityAIAntPlantCrops((EntityLivingBase)this, 0.6, 4);
        this.aiBonemealCrops = new EntityAIAntBonemealCrops((EntityLivingBase)this, 0.6, 4);
        this.aiWander = new EntityAIWander((EntityCreature)this, 0.6);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiWander);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiPanic);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.6, ModItems.ANT_TAMING_AMULET, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.6, Items.field_151102_aT, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 15.0 : 15.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.FIRE_ANT_SOUND;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.FIRE_ANT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.SQUISH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public int func_70641_bl() {
        return 5;
    }

    protected boolean func_70692_ba() {
        return !this.func_70909_n();
    }

    public boolean func_70601_bi() {
        float light = this.func_70013_c();
        if (light >= 0.0f) {
            return this.func_70058_J();
        }
        return super.func_70601_bi();
    }

    public boolean func_70909_n() {
        return (Byte)this.field_70180_af.func_187225_a(TAME_TYPE) != 0;
    }

    public void func_70903_f(boolean tamed) {
        if (tamed) {
            this.field_70180_af.func_187227_b(TAME_TYPE, (Object)1);
            if (!this.func_145818_k_()) {
                this.func_96094_a(names[this.func_130014_f_().field_73012_v.nextInt(names.length)]);
            }
        } else {
            this.field_70180_af.func_187227_b(TAME_TYPE, (Object)0);
        }
    }

    public void openGUI(EntityPlayer player) {
        player.openGui((Object)Erebus.INSTANCE, CommonProxy.GuiID.ANT_INVENTORY.ordinal(), player.func_130014_f_(), this.func_145782_y(), 0, 0);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack is = player.field_71071_by.func_70448_g();
        if (!is.func_190926_b() && is.func_77973_b() == ModItems.ANT_TAMING_AMULET && is.func_77942_o() && is.func_77978_p().func_74764_b("homeX")) {
            this.setDropPoint(is.func_77978_p().func_74762_e("homeX"), is.func_77978_p().func_74762_e("homeY"), is.func_77978_p().func_74762_e("homeZ"));
            player.func_184609_a(hand);
            this.func_70903_f(true);
            this.func_70908_e(true);
            return true;
        }
        if (this.func_70909_n()) {
            this.func_174889_b(player);
            this.openGUI(player);
        }
        return super.func_184645_a(player, hand);
    }

    public void setBlockHarvested(Block block, int meta) {
        Random rand = new Random();
        if (block != null) {
            Utils.dropStack(this.func_130014_f_(), this.func_180425_c(), new ItemStack(block.func_180660_a(block.func_176203_a(meta), rand, 0), rand.nextInt(2) + 1));
            Utils.dropStack(this.func_130014_f_(), this.func_180425_c(), new ItemStack(block.func_180660_a(block.func_176223_P(), rand, 0), rand.nextInt(2) + 1));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K && !this.setAttributes) {
            if (this.func_70909_n()) {
                this.func_174889_b(null);
                this.func_174886_c(null);
            }
            this.setAttributes = true;
        }
    }

    protected void func_82160_b(boolean rencentHit, int fortune) {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            this.func_70099_a(stack, 0.0f);
        }
    }

    private void addToInventory(ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
            this.inventory.set(2, (Object)stack.func_77946_l());
            stack.func_190920_e(0);
        } else if (Utils.areStacksTheSame(stack, (ItemStack)this.inventory.get(2), false)) {
            int old = ((ItemStack)this.inventory.get(2)).func_190916_E();
            ((ItemStack)this.inventory.get(2)).func_190920_e(stack.func_190916_E() + old);
            if (((ItemStack)this.inventory.get(2)).func_190916_E() > ((ItemStack)this.inventory.get(2)).func_77976_d()) {
                ((ItemStack)this.inventory.get(2)).func_190920_e(((ItemStack)this.inventory.get(2)).func_77976_d());
            }
            int added = ((ItemStack)this.inventory.get(2)).func_190916_E() - old;
            stack.func_190918_g(added);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.func_70909_n()) {
            BlockPos pos;
            EntityItem entityitem;
            if (this.canPickupItems && !this.isFilterSlotEmpty() && (this.getAntInvSlotStack().func_190926_b() || this.getAntInvSlotStack().func_190916_E() < this.getAntInvSlotStack().func_77976_d()) && (entityitem = this.getClosestEntityItem((Entity)this, 16.0, this.getFilterSlotStack())) != null) {
                float distance = entityitem.func_70032_d((Entity)this);
                if (distance >= 2.0f && !entityitem.field_70128_L) {
                    double x = entityitem.field_70165_t;
                    double y = entityitem.field_70163_u;
                    double z = entityitem.field_70161_v;
                    this.func_70671_ap().func_75650_a(x, y, z, 20.0f, 8.0f);
                    this.moveToItem((Entity)entityitem);
                    return;
                }
                if (distance < 2.0f) {
                    this.func_70605_aq().func_75642_a(entityitem.field_70165_t, entityitem.field_70163_u, entityitem.field_70161_v, 0.5);
                    this.addToInventory(entityitem.func_92059_d());
                    if (entityitem.func_92059_d().func_190916_E() <= 0) {
                        entityitem.func_70106_y();
                    }
                    return;
                }
            }
            if (!this.isTaskSlotEmpty() && this.getTaskSlotStack().func_77973_b() instanceof ItemBucket && !this.isAntInvSlotEmpty() && this.getAntInvSlotStack().func_190916_E() > 15) {
                this.canAddToSilo = true;
                this.canPickupItems = false;
            }
            if (!this.canPickupItems && this.canAddToSilo) {
                this.moveToSilo();
                pos = new BlockPos(this.getDropPointX(), this.getDropPointY(), this.getDropPointZ());
                Block block = this.func_130014_f_().func_180495_p(pos).func_177230_c();
                if (block == ModBlocks.SILO_TANK && this.func_70011_f((double)this.getDropPointX() + 0.5, (double)this.getDropPointY() - 1.0, (double)this.getDropPointZ() + 0.5) < 2.0) {
                    this.addDropToInventory(pos);
                    if (this.isAntInvSlotEmpty()) {
                        this.canAddToSilo = false;
                        this.canPickupItems = true;
                    }
                }
            }
            if ((!this.isTaskSlotEmpty() && this.getTaskSlotStack().func_77973_b() instanceof ItemHoe || !this.isTaskSlotEmpty() && this.getTaskSlotStack().func_77973_b() == Items.field_151103_aS) && this.isAntInvSlotEmpty() && !this.isFilterSlotEmpty()) {
                this.canCollectFromSilo = true;
            }
            if (this.canCollectFromSilo) {
                this.moveToSilo();
                pos = new BlockPos(this.getDropPointX(), this.getDropPointY(), this.getDropPointZ());
                Block block = this.func_130014_f_().func_180495_p(pos).func_177230_c();
                if (block == ModBlocks.SILO_TANK && this.func_70011_f((double)this.getDropPointX() + 0.5, (double)this.getDropPointY() - 1.0, (double)this.getDropPointZ() + 0.5) < 2.0) {
                    this.getStackFromSilo();
                    this.canCollectFromSilo = false;
                }
            }
        }
    }

    private void getStackFromSilo() {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        BlockPos pos = new BlockPos(this.getDropPointX(), this.getDropPointY(), this.getDropPointZ());
        TileEntitySiloTank siloTile = (TileEntitySiloTank)this.func_130014_f_().func_175625_s(pos);
        if (siloTile != null && siloTile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
            IItemHandler handler = (IItemHandler)siloTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
            int sizeInventory = handler.getSlots();
            for (int i = 0; i < sizeInventory; ++i) {
                if (siloTile.func_70301_a(i).func_190926_b() || siloTile.func_70301_a(i).func_77973_b() != this.func_70301_a(1).func_77973_b() || siloTile.func_70301_a(i).func_77952_i() != this.func_70301_a(1).func_77952_i() || !this.isAntInvSlotEmpty()) continue;
                int collectStackSize = siloTile.func_70301_a(i).func_190916_E();
                this.func_70299_a(2, new ItemStack(siloTile.func_70301_a(i).func_77973_b(), collectStackSize, siloTile.func_70301_a(i).func_77952_i()));
                siloTile.func_70298_a(i, collectStackSize);
                return;
            }
        }
    }

    private void addDropToInventory(BlockPos pos) {
        ItemStack stack = this.getAntInvSlotStack();
        TileEntitySiloTank siloTile = (TileEntitySiloTank)this.func_130014_f_().func_175625_s(pos);
        if (!this.isAntInvSlotEmpty() && siloTile != null && siloTile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
            IItemHandler handler = (IItemHandler)siloTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
            if (!stack.func_190926_b()) {
                ItemStack stackNew = stack.func_77946_l();
                stackNew.func_190920_e(1);
                ItemStack stack1 = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stackNew, (boolean)true);
                if (stack1.func_190926_b()) {
                    ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)this.func_70298_a(2, 1), (boolean)false);
                    this.func_70296_d();
                }
            }
        }
    }

    public EntityItem getClosestEntityItem(final Entity entity, double d, ItemStack filter) {
        List list = this.func_130014_f_().func_72872_a(EntityItem.class, this.func_174813_aQ().func_72314_b(d, d, d));
        if (list.isEmpty()) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EntityItem item = (EntityItem)iterator.next();
            if (Utils.areStacksTheSame(filter, item.func_92059_d(), false)) continue;
            iterator.remove();
        }
        if (list.isEmpty()) {
            return null;
        }
        Collections.sort(list, new Comparator<EntityItem>(){

            @Override
            public int compare(EntityItem e1, EntityItem e2) {
                return Double.compare(e1.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v), e2.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
            }
        });
        return (EntityItem)list.get(0);
    }

    public void moveToItem(Entity entity) {
        Path pathentity = this.func_70661_as().func_75494_a(entity);
        if (pathentity != null) {
            this.func_70661_as().func_75484_a(pathentity, 0.5);
        }
    }

    public void moveToSilo() {
        Path pathentity = this.func_70661_as().func_75488_a((double)this.getDropPointX(), (double)(this.getDropPointY() - 1), (double)this.getDropPointZ());
        if (pathentity != null) {
            this.func_70661_as().func_75484_a(pathentity, 0.5);
        }
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack func_70298_a(int slot, int size) {
        if (!((ItemStack)this.inventory.get(slot)).func_190926_b()) {
            if (((ItemStack)this.inventory.get(slot)).func_190916_E() <= size) {
                ItemStack itemstack = (ItemStack)this.inventory.get(slot);
                this.inventory.set(slot, (Object)ItemStack.field_190927_a);
                return itemstack;
            }
            ItemStack itemstack = ((ItemStack)this.inventory.get(slot)).func_77979_a(size);
            if (((ItemStack)this.inventory.get(slot)).func_190916_E() == 0) {
                this.inventory.set(slot, (Object)ItemStack.field_190927_a);
            }
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.func_95999_t() : "container.antInventory";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.func_77973_b() == Items.field_151097_aZ || stack.func_77973_b() == Items.field_151133_ar || stack.func_77973_b() instanceof ItemHoe || stack.func_77973_b() == Items.field_151103_aS;
        }
        return true;
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        if (compound.func_74771_c("tamed") == 1) {
            this.func_70903_f(true);
        } else {
            this.func_70903_f(false);
        }
        this.setDropPoint(compound.func_74762_e("dropPointX"), compound.func_74762_e("dropPointY"), compound.func_74762_e("dropPointZ"));
        this.loadFromNbt(compound);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        super.func_189511_e(compound);
        if (this.func_70909_n()) {
            compound.func_74774_a("tamed", Byte.valueOf((byte)1).byteValue());
        } else {
            compound.func_74774_a("tamed", Byte.valueOf((byte)0).byteValue());
        }
        compound.func_74768_a("dropPointX", this.getDropPointX());
        compound.func_74768_a("dropPointY", this.getDropPointY());
        compound.func_74768_a("dropPointZ", this.getDropPointZ());
        return this.saveToNbt(compound);
    }

    public void loadFromNbt(NBTTagCompound compound) {
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (compound.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        }
    }

    public NBTTagCompound saveToNbt(NBTTagCompound compound) {
        ItemStackHelper.func_191281_a((NBTTagCompound)compound, this.inventory, (boolean)false);
        return compound;
    }

    public void func_174889_b(EntityPlayer player) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        this.canPickupItems = false;
        this.canAddToSilo = false;
        this.canCollectFromSilo = false;
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWander);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiPlantCrops);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiHarvestCrops);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiBonemealCrops);
    }

    public void func_174886_c(EntityPlayer player) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.isTaskSlotEmpty() && this.func_70909_n()) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiWander);
            this.field_70180_af.func_187227_b(TAME_TYPE, (Object)1);
        }
        if (!this.isTaskSlotEmpty() && this.getTaskSlotStack().func_77973_b() instanceof ItemHoe && !this.isFilterSlotEmpty()) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiPlantCrops);
            this.field_70180_af.func_187227_b(TAME_TYPE, (Object)2);
        }
        if (!this.isTaskSlotEmpty() && this.getTaskSlotStack().func_77973_b() instanceof ItemBucket && !this.isFilterSlotEmpty()) {
            this.canPickupItems = true;
            this.field_70180_af.func_187227_b(TAME_TYPE, (Object)3);
        }
        if (!this.isTaskSlotEmpty() && this.getTaskSlotStack().func_77973_b() instanceof ItemShears) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiHarvestCrops);
            this.field_70180_af.func_187227_b(TAME_TYPE, (Object)4);
        }
        if (!this.isTaskSlotEmpty() && this.getTaskSlotStack().func_77973_b() == Items.field_151103_aS && !this.isFilterSlotEmpty()) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiBonemealCrops);
            this.field_70180_af.func_187227_b(TAME_TYPE, (Object)5);
        }
    }

    public boolean isTaskSlotEmpty() {
        return this.getTaskSlotStack().func_190926_b();
    }

    public ItemStack getTaskSlotStack() {
        return this.func_70301_a(0);
    }

    public boolean isFilterSlotEmpty() {
        return this.getFilterSlotStack().func_190926_b();
    }

    public ItemStack getFilterSlotStack() {
        return this.func_70301_a(1);
    }

    public boolean isAntInvSlotEmpty() {
        return this.getAntInvSlotStack().func_190926_b();
    }

    public ItemStack getAntInvSlotStack() {
        return this.func_70301_a(2);
    }

    public void func_70296_d() {
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.equals(DamageSource.field_76368_d) || source.equals(DamageSource.field_76369_e)) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public void setDropPoint(int x, int y, int z) {
        this.field_70180_af.func_187227_b(DROP_POINT_X, (Object)x);
        this.field_70180_af.func_187227_b(DROP_POINT_Y, (Object)y);
        this.field_70180_af.func_187227_b(DROP_POINT_Z, (Object)z);
    }

    public int getDropPointX() {
        return (Integer)this.field_70180_af.func_187225_a(DROP_POINT_X);
    }

    public int getDropPointY() {
        return (Integer)this.field_70180_af.func_187225_a(DROP_POINT_Y);
    }

    public int getDropPointZ() {
        return (Integer)this.field_70180_af.func_187225_a(DROP_POINT_Z);
    }

    public byte getTamedType() {
        return (Byte)this.field_70180_af.func_187225_a(TAME_TYPE);
    }

    public EntityAgeable func_90011_a(EntityAgeable baby) {
        return null;
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_191420_l() {
        return false;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

