/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.Erebus;
import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.EntityFungalWeevil;
import erebus.entity.EntityPunchroom;
import erebus.entity.EntitySporeBall;
import erebus.entity.EntityZombieAnt;
import erebus.entity.EntityZombieAntSoldier;
import erebus.items.ItemMaterials;
import erebus.network.client.PacketParticle;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityCrushroom
extends EntityMob
implements IRangedAttackMob {
    private static final DataParameter<Integer> SMASH_COUNT = EntityDataManager.func_187226_a(EntityCrushroom.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> STANDING = EntityDataManager.func_187226_a(EntityCrushroom.class, (DataSerializer)DataSerializers.field_187191_a);
    private final EntityAIAttackRanged aiArrowAttack = new EntityAIAttackRanged((IRangedAttackMob)this, 0.75, 40, 12.0f);

    public EntityCrushroom(World world) {
        super(world);
        this.func_70105_a(3.3f, 4.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 200.0 : 200.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 6.0 : 6.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SMASH_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(STANDING, (Object)0);
    }

    public void func_70636_d() {
        if (this.func_130014_f_().field_72995_K) {
            Erebus.PROXY.spawnCustomParticle("spores", this.func_130014_f_(), this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 1.0 + this.field_70146_Z.nextDouble(), 1.0 + this.field_70146_Z.nextDouble(), 1.0 + this.field_70146_Z.nextDouble());
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() != null) {
            this.func_70625_a((Entity)this.func_70638_az(), 10.0f, 20.0f);
            double distance = this.func_70011_f(this.func_70638_az().field_70165_t, this.func_70638_az().func_174813_aQ().field_72338_b, this.func_70638_az().field_70161_v);
            if (distance > 5.0 && distance <= 12.0) {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiArrowAttack);
                if (this.getSmashCount() >= 1) {
                    this.setSmashCount(this.getSmashCount() - 1);
                    this.setStanding((byte)3);
                    if (this.getSmashCount() == 0) {
                        this.setStanding((byte)0);
                    }
                }
            }
            if (distance <= 5.0) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
                if (this.getSmashCount() < 20 && this.getStanding() != 3) {
                    this.setSmashCount(this.getSmashCount() + 1);
                    this.setStanding((byte)2);
                }
                if (this.getSmashCount() >= 20 && this.getStanding() == 2) {
                    this.setStanding((byte)3);
                    this.meleeAttackPlayer();
                }
                if (this.getSmashCount() >= 1 && this.getStanding() == 3) {
                    this.setSmashCount(this.getSmashCount() - 1);
                    if (this.getSmashCount() == 0) {
                        this.setStanding((byte)2);
                    }
                }
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() == null) {
            this.setStanding((byte)1);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
        }
        super.func_70636_d();
    }

    private void setStanding(byte state) {
        this.field_70180_af.func_187227_b(STANDING, (Object)state);
    }

    public byte getStanding() {
        return (Byte)this.field_70180_af.func_187225_a(STANDING);
    }

    private void setSmashCount(int count) {
        this.field_70180_af.func_187227_b(SMASH_COUNT, (Object)count);
    }

    public int getSmashCount() {
        return (Integer)this.field_70180_af.func_187225_a(SMASH_COUNT);
    }

    public boolean func_70601_bi() {
        float light = this.func_70013_c();
        if (light >= 0.0f) {
            return this.func_130014_f_().func_72855_b(this.func_174813_aQ()) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.func_130014_f_().func_72953_d(this.func_174813_aQ());
        }
        return super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 3;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.CRUSHLING_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damagesource) {
        return ModSounds.CRUSHLING_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.CRUSHLING_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 0.15f, 1.0f);
    }

    protected float func_70647_i() {
        return 0.1f;
    }

    protected void func_70628_a(boolean recentHit, int fortune) {
        int amount = this.field_70146_Z.nextInt(3);
        if (fortune > 0) {
            amount += this.field_70146_Z.nextInt(fortune + 1);
        }
        this.func_70099_a(ItemMaterials.EnumErebusMaterialsType.HIDE_SHROOM.createStack(amount), 0.0f);
    }

    public boolean func_70686_a(Class entity) {
        return EntityCrushroom.class != entity && EntityFungalWeevil.class != entity && EntityZombieAnt.class != entity && EntityZombieAntSoldier.class != entity && EntityPunchroom.class != entity;
    }

    public void func_82196_d(EntityLivingBase entity, float range) {
        EntitySporeBall sporeball = new EntitySporeBall(this.func_130014_f_(), (EntityLiving)this);
        double distanceX = entity.field_70165_t - this.field_70165_t;
        double distanceY = entity.field_70163_u + (double)this.field_70131_O - 4.0 - sporeball.field_70163_u;
        double distanceZ = entity.field_70161_v - this.field_70161_v;
        float height = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ)) * 0.2f;
        sporeball.func_70186_c(distanceX, distanceY + (double)height, distanceZ, 0.8f, 0.0f);
        this.func_130014_f_().func_184133_a(null, this.func_180425_c(), ModSounds.SPRAY_CAN_SOUND, SoundCategory.HOSTILE, 0.5f, 0.1f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.func_130014_f_().func_72838_d((Entity)sporeball);
    }

    private void meleeAttackPlayer() {
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az().func_174813_aQ().field_72337_e >= this.func_174813_aQ().field_72338_b - 1.0 && this.func_70638_az().func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72337_e && this.getSmashCount() == 20) {
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), ModSounds.BLAM_SOUND, SoundCategory.HOSTILE, 0.5f, 1.0f);
            this.spawnBlamParticles();
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 6.0 : 6.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier));
            this.func_70638_az().func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * 3.141593f / 180.0f))) * 0.5, 0.2, (double)MathHelper.func_76134_b((float)(this.field_70177_z * 3.141593f / 180.0f)) * 0.5);
        }
    }

    public void spawnBlamParticles() {
        if (!this.func_130014_f_().field_72995_K) {
            Erebus.NETWORK_WRAPPER.sendToAll((IMessage)new PacketParticle(PacketParticle.ParticleType.CRUSHROOM_BLAM, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v));
        }
    }

    public void func_184724_a(boolean swingingArms) {
    }
}

