/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.EntityGooBall;
import erebus.entity.ai.EntityAIErebusAttackMelee;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityVelvetWorm
extends EntityMob {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityVelvetWorm.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> INFLATE_SIZE = EntityDataManager.func_187226_a(EntityVelvetWorm.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityVelvetWorm(World world) {
        super(world);
        this.func_70105_a(2.0f, 0.7f);
        this.func_184644_a(PathNodeType.WATER, -8.0f);
        this.field_70728_aV = 15;
        this.field_70138_W = 1.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INFLATE_SIZE, (Object)new Integer(0));
        this.field_70180_af.func_187214_a(TYPE, (Object)new Integer(this.field_70146_Z.nextInt(2)));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIErebusAttackMelee((EntityCreature)this, 0.7, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 4.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 25.0 : 25.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? this.getAttackStrength() : this.getAttackStrength() * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    public boolean func_70601_bi() {
        float light = this.func_70013_c();
        if (light >= 0.0f) {
            return this.func_70058_J();
        }
        return super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 2;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70638_az() != null) {
            this.func_70625_a((Entity)this.func_70638_az(), 90.0f, 90.0f);
            float distance = (float)this.func_70011_f(this.func_70638_az().field_70165_t, this.func_70638_az().func_174813_aQ().field_72338_b, this.func_70638_az().field_70161_v);
            if (this.getInflateSize() < 100 && distance > 3.0f) {
                this.setInflateSize(this.getInflateSize() + 2);
            }
            if (this.getInflateSize() >= 100 && distance > 3.0f) {
                this.shootGooBall((Entity)this.func_70638_az(), distance);
            }
            if (this.getInflateSize() == 0) {
                // empty if block
            }
            this.forceCollideWithPlayer(this.func_70638_az(), distance);
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public void func_70110_aj() {
    }

    protected SoundEvent getWebSlingThrowSound() {
        return ModSounds.WEBSLING_THROW;
    }

    public double getAttackStrength() {
        switch (this.func_130014_f_().func_175659_aa()) {
            default: {
                return 4.0;
            }
            case EASY: {
                return 4.0;
            }
            case NORMAL: {
                return 5.0;
            }
            case HARD: 
        }
        return 6.0;
    }

    protected void func_70628_a(boolean hit, int looting) {
        int chanceFiftyFifty = this.field_70146_Z.nextInt(2) + 1;
        this.func_145779_a(Items.field_151123_aH, chanceFiftyFifty + looting);
    }

    protected void shootGooBall(Entity entity, float distance) {
        if (distance < 16.0f && entity instanceof EntityPlayer) {
            double targetX = entity.field_70165_t - this.field_70165_t;
            double targetY = entity.func_174813_aQ().field_72338_b + (double)entity.field_70131_O - (this.field_70163_u + (double)this.field_70131_O);
            double targetZ = entity.field_70161_v - this.field_70161_v;
            this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), this.getWebSlingThrowSound(), SoundCategory.HOSTILE, 1.0f, 1.0f);
            this.setInflateSize(0);
            EntityGooBall gooBall = new EntityGooBall(this.func_130014_f_(), (EntityLiving)this);
            gooBall.field_70163_u = this.field_70163_u + (double)this.field_70131_O + 0.3;
            gooBall.func_70186_c(targetX, targetY, targetZ, 1.0f, 0.0f);
            this.func_130014_f_().func_72838_d((Entity)gooBall);
        }
    }

    public void forceCollideWithPlayer(EntityLivingBase entity, float distance) {
        if (distance > 1.0f && distance < 6.0f && this.field_70122_E) {
            double distanceX = entity.field_70165_t - this.field_70165_t;
            double distanceZ = entity.field_70161_v - this.field_70161_v;
            float squareRoot = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ));
            this.field_70159_w = distanceX / (double)squareRoot * 0.5 * 0.300000011920929 + this.field_70159_w * 0.10000000298023223;
            this.field_70179_y = distanceZ / (double)squareRoot * 0.5 * 0.300000011920929 + this.field_70179_y * 0.10000000298023223;
            this.field_70181_x = 0.0;
        }
    }

    public void setInflateSize(int size) {
        this.field_70180_af.func_187227_b(INFLATE_SIZE, (Object)size);
    }

    public int getInflateSize() {
        return (Integer)this.field_70180_af.func_187225_a(INFLATE_SIZE);
    }

    public void setSkin(int skinType) {
        this.field_70180_af.func_187227_b(TYPE, (Object)skinType);
    }

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("skin", this.getSkin());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("skin")) {
            this.setSkin(nbt.func_74762_e("skin"));
        } else {
            this.setSkin(this.field_70146_Z.nextInt(2));
        }
    }
}

