/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity.ai;

import erebus.core.helper.Spiral;
import java.awt.Point;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public abstract class EntityAIFindFlower
extends EntityAIBase {
    private static final int CHECKS_PER_TICK = 6;
    private final int COLLECT_SPEED;
    protected final EntityLiving entity;
    private final IBlockState blockState;
    protected boolean hasTarget;
    public int flowerX;
    public int flowerY;
    public int flowerZ;
    private int spiralIndex;
    private int collectTicks;
    private static final List<Point> spiral = new Spiral(32, 32).spiral();

    public EntityAIFindFlower(EntityLiving entity, IBlockState state, int pollinateSpeed) {
        this.entity = entity;
        this.blockState = state;
        this.hasTarget = false;
        this.spiralIndex = 0;
        this.COLLECT_SPEED = pollinateSpeed * 20;
    }

    public boolean func_75250_a() {
        return !this.hasTarget;
    }

    public boolean func_75253_b() {
        return true;
    }

    public void func_75246_d() {
        if (!this.func_75253_b()) {
            return;
        }
        int xCoord = (int)this.entity.field_70165_t;
        int yCoord = (int)this.entity.field_70163_u;
        int zCoord = (int)this.entity.field_70161_v;
        for (int i = 0; i < 6; ++i) {
            boolean flag;
            if (!this.hasTarget) {
                this.increment();
                Point p = this.getNextPoint();
                for (int y = -16; y < 16; ++y) {
                    if (!this.canPolinate(this.entity.func_130014_f_().func_180495_p(new BlockPos(xCoord + p.x, yCoord + y, zCoord + p.y)))) continue;
                    this.flowerX = xCoord + p.x;
                    this.flowerY = yCoord + y;
                    this.flowerZ = zCoord + p.y;
                    this.hasTarget = true;
                }
                continue;
            }
            if (!this.isEntityReady()) continue;
            this.moveToLocation();
            this.entity.func_70671_ap().func_75650_a((double)this.flowerX + 0.5, (double)this.flowerY + 0.5, (double)this.flowerZ + 0.5, 30.0f, 8.0f);
            AxisAlignedBB blockbounds = this.getBlockAABB(this.flowerX, this.flowerY, this.flowerZ);
            boolean bl = flag = this.entity.func_174813_aQ().field_72337_e >= blockbounds.field_72338_b && this.entity.func_174813_aQ().field_72338_b <= blockbounds.field_72337_e + 0.25 && this.entity.func_174813_aQ().field_72336_d >= blockbounds.field_72340_a && this.entity.func_174813_aQ().field_72340_a <= blockbounds.field_72336_d && this.entity.func_174813_aQ().field_72334_f >= blockbounds.field_72339_c && this.entity.func_174813_aQ().field_72339_c <= blockbounds.field_72334_f;
            if (flag) {
                this.prepareToPollinate();
                ++this.collectTicks;
                if (!this.canPolinate(this.entity.func_130014_f_().func_180495_p(new BlockPos(this.flowerX, this.flowerY, this.flowerZ)))) {
                    this.hasTarget = false;
                    return;
                }
                if (this.COLLECT_SPEED <= this.collectTicks) {
                    this.hasTarget = false;
                    this.collectTicks = 0;
                    this.afterPollination();
                    return;
                }
            }
            if (flag || this.collectTicks <= 1) continue;
            this.pollinationInterupted();
            this.hasTarget = false;
            this.collectTicks = 0;
            return;
        }
    }

    private int getScaledcollectTicks() {
        return (int)((float)this.collectTicks / (float)this.COLLECT_SPEED * 10.0f);
    }

    private void increment() {
        ++this.spiralIndex;
        if (this.spiralIndex >= spiral.size()) {
            this.spiralIndex = 0;
        }
    }

    private Point getNextPoint() {
        return spiral.get(this.spiralIndex);
    }

    public Block getTargetBlockID() {
        return this.entity.func_130014_f_().func_180495_p(new BlockPos(this.flowerX, this.flowerY, this.flowerZ)).func_177230_c();
    }

    protected boolean canPolinate(IBlockState state) {
        return state == this.blockState;
    }

    protected abstract boolean isEntityReady();

    protected abstract void moveToLocation();

    protected abstract void prepareToPollinate();

    protected abstract void pollinationInterupted();

    protected abstract void afterPollination();

    protected AxisAlignedBB getBlockAABB(int x, int y, int z) {
        return new AxisAlignedBB((double)this.flowerX, (double)this.flowerY, (double)this.flowerZ, (double)this.flowerX + 1.0, (double)this.flowerY + 1.0, (double)this.flowerZ + 1.0);
    }
}

